/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import androidx.annotation.Nullable;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.ViewManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ViewManagerRegistry {
    private final Map<String, ViewManager> mViewManagers;
    @Nullable
    private final UIManagerModule.ViewManagerResolver mViewManagerResolver;

    public ViewManagerRegistry(UIManagerModule.ViewManagerResolver viewManagerResolver) {
        this.mViewManagers = MapBuilder.newHashMap();
        this.mViewManagerResolver = viewManagerResolver;
    }

    public ViewManagerRegistry(List<ViewManager> viewManagerList) {
        HashMap<String, ViewManager> viewManagerMap = MapBuilder.newHashMap();
        for (ViewManager viewManager : viewManagerList) {
            viewManagerMap.put(viewManager.getName(), viewManager);
        }
        this.mViewManagers = viewManagerMap;
        this.mViewManagerResolver = null;
    }

    public ViewManagerRegistry(Map<String, ViewManager> viewManagerMap) {
        this.mViewManagers = viewManagerMap != null ? viewManagerMap : MapBuilder.newHashMap();
        this.mViewManagerResolver = null;
    }

    public ViewManager get(String className) {
        ViewManager viewManager = this.mViewManagers.get(className);
        if (viewManager != null) {
            return viewManager;
        }
        if (this.mViewManagerResolver != null) {
            viewManager = this.getViewManagerFromResolver(className);
            if (viewManager != null) {
                return viewManager;
            }
            throw new IllegalViewOperationException("ViewManagerResolver returned null for " + className);
        }
        throw new IllegalViewOperationException("No ViewManager found for class " + className);
    }

    @Nullable
    private ViewManager getViewManagerFromResolver(String className) {
        ViewManager viewManager = this.mViewManagerResolver.getViewManager(className);
        if (viewManager != null) {
            this.mViewManagers.put(className, viewManager);
        }
        return viewManager;
    }

    @Nullable
    ViewManager getViewManagerIfExists(String className) {
        ViewManager viewManager = this.mViewManagers.get(className);
        if (viewManager != null) {
            return viewManager;
        }
        if (this.mViewManagerResolver != null) {
            return this.getViewManagerFromResolver(className);
        }
        return null;
    }
}

