/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.WritableNativeMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class DisplayMetricsHolder {
    @Nullable
    private static DisplayMetrics sWindowDisplayMetrics;
    @Nullable
    private static DisplayMetrics sScreenDisplayMetrics;

    public static void setWindowDisplayMetrics(DisplayMetrics displayMetrics) {
        sWindowDisplayMetrics = displayMetrics;
    }

    public static void initDisplayMetricsIfNotInitialized(Context context) {
        if (DisplayMetricsHolder.getScreenDisplayMetrics() != null) {
            return;
        }
        DisplayMetricsHolder.initDisplayMetrics(context);
    }

    public static void initDisplayMetrics(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        DisplayMetricsHolder.setWindowDisplayMetrics(displayMetrics);
        DisplayMetrics screenDisplayMetrics = new DisplayMetrics();
        screenDisplayMetrics.setTo(displayMetrics);
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Assertions.assertNotNull((Object)wm, (String)"WindowManager is null!");
        Display display = wm.getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 17) {
            display.getRealMetrics(screenDisplayMetrics);
        } else {
            try {
                Method mGetRawH = Display.class.getMethod("getRawHeight", new Class[0]);
                Method mGetRawW = Display.class.getMethod("getRawWidth", new Class[0]);
                screenDisplayMetrics.widthPixels = (Integer)mGetRawW.invoke((Object)display, new Object[0]);
                screenDisplayMetrics.heightPixels = (Integer)mGetRawH.invoke((Object)display, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Error getting real dimensions for API level < 17", e);
            }
        }
        DisplayMetricsHolder.setScreenDisplayMetrics(screenDisplayMetrics);
    }

    @Deprecated
    public static DisplayMetrics getWindowDisplayMetrics() {
        return sWindowDisplayMetrics;
    }

    public static void setScreenDisplayMetrics(DisplayMetrics screenDisplayMetrics) {
        sScreenDisplayMetrics = screenDisplayMetrics;
    }

    public static DisplayMetrics getScreenDisplayMetrics() {
        return sScreenDisplayMetrics;
    }

    public static Map<String, Map<String, Object>> getDisplayMetricsMap(double fontScale) {
        Assertions.assertNotNull((Object)(sWindowDisplayMetrics != null || sScreenDisplayMetrics != null ? 1 : 0), (String)"DisplayMetricsHolder must be initialized with initDisplayMetricsIfNotInitialized or initDisplayMetrics");
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        result.put("windowPhysicalPixels", DisplayMetricsHolder.getPhysicalPixelsMap(sWindowDisplayMetrics, fontScale));
        result.put("screenPhysicalPixels", DisplayMetricsHolder.getPhysicalPixelsMap(sScreenDisplayMetrics, fontScale));
        return result;
    }

    public static WritableNativeMap getDisplayMetricsNativeMap(double fontScale) {
        Assertions.assertNotNull((Object)(sWindowDisplayMetrics != null || sScreenDisplayMetrics != null ? 1 : 0), (String)"DisplayMetricsHolder must be initialized with initDisplayMetricsIfNotInitialized or initDisplayMetrics");
        WritableNativeMap result = new WritableNativeMap();
        result.putMap("windowPhysicalPixels", DisplayMetricsHolder.getPhysicalPixelsNativeMap(sWindowDisplayMetrics, fontScale));
        result.putMap("screenPhysicalPixels", DisplayMetricsHolder.getPhysicalPixelsNativeMap(sScreenDisplayMetrics, fontScale));
        return result;
    }

    private static Map<String, Object> getPhysicalPixelsMap(DisplayMetrics displayMetrics, double fontScale) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("width", displayMetrics.widthPixels);
        result.put("height", displayMetrics.heightPixels);
        result.put("scale", Float.valueOf(displayMetrics.density));
        result.put("fontScale", fontScale);
        result.put("densityDpi", displayMetrics.densityDpi);
        return result;
    }

    private static WritableNativeMap getPhysicalPixelsNativeMap(DisplayMetrics displayMetrics, double fontScale) {
        WritableNativeMap result = new WritableNativeMap();
        result.putInt("width", displayMetrics.widthPixels);
        result.putInt("height", displayMetrics.heightPixels);
        result.putDouble("scale", displayMetrics.density);
        result.putDouble("fontScale", fontScale);
        result.putDouble("densityDpi", displayMetrics.densityDpi);
        return result;
    }
}

