/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.packagerconnection;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;

public final class ReconnectingWebSocket
extends WebSocketListener {
    private static final String TAG = ReconnectingWebSocket.class.getSimpleName();
    private static final int RECONNECT_DELAY_MS = 2000;
    private final String mUrl;
    private final Handler mHandler;
    private boolean mClosed = false;
    private boolean mSuppressConnectionErrors;
    @Nullable
    private WebSocket mWebSocket;
    @Nullable
    private MessageCallback mMessageCallback;
    @Nullable
    private ConnectionCallback mConnectionCallback;

    public ReconnectingWebSocket(String url, MessageCallback messageCallback, ConnectionCallback connectionCallback) {
        this.mUrl = url;
        this.mMessageCallback = messageCallback;
        this.mConnectionCallback = connectionCallback;
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    public void connect() {
        if (this.mClosed) {
            throw new IllegalStateException("Can't connect closed client");
        }
        OkHttpClient httpClient = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.MINUTES).build();
        Request request = new Request.Builder().url(this.mUrl).build();
        httpClient.newWebSocket(request, (WebSocketListener)this);
    }

    private synchronized void delayedReconnect() {
        if (!this.mClosed) {
            this.connect();
        }
    }

    private void reconnect() {
        if (this.mClosed) {
            throw new IllegalStateException("Can't reconnect closed client");
        }
        if (!this.mSuppressConnectionErrors) {
            FLog.w((String)TAG, (String)("Couldn't connect to \"" + this.mUrl + "\", will silently retry"));
            this.mSuppressConnectionErrors = true;
        }
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                ReconnectingWebSocket.this.delayedReconnect();
            }
        }, 2000L);
    }

    public void closeQuietly() {
        this.mClosed = true;
        this.closeWebSocketQuietly();
        this.mMessageCallback = null;
        if (this.mConnectionCallback != null) {
            this.mConnectionCallback.onDisconnected();
        }
    }

    private void closeWebSocketQuietly() {
        if (this.mWebSocket != null) {
            try {
                this.mWebSocket.close(1000, "End of session");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mWebSocket = null;
        }
    }

    private void abort(String message, Throwable cause) {
        FLog.e((String)TAG, (String)("Error occurred, shutting down websocket connection: " + message), (Throwable)cause);
        this.closeWebSocketQuietly();
    }

    public synchronized void onOpen(WebSocket webSocket, Response response) {
        this.mWebSocket = webSocket;
        this.mSuppressConnectionErrors = false;
        if (this.mConnectionCallback != null) {
            this.mConnectionCallback.onConnected();
        }
    }

    public synchronized void onFailure(WebSocket webSocket, Throwable t, Response response) {
        if (this.mWebSocket != null) {
            this.abort("Websocket exception", t);
        }
        if (!this.mClosed) {
            if (this.mConnectionCallback != null) {
                this.mConnectionCallback.onDisconnected();
            }
            this.reconnect();
        }
    }

    public synchronized void onMessage(WebSocket webSocket, String text) {
        if (this.mMessageCallback != null) {
            this.mMessageCallback.onMessage(text);
        }
    }

    public synchronized void onMessage(WebSocket webSocket, ByteString bytes) {
        if (this.mMessageCallback != null) {
            this.mMessageCallback.onMessage(bytes);
        }
    }

    public synchronized void onClosed(WebSocket webSocket, int code, String reason) {
        this.mWebSocket = null;
        if (!this.mClosed) {
            if (this.mConnectionCallback != null) {
                this.mConnectionCallback.onDisconnected();
            }
            this.reconnect();
        }
    }

    public synchronized void sendMessage(String message) throws IOException {
        if (this.mWebSocket == null) {
            throw new ClosedChannelException();
        }
        this.mWebSocket.send(message);
    }

    public synchronized void sendMessage(ByteString message) throws IOException {
        if (this.mWebSocket == null) {
            throw new ClosedChannelException();
        }
        this.mWebSocket.send(message);
    }

    public static interface ConnectionCallback {
        public void onConnected();

        public void onDisconnected();
    }

    public static interface MessageCallback {
        public void onMessage(String var1);

        public void onMessage(ByteString var1);
    }
}

