/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.DynamicFromMap;
import com.facebook.react.bridge.JavaOnlyArray;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.bridge.WritableMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class JavaOnlyMap
implements ReadableMap,
WritableMap {
    private final Map mBackingMap;

    public static JavaOnlyMap of(Object ... keysAndValues) {
        return new JavaOnlyMap(keysAndValues);
    }

    public static JavaOnlyMap deepClone(ReadableMap map) {
        JavaOnlyMap res = new JavaOnlyMap();
        ReadableMapKeySetIterator iter = map.keySetIterator();
        while (iter.hasNextKey()) {
            String propKey = iter.nextKey();
            ReadableType type = map.getType(propKey);
            switch (type) {
                case Null: {
                    res.putNull(propKey);
                    break;
                }
                case Boolean: {
                    res.putBoolean(propKey, map.getBoolean(propKey));
                    break;
                }
                case Number: {
                    res.putDouble(propKey, map.getDouble(propKey));
                    break;
                }
                case String: {
                    res.putString(propKey, map.getString(propKey));
                    break;
                }
                case Map: {
                    res.putMap(propKey, JavaOnlyMap.deepClone(map.getMap(propKey)));
                    break;
                }
                case Array: {
                    res.putArray(propKey, JavaOnlyArray.deepClone(map.getArray(propKey)));
                }
            }
        }
        return res;
    }

    private JavaOnlyMap(Object ... keysAndValues) {
        if (keysAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("You must provide the same number of keys and values");
        }
        this.mBackingMap = new HashMap();
        for (int i = 0; i < keysAndValues.length; i += 2) {
            Object val = keysAndValues[i + 1];
            if (val instanceof Number) {
                val = ((Number)val).doubleValue();
            }
            this.mBackingMap.put(keysAndValues[i], val);
        }
    }

    public JavaOnlyMap() {
        this.mBackingMap = new HashMap();
    }

    @Override
    public boolean hasKey(@NonNull String name) {
        return this.mBackingMap.containsKey(name);
    }

    @Override
    public boolean isNull(@NonNull String name) {
        return this.mBackingMap.get(name) == null;
    }

    @Override
    public boolean getBoolean(@NonNull String name) {
        return (Boolean)this.mBackingMap.get(name);
    }

    @Override
    public double getDouble(@NonNull String name) {
        return ((Number)this.mBackingMap.get(name)).doubleValue();
    }

    @Override
    public int getInt(@NonNull String name) {
        return ((Number)this.mBackingMap.get(name)).intValue();
    }

    @Override
    public String getString(@NonNull String name) {
        return (String)this.mBackingMap.get(name);
    }

    @Override
    public ReadableMap getMap(@NonNull String name) {
        return (ReadableMap)this.mBackingMap.get(name);
    }

    @Override
    public ReadableArray getArray(@NonNull String name) {
        return (ReadableArray)this.mBackingMap.get(name);
    }

    @Override
    @NonNull
    public Dynamic getDynamic(@NonNull String name) {
        return DynamicFromMap.create(this, name);
    }

    @Override
    @NonNull
    public ReadableType getType(@NonNull String name) {
        Object value = this.mBackingMap.get(name);
        if (value == null) {
            return ReadableType.Null;
        }
        if (value instanceof Number) {
            return ReadableType.Number;
        }
        if (value instanceof String) {
            return ReadableType.String;
        }
        if (value instanceof Boolean) {
            return ReadableType.Boolean;
        }
        if (value instanceof ReadableMap) {
            return ReadableType.Map;
        }
        if (value instanceof ReadableArray) {
            return ReadableType.Array;
        }
        if (value instanceof Dynamic) {
            return ((Dynamic)value).getType();
        }
        throw new IllegalArgumentException("Invalid value " + value.toString() + " for key " + name + "contained in JavaOnlyMap");
    }

    @Override
    @NonNull
    public Iterator<Map.Entry<String, Object>> getEntryIterator() {
        return this.mBackingMap.entrySet().iterator();
    }

    @Override
    @NonNull
    public ReadableMapKeySetIterator keySetIterator() {
        return new ReadableMapKeySetIterator(){
            Iterator<Map.Entry<String, Object>> mIterator;
            {
                this.mIterator = JavaOnlyMap.this.mBackingMap.entrySet().iterator();
            }

            @Override
            public boolean hasNextKey() {
                return this.mIterator.hasNext();
            }

            @Override
            public String nextKey() {
                return this.mIterator.next().getKey();
            }
        };
    }

    @Override
    public void putBoolean(@NonNull String key, boolean value) {
        this.mBackingMap.put(key, value);
    }

    @Override
    public void putDouble(@NonNull String key, double value) {
        this.mBackingMap.put(key, value);
    }

    @Override
    public void putInt(@NonNull String key, int value) {
        this.mBackingMap.put(key, new Double(value));
    }

    @Override
    public void putString(@NonNull String key, @Nullable String value) {
        this.mBackingMap.put(key, value);
    }

    @Override
    public void putNull(@NonNull String key) {
        this.mBackingMap.put(key, null);
    }

    @Override
    public void putMap(@NonNull String key, @Nullable ReadableMap value) {
        this.mBackingMap.put(key, value);
    }

    @Override
    public void merge(@NonNull ReadableMap source) {
        this.mBackingMap.putAll(((JavaOnlyMap)source).mBackingMap);
    }

    @Override
    public WritableMap copy() {
        JavaOnlyMap target = new JavaOnlyMap();
        target.merge(this);
        return target;
    }

    @Override
    public void putArray(@NonNull String key, @Nullable ReadableArray value) {
        this.mBackingMap.put(key, value);
    }

    @Override
    @NonNull
    public HashMap<String, Object> toHashMap() {
        return new HashMap<String, Object>(this.mBackingMap);
    }

    public String toString() {
        return this.mBackingMap.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaOnlyMap that = (JavaOnlyMap)o;
        return !(this.mBackingMap != null ? !this.mBackingMap.equals(that.mBackingMap) : that.mBackingMap != null);
    }

    public int hashCode() {
        return this.mBackingMap != null ? this.mBackingMap.hashCode() : 0;
    }
}

