/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.views.text.TextTransform;

public class TextAttributes {
    public static final float DEFAULT_MAX_FONT_SIZE_MULTIPLIER = 0.0f;
    private boolean mAllowFontScaling = true;
    private float mFontSize = Float.NaN;
    private float mLineHeight = Float.NaN;
    private float mLetterSpacing = Float.NaN;
    private float mMaxFontSizeMultiplier = Float.NaN;
    private float mHeightOfTallestInlineViewOrImage = Float.NaN;
    private TextTransform mTextTransform = TextTransform.UNSET;

    public TextAttributes applyChild(TextAttributes child) {
        TextAttributes result = new TextAttributes();
        result.mAllowFontScaling = this.mAllowFontScaling;
        result.mFontSize = !Float.isNaN(child.mFontSize) ? child.mFontSize : this.mFontSize;
        result.mLineHeight = !Float.isNaN(child.mLineHeight) ? child.mLineHeight : this.mLineHeight;
        result.mLetterSpacing = !Float.isNaN(child.mLetterSpacing) ? child.mLetterSpacing : this.mLetterSpacing;
        result.mMaxFontSizeMultiplier = !Float.isNaN(child.mMaxFontSizeMultiplier) ? child.mMaxFontSizeMultiplier : this.mMaxFontSizeMultiplier;
        result.mHeightOfTallestInlineViewOrImage = !Float.isNaN(child.mHeightOfTallestInlineViewOrImage) ? child.mHeightOfTallestInlineViewOrImage : this.mHeightOfTallestInlineViewOrImage;
        result.mTextTransform = child.mTextTransform != TextTransform.UNSET ? child.mTextTransform : this.mTextTransform;
        return result;
    }

    public boolean getAllowFontScaling() {
        return this.mAllowFontScaling;
    }

    public void setAllowFontScaling(boolean value) {
        this.mAllowFontScaling = value;
    }

    public float getFontSize() {
        return this.mFontSize;
    }

    public void setFontSize(float value) {
        this.mFontSize = value;
    }

    public float getLineHeight() {
        return this.mLineHeight;
    }

    public void setLineHeight(float value) {
        this.mLineHeight = value;
    }

    public float getLetterSpacing() {
        return this.mLetterSpacing;
    }

    public void setLetterSpacing(float value) {
        this.mLetterSpacing = value;
    }

    public float getMaxFontSizeMultiplier() {
        return this.mMaxFontSizeMultiplier;
    }

    public void setMaxFontSizeMultiplier(float maxFontSizeMultiplier) {
        if (maxFontSizeMultiplier != 0.0f && maxFontSizeMultiplier < 1.0f) {
            throw new JSApplicationIllegalArgumentException("maxFontSizeMultiplier must be NaN, 0, or >= 1");
        }
        this.mMaxFontSizeMultiplier = maxFontSizeMultiplier;
    }

    public float getHeightOfTallestInlineViewOrImage() {
        return this.mHeightOfTallestInlineViewOrImage;
    }

    public void setHeightOfTallestInlineViewOrImage(float value) {
        this.mHeightOfTallestInlineViewOrImage = value;
    }

    public TextTransform getTextTransform() {
        return this.mTextTransform;
    }

    public void setTextTransform(TextTransform textTransform) {
        this.mTextTransform = textTransform;
    }

    public int getEffectiveFontSize() {
        float fontSize = !Float.isNaN(this.mFontSize) ? this.mFontSize : 14.0f;
        return this.mAllowFontScaling ? (int)Math.ceil(PixelUtil.toPixelFromSP(fontSize, this.getEffectiveMaxFontSizeMultiplier())) : (int)Math.ceil(PixelUtil.toPixelFromDIP(fontSize));
    }

    public float getEffectiveLineHeight() {
        if (Float.isNaN(this.mLineHeight)) {
            return Float.NaN;
        }
        float lineHeight = this.mAllowFontScaling ? PixelUtil.toPixelFromSP(this.mLineHeight, this.getEffectiveMaxFontSizeMultiplier()) : PixelUtil.toPixelFromDIP(this.mLineHeight);
        boolean useInlineViewHeight = !Float.isNaN(this.mHeightOfTallestInlineViewOrImage) && this.mHeightOfTallestInlineViewOrImage > lineHeight;
        return useInlineViewHeight ? this.mHeightOfTallestInlineViewOrImage : lineHeight;
    }

    public float getEffectiveLetterSpacing() {
        if (Float.isNaN(this.mLetterSpacing)) {
            return Float.NaN;
        }
        float letterSpacingPixels = this.mAllowFontScaling ? PixelUtil.toPixelFromSP(this.mLetterSpacing, this.getEffectiveMaxFontSizeMultiplier()) : PixelUtil.toPixelFromDIP(this.mLetterSpacing);
        return letterSpacingPixels / (float)this.getEffectiveFontSize();
    }

    public float getEffectiveMaxFontSizeMultiplier() {
        return !Float.isNaN(this.mMaxFontSizeMultiplier) ? this.mMaxFontSizeMultiplier : 0.0f;
    }

    public String toString() {
        return "TextAttributes {\n  getAllowFontScaling(): " + this.getAllowFontScaling() + "\n  getFontSize(): " + this.getFontSize() + "\n  getEffectiveFontSize(): " + this.getEffectiveFontSize() + "\n  getHeightOfTallestInlineViewOrImage(): " + this.getHeightOfTallestInlineViewOrImage() + "\n  getLetterSpacing(): " + this.getLetterSpacing() + "\n  getEffectiveLetterSpacing(): " + this.getEffectiveLetterSpacing() + "\n  getLineHeight(): " + this.getLineHeight() + "\n  getEffectiveLineHeight(): " + this.getEffectiveLineHeight() + "\n  getTextTransform(): " + (Object)((Object)this.getTextTransform()) + "\n  getMaxFontSizeMultiplier(): " + this.getMaxFontSizeMultiplier() + "\n  getEffectiveMaxFontSizeMultiplier(): " + this.getEffectiveMaxFontSizeMultiplier() + "\n}";
    }
}

