/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.PixelUtil;
import java.util.Map;

public class ReactScrollViewCommandHelper {
    public static final int COMMAND_SCROLL_TO = 1;
    public static final int COMMAND_SCROLL_TO_END = 2;
    public static final int COMMAND_FLASH_SCROLL_INDICATORS = 3;

    public static Map<String, Integer> getCommandsMap() {
        return MapBuilder.of("scrollTo", 1, "scrollToEnd", 2, "flashScrollIndicators", 3);
    }

    public static <T> void receiveCommand(ScrollCommandHandler<T> viewManager, T scrollView, int commandType, @Nullable ReadableArray args) {
        Assertions.assertNotNull(viewManager);
        Assertions.assertNotNull(scrollView);
        Assertions.assertNotNull((Object)args);
        switch (commandType) {
            case 1: {
                ReactScrollViewCommandHelper.scrollTo(viewManager, scrollView, args);
                return;
            }
            case 2: {
                ReactScrollViewCommandHelper.scrollToEnd(viewManager, scrollView, args);
                return;
            }
            case 3: {
                viewManager.flashScrollIndicators(scrollView);
                return;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported command %d received by %s.", commandType, viewManager.getClass().getSimpleName()));
    }

    public static <T> void receiveCommand(ScrollCommandHandler<T> viewManager, T scrollView, String commandType, @Nullable ReadableArray args) {
        Assertions.assertNotNull(viewManager);
        Assertions.assertNotNull(scrollView);
        Assertions.assertNotNull((Object)args);
        switch (commandType) {
            case "scrollTo": {
                ReactScrollViewCommandHelper.scrollTo(viewManager, scrollView, args);
                return;
            }
            case "scrollToEnd": {
                ReactScrollViewCommandHelper.scrollToEnd(viewManager, scrollView, args);
                return;
            }
            case "flashScrollIndicators": {
                viewManager.flashScrollIndicators(scrollView);
                return;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported command %s received by %s.", commandType, viewManager.getClass().getSimpleName()));
    }

    private static <T> void scrollTo(ScrollCommandHandler<T> viewManager, T scrollView, @Nullable ReadableArray args) {
        int destX = Math.round(PixelUtil.toPixelFromDIP(args.getDouble(0)));
        int destY = Math.round(PixelUtil.toPixelFromDIP(args.getDouble(1)));
        boolean animated = args.getBoolean(2);
        viewManager.scrollTo(scrollView, new ScrollToCommandData(destX, destY, animated));
    }

    private static <T> void scrollToEnd(ScrollCommandHandler<T> viewManager, T scrollView, @Nullable ReadableArray args) {
        boolean animated = args.getBoolean(0);
        viewManager.scrollToEnd(scrollView, new ScrollToEndCommandData(animated));
    }

    public static class ScrollToEndCommandData {
        public final boolean mAnimated;

        ScrollToEndCommandData(boolean animated) {
            this.mAnimated = animated;
        }
    }

    public static class ScrollToCommandData {
        public final int mDestX;
        public final int mDestY;
        public final boolean mAnimated;

        ScrollToCommandData(int destX, int destY, boolean animated) {
            this.mDestX = destX;
            this.mDestY = destY;
            this.mAnimated = animated;
        }
    }

    public static interface ScrollCommandHandler<T> {
        public void scrollTo(T var1, ScrollToCommandData var2);

        public void scrollToEnd(T var1, ScrollToEndCommandData var2);

        public void flashScrollIndicators(T var1);
    }
}

