/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.image;

import androidx.annotation.Nullable;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.RCTEventEmitter;

public class ImageLoadEvent
extends Event<ImageLoadEvent> {
    public static final int ON_ERROR = 1;
    public static final int ON_LOAD = 2;
    public static final int ON_LOAD_END = 3;
    public static final int ON_LOAD_START = 4;
    public static final int ON_PROGRESS = 5;
    private final int mEventType;
    @Nullable
    private final String mImageUri;
    private final int mWidth;
    private final int mHeight;
    @Nullable
    private final String mImageError;

    public ImageLoadEvent(int viewId, int eventType) {
        this(viewId, eventType, null);
    }

    public ImageLoadEvent(int viewId, int eventType, boolean error, String message) {
        this(viewId, eventType, null, 0, 0, message);
    }

    public ImageLoadEvent(int viewId, int eventType, String imageUri) {
        this(viewId, eventType, imageUri, 0, 0, null);
    }

    public ImageLoadEvent(int viewId, int eventType, @Nullable String imageUri, int width, int height) {
        this(viewId, eventType, imageUri, width, height, null);
    }

    public ImageLoadEvent(int viewId, int eventType, @Nullable String imageUri, int width, int height, @Nullable String message) {
        super(viewId);
        this.mEventType = eventType;
        this.mImageUri = imageUri;
        this.mWidth = width;
        this.mHeight = height;
        this.mImageError = message;
    }

    public static String eventNameForType(int eventType) {
        switch (eventType) {
            case 1: {
                return "topError";
            }
            case 2: {
                return "topLoad";
            }
            case 3: {
                return "topLoadEnd";
            }
            case 4: {
                return "topLoadStart";
            }
            case 5: {
                return "topProgress";
            }
        }
        throw new IllegalStateException("Invalid image event: " + Integer.toString(eventType));
    }

    @Override
    public String getEventName() {
        return ImageLoadEvent.eventNameForType(this.mEventType);
    }

    @Override
    public short getCoalescingKey() {
        return (short)this.mEventType;
    }

    @Override
    public void dispatch(RCTEventEmitter rctEventEmitter) {
        WritableMap eventData = null;
        if (this.mImageUri != null || this.mEventType == 2 || this.mEventType == 1) {
            eventData = Arguments.createMap();
            if (this.mImageUri != null) {
                eventData.putString("uri", this.mImageUri);
            }
            if (this.mEventType == 2) {
                WritableMap source = Arguments.createMap();
                source.putDouble("width", this.mWidth);
                source.putDouble("height", this.mHeight);
                if (this.mImageUri != null) {
                    source.putString("url", this.mImageUri);
                }
                eventData.putMap("source", source);
            } else if (this.mEventType == 1) {
                eventData.putString("error", this.mImageError);
            }
        }
        rctEventEmitter.receiveEvent(this.getViewTag(), this.getEventName(), eventData);
    }
}

