/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;
import android.view.ViewParent;
import com.facebook.react.uimanager.ReactClippingViewGroup;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ReactClippingViewGroupHelper {
    public static final String PROP_REMOVE_CLIPPED_SUBVIEWS = "removeClippedSubviews";
    private static final Rect sHelperRect = new Rect();

    public static void calculateClippingRect(View view, Rect outputRect) {
        ReactClippingViewGroup clippingViewGroup;
        ViewParent parent = view.getParent();
        if (parent == null) {
            outputRect.setEmpty();
            return;
        }
        if (parent instanceof ReactClippingViewGroup && (clippingViewGroup = (ReactClippingViewGroup)parent).getRemoveClippedSubviews()) {
            clippingViewGroup.getClippingRect(sHelperRect);
            if (!sHelperRect.intersect(view.getLeft(), view.getTop(), view.getRight(), view.getBottom())) {
                outputRect.setEmpty();
                return;
            }
            sHelperRect.offset(-view.getLeft(), -view.getTop());
            sHelperRect.offset(view.getScrollX(), view.getScrollY());
            outputRect.set(sHelperRect);
            return;
        }
        view.getDrawingRect(outputRect);
    }

    public static boolean getChildVisibleRectHelper(View child, Rect r, Point offset, View parent, String overflow) {
        RectF rect = new RectF();
        rect.set(r);
        child.getMatrix().mapRect(rect);
        int dx = child.getLeft() - parent.getScrollX();
        int dy = child.getTop() - parent.getScrollY();
        rect.offset((float)dx, (float)dy);
        if (offset != null) {
            float[] position = new float[]{offset.x, offset.y};
            child.getMatrix().mapPoints(position);
            offset.x = Math.round(position[0]) + dx;
            offset.y = Math.round(position[1]) + dy;
        }
        int width = parent.getRight() - parent.getLeft();
        int height = parent.getBottom() - parent.getTop();
        boolean rectIsVisible = true;
        ViewParent grandparent = parent.getParent();
        if (grandparent == null || "hidden".equals(overflow)) {
            rectIsVisible = rect.intersect(0.0f, 0.0f, (float)width, (float)height);
        }
        r.set((int)Math.floor(rect.left), (int)Math.floor(rect.top), (int)Math.ceil(rect.right), (int)Math.ceil(rect.bottom));
        if (rectIsVisible && grandparent != null) {
            rectIsVisible = grandparent.getChildVisibleRect(parent, r, offset);
        }
        return rectIsVisible;
    }
}

