/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.packagerconnection;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.react.modules.systeminfo.AndroidInfoHelpers;
import com.facebook.react.packagerconnection.PackagerConnectionSettings;
import com.facebook.react.packagerconnection.ReconnectingWebSocket;
import com.facebook.react.packagerconnection.RequestHandler;
import com.facebook.react.packagerconnection.Responder;
import java.util.Map;
import okio.ByteString;
import org.json.JSONObject;

public final class JSPackagerClient
implements ReconnectingWebSocket.MessageCallback {
    private static final String TAG = JSPackagerClient.class.getSimpleName();
    private static final String PACKAGER_CONNECTION_URL_FORMAT = "ws://%s/message?device=%s&app=%s&context=%s";
    private static final int PROTOCOL_VERSION = 2;
    private ReconnectingWebSocket mWebSocket;
    private Map<String, RequestHandler> mRequestHandlers;

    public JSPackagerClient(String clientId, PackagerConnectionSettings settings, Map<String, RequestHandler> requestHandlers) {
        this(clientId, settings, requestHandlers, null);
    }

    public JSPackagerClient(String clientId, PackagerConnectionSettings settings, Map<String, RequestHandler> requestHandlers, @Nullable ReconnectingWebSocket.ConnectionCallback connectionCallback) {
        Uri.Builder builder = new Uri.Builder();
        builder.scheme("ws").encodedAuthority(settings.getDebugServerHost()).appendPath("message").appendQueryParameter("device", AndroidInfoHelpers.getFriendlyDeviceName()).appendQueryParameter("app", settings.getPackageName()).appendQueryParameter("clientid", clientId);
        String url = builder.build().toString();
        this.mWebSocket = new ReconnectingWebSocket(url, this, connectionCallback);
        this.mRequestHandlers = requestHandlers;
    }

    public void init() {
        this.mWebSocket.connect();
    }

    public void close() {
        this.mWebSocket.closeQuietly();
    }

    @Override
    public void onMessage(String text) {
        try {
            JSONObject message = new JSONObject(text);
            int version = message.optInt("version");
            String method = message.optString("method");
            Object id2 = message.opt("id");
            Object params = message.opt("params");
            if (version != 2) {
                FLog.e((String)TAG, (String)("Message with incompatible or missing version of protocol received: " + version));
                return;
            }
            if (method == null) {
                this.abortOnMessage(id2, "No method provided");
                return;
            }
            RequestHandler handler = this.mRequestHandlers.get(method);
            if (handler == null) {
                this.abortOnMessage(id2, "No request handler for method: " + method);
                return;
            }
            if (id2 == null) {
                handler.onNotification(params);
            } else {
                handler.onRequest(params, new ResponderImpl(id2));
            }
        }
        catch (Exception e) {
            FLog.e((String)TAG, (String)"Handling the message failed", (Throwable)e);
        }
    }

    @Override
    public void onMessage(ByteString bytes) {
        FLog.w((String)TAG, (String)"Websocket received message with payload of unexpected type binary");
    }

    private void abortOnMessage(Object id2, String reason) {
        if (id2 != null) {
            new ResponderImpl(id2).error(reason);
        }
        FLog.e((String)TAG, (String)("Handling the message failed with reason: " + reason));
    }

    private class ResponderImpl
    implements Responder {
        private Object mId;

        public ResponderImpl(Object id2) {
            this.mId = id2;
        }

        @Override
        public void respond(Object result) {
            try {
                JSONObject message = new JSONObject();
                message.put("version", 2);
                message.put("id", this.mId);
                message.put("result", result);
                JSPackagerClient.this.mWebSocket.sendMessage(message.toString());
            }
            catch (Exception e) {
                FLog.e((String)TAG, (String)"Responding failed", (Throwable)e);
            }
        }

        @Override
        public void error(Object error) {
            try {
                JSONObject message = new JSONObject();
                message.put("version", 2);
                message.put("id", this.mId);
                message.put("error", error);
                JSPackagerClient.this.mWebSocket.sendMessage(message.toString());
            }
            catch (Exception e) {
                FLog.e((String)TAG, (String)"Responding with error failed", (Throwable)e);
            }
        }
    }
}

