/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.image;

import android.content.Context;
import android.net.Uri;
import android.util.SparseArray;
import androidx.annotation.Nullable;
import com.facebook.common.executors.CallerThreadExecutor;
import com.facebook.common.references.CloseableReference;
import com.facebook.datasource.BaseDataSubscriber;
import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSubscriber;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.fbreact.specs.NativeImageLoaderAndroidSpec;
import com.facebook.imagepipeline.core.ImagePipeline;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.GuardedAsyncTask;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.fresco.ReactNetworkImageRequest;
import com.facebook.react.views.imagehelper.ImageSource;
import java.util.concurrent.Executor;

@ReactModule(name="ImageLoader")
public class ImageLoaderModule
extends NativeImageLoaderAndroidSpec
implements LifecycleEventListener {
    private static final String ERROR_INVALID_URI = "E_INVALID_URI";
    private static final String ERROR_PREFETCH_FAILURE = "E_PREFETCH_FAILURE";
    private static final String ERROR_GET_SIZE_FAILURE = "E_GET_SIZE_FAILURE";
    public static final String NAME = "ImageLoader";
    private final Object mCallerContext;
    private final Object mEnqueuedRequestMonitor = new Object();
    private final SparseArray<DataSource<Void>> mEnqueuedRequests = new SparseArray();

    public ImageLoaderModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.mCallerContext = this;
    }

    public ImageLoaderModule(ReactApplicationContext reactContext, Object callerContext) {
        super(reactContext);
        this.mCallerContext = callerContext;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    @ReactMethod
    public void getSize(String uriString, final Promise promise) {
        if (uriString == null || uriString.isEmpty()) {
            promise.reject(ERROR_INVALID_URI, "Cannot get the size of an image for an empty URI");
            return;
        }
        ImageSource source = new ImageSource((Context)this.getReactApplicationContext(), uriString);
        ImageRequest request = ImageRequestBuilder.newBuilderWithSource((Uri)source.getUri()).build();
        DataSource dataSource = Fresco.getImagePipeline().fetchDecodedImage(request, this.mCallerContext);
        BaseDataSubscriber<CloseableReference<CloseableImage>> dataSubscriber = new BaseDataSubscriber<CloseableReference<CloseableImage>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onNewResultImpl(DataSource<CloseableReference<CloseableImage>> dataSource) {
                if (!dataSource.isFinished()) {
                    return;
                }
                CloseableReference ref = (CloseableReference)dataSource.getResult();
                if (ref != null) {
                    try {
                        CloseableImage image = (CloseableImage)ref.get();
                        WritableMap sizes = Arguments.createMap();
                        sizes.putInt("width", image.getWidth());
                        sizes.putInt("height", image.getHeight());
                        promise.resolve(sizes);
                    }
                    catch (Exception e) {
                        promise.reject(ImageLoaderModule.ERROR_GET_SIZE_FAILURE, e);
                    }
                    finally {
                        CloseableReference.closeSafely((CloseableReference)ref);
                    }
                } else {
                    promise.reject(ImageLoaderModule.ERROR_GET_SIZE_FAILURE);
                }
            }

            protected void onFailureImpl(DataSource<CloseableReference<CloseableImage>> dataSource) {
                promise.reject(ImageLoaderModule.ERROR_GET_SIZE_FAILURE, dataSource.getFailureCause());
            }
        };
        dataSource.subscribe((DataSubscriber)dataSubscriber, (Executor)CallerThreadExecutor.getInstance());
    }

    @Override
    @ReactMethod
    public void getSizeWithHeaders(String uriString, ReadableMap headers, final Promise promise) {
        if (uriString == null || uriString.isEmpty()) {
            promise.reject(ERROR_INVALID_URI, "Cannot get the size of an image for an empty URI");
            return;
        }
        ImageSource source = new ImageSource((Context)this.getReactApplicationContext(), uriString);
        ImageRequestBuilder imageRequestBuilder = ImageRequestBuilder.newBuilderWithSource((Uri)source.getUri());
        ReactNetworkImageRequest request = ReactNetworkImageRequest.fromBuilderWithHeaders(imageRequestBuilder, headers);
        DataSource dataSource = Fresco.getImagePipeline().fetchDecodedImage((ImageRequest)request, this.mCallerContext);
        BaseDataSubscriber<CloseableReference<CloseableImage>> dataSubscriber = new BaseDataSubscriber<CloseableReference<CloseableImage>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onNewResultImpl(DataSource<CloseableReference<CloseableImage>> dataSource) {
                if (!dataSource.isFinished()) {
                    return;
                }
                CloseableReference ref = (CloseableReference)dataSource.getResult();
                if (ref != null) {
                    try {
                        CloseableImage image = (CloseableImage)ref.get();
                        WritableMap sizes = Arguments.createMap();
                        sizes.putInt("width", image.getWidth());
                        sizes.putInt("height", image.getHeight());
                        promise.resolve(sizes);
                    }
                    catch (Exception e) {
                        promise.reject(ImageLoaderModule.ERROR_GET_SIZE_FAILURE, e);
                    }
                    finally {
                        CloseableReference.closeSafely((CloseableReference)ref);
                    }
                } else {
                    promise.reject(ImageLoaderModule.ERROR_GET_SIZE_FAILURE);
                }
            }

            protected void onFailureImpl(DataSource<CloseableReference<CloseableImage>> dataSource) {
                promise.reject(ImageLoaderModule.ERROR_GET_SIZE_FAILURE, dataSource.getFailureCause());
            }
        };
        dataSource.subscribe((DataSubscriber)dataSubscriber, (Executor)CallerThreadExecutor.getInstance());
    }

    @Override
    public void prefetchImage(String uriString, double requestIdAsDouble, final Promise promise) {
        final int requestId = (int)requestIdAsDouble;
        if (uriString == null || uriString.isEmpty()) {
            promise.reject(ERROR_INVALID_URI, "Cannot prefetch an image for an empty URI");
            return;
        }
        Uri uri = Uri.parse((String)uriString);
        ImageRequest request = ImageRequestBuilder.newBuilderWithSource((Uri)uri).build();
        DataSource prefetchSource = Fresco.getImagePipeline().prefetchToDiskCache(request, this.mCallerContext);
        BaseDataSubscriber<Void> prefetchSubscriber = new BaseDataSubscriber<Void>(){

            protected void onNewResultImpl(DataSource<Void> dataSource) {
                if (!dataSource.isFinished()) {
                    return;
                }
                try {
                    ImageLoaderModule.this.removeRequest(requestId);
                    promise.resolve(true);
                }
                finally {
                    dataSource.close();
                }
            }

            protected void onFailureImpl(DataSource<Void> dataSource) {
                try {
                    ImageLoaderModule.this.removeRequest(requestId);
                    promise.reject(ImageLoaderModule.ERROR_PREFETCH_FAILURE, dataSource.getFailureCause());
                }
                finally {
                    dataSource.close();
                }
            }
        };
        this.registerRequest(requestId, (DataSource<Void>)prefetchSource);
        prefetchSource.subscribe((DataSubscriber)prefetchSubscriber, (Executor)CallerThreadExecutor.getInstance());
    }

    @Override
    public void abortRequest(double requestId) {
        DataSource<Void> request = this.removeRequest((int)requestId);
        if (request != null) {
            request.close();
        }
    }

    @Override
    @ReactMethod
    public void queryCache(final ReadableArray uris, final Promise promise) {
        new GuardedAsyncTask<Void, Void>((ReactContext)this.getReactApplicationContext()){

            protected void doInBackgroundGuarded(Void ... params) {
                WritableMap result = Arguments.createMap();
                ImagePipeline imagePipeline = Fresco.getImagePipeline();
                for (int i = 0; i < uris.size(); ++i) {
                    String uriString = uris.getString(i);
                    Uri uri = Uri.parse((String)uriString);
                    if (imagePipeline.isInBitmapMemoryCache(uri)) {
                        result.putString(uriString, "memory");
                        continue;
                    }
                    if (!imagePipeline.isInDiskCacheSync(uri)) continue;
                    result.putString(uriString, "disk");
                }
                promise.resolve(result);
            }
        }.executeOnExecutor(GuardedAsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerRequest(int requestId, DataSource<Void> request) {
        Object object = this.mEnqueuedRequestMonitor;
        synchronized (object) {
            this.mEnqueuedRequests.put(requestId, request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private DataSource<Void> removeRequest(int requestId) {
        Object object = this.mEnqueuedRequestMonitor;
        synchronized (object) {
            DataSource request = (DataSource)this.mEnqueuedRequests.get(requestId);
            this.mEnqueuedRequests.remove(requestId);
            return request;
        }
    }

    @Override
    public void onHostResume() {
    }

    @Override
    public void onHostPause() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onHostDestroy() {
        Object object = this.mEnqueuedRequestMonitor;
        synchronized (object) {
            int size = this.mEnqueuedRequests.size();
            for (int i = 0; i < size; ++i) {
                DataSource enqueuedRequest = (DataSource)this.mEnqueuedRequests.valueAt(i);
                if (enqueuedRequest == null) continue;
                enqueuedRequest.close();
            }
            this.mEnqueuedRequests.clear();
        }
    }
}

