/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.dialog;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import com.facebook.react.modules.dialog.DialogModule;

public class AlertFragment
extends DialogFragment
implements DialogInterface.OnClickListener {
    static final String ARG_TITLE = "title";
    static final String ARG_MESSAGE = "message";
    static final String ARG_BUTTON_POSITIVE = "button_positive";
    static final String ARG_BUTTON_NEGATIVE = "button_negative";
    static final String ARG_BUTTON_NEUTRAL = "button_neutral";
    static final String ARG_ITEMS = "items";
    @Nullable
    private final DialogModule.AlertFragmentListener mListener;

    public AlertFragment() {
        this.mListener = null;
    }

    @SuppressLint(value={"ValidFragment"})
    public AlertFragment(@Nullable DialogModule.AlertFragmentListener listener, Bundle arguments) {
        this.mListener = listener;
        this.setArguments(arguments);
    }

    public static Dialog createDialog(Context activityContext, Bundle arguments, DialogInterface.OnClickListener fragment) {
        AlertDialog.Builder builder = new AlertDialog.Builder(activityContext).setTitle((CharSequence)arguments.getString(ARG_TITLE));
        if (arguments.containsKey(ARG_BUTTON_POSITIVE)) {
            builder.setPositiveButton((CharSequence)arguments.getString(ARG_BUTTON_POSITIVE), fragment);
        }
        if (arguments.containsKey(ARG_BUTTON_NEGATIVE)) {
            builder.setNegativeButton((CharSequence)arguments.getString(ARG_BUTTON_NEGATIVE), fragment);
        }
        if (arguments.containsKey(ARG_BUTTON_NEUTRAL)) {
            builder.setNeutralButton((CharSequence)arguments.getString(ARG_BUTTON_NEUTRAL), fragment);
        }
        if (arguments.containsKey(ARG_MESSAGE)) {
            builder.setMessage((CharSequence)arguments.getString(ARG_MESSAGE));
        }
        if (arguments.containsKey(ARG_ITEMS)) {
            builder.setItems(arguments.getCharSequenceArray(ARG_ITEMS), fragment);
        }
        return builder.create();
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        return AlertFragment.createDialog((Context)this.getActivity(), this.getArguments(), this);
    }

    public void onClick(DialogInterface dialog, int which) {
        if (this.mListener != null) {
            this.mListener.onClick(dialog, which);
        }
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.mListener != null) {
            this.mListener.onDismiss(dialog);
        }
    }
}

