/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.datepicker;

import android.app.DatePickerDialog;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.DatePicker;
import androidx.annotation.Nullable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class DismissableDatePickerDialog
extends DatePickerDialog {
    public DismissableDatePickerDialog(Context context, @Nullable DatePickerDialog.OnDateSetListener callback, int year, int monthOfYear, int dayOfMonth) {
        super(context, callback, year, monthOfYear, dayOfMonth);
        this.fixSpinner(context, year, monthOfYear, dayOfMonth);
    }

    public DismissableDatePickerDialog(Context context, int theme, @Nullable DatePickerDialog.OnDateSetListener callback, int year, int monthOfYear, int dayOfMonth) {
        super(context, theme, callback, year, monthOfYear, dayOfMonth);
        this.fixSpinner(context, year, monthOfYear, dayOfMonth);
    }

    protected void onStop() {
        if (Build.VERSION.SDK_INT > 19) {
            super.onStop();
        }
    }

    private void fixSpinner(Context context, int year, int month, int dayOfMonth) {
        if (Build.VERSION.SDK_INT == 24) {
            try {
                int MODE_SPINNER = 2;
                Class<?> styleableClass = Class.forName("com.android.internal.R$styleable");
                Field datePickerStyleableField = styleableClass.getField("DatePicker");
                int[] datePickerStyleable = (int[])datePickerStyleableField.get(null);
                TypedArray a = context.obtainStyledAttributes(null, datePickerStyleable, 16843612, 0);
                Field datePickerModeStyleableField = styleableClass.getField("DatePicker_datePickerMode");
                int datePickerModeStyleable = datePickerModeStyleableField.getInt(null);
                int mode = a.getInt(datePickerModeStyleable, 2);
                a.recycle();
                if (mode == 2) {
                    DatePicker datePicker = (DatePicker)DismissableDatePickerDialog.findField(DatePickerDialog.class, DatePicker.class, "mDatePicker").get((Object)this);
                    Class<?> delegateClass = Class.forName("android.widget.DatePickerSpinnerDelegate");
                    Field delegateField = DismissableDatePickerDialog.findField(DatePicker.class, delegateClass, "mDelegate");
                    Object delegate = delegateField.get(datePicker);
                    Class<?> spinnerDelegateClass = Class.forName("android.widget.DatePickerSpinnerDelegate");
                    if (delegate.getClass() != spinnerDelegateClass) {
                        delegateField.set(datePicker, null);
                        datePicker.removeAllViews();
                        Method createSpinnerUIDelegate = DatePicker.class.getDeclaredMethod("createSpinnerUIDelegate", Context.class, AttributeSet.class, Integer.TYPE, Integer.TYPE);
                        createSpinnerUIDelegate.setAccessible(true);
                        delegate = createSpinnerUIDelegate.invoke((Object)datePicker, context, null, 16843612, 0);
                        delegateField.set(datePicker, delegate);
                        datePicker.setCalendarViewShown(false);
                        datePicker.init(year, month, dayOfMonth, (DatePicker.OnDateChangedListener)this);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static Field findField(Class objectClass, Class fieldClass, String expectedName) {
        try {
            Field field = objectClass.getDeclaredField(expectedName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            for (Field searchField : objectClass.getDeclaredFields()) {
                if (searchField.getType() != fieldClass) continue;
                searchField.setAccessible(true);
                return searchField;
            }
            return null;
        }
    }
}

