/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.content.Context;
import androidx.annotation.Nullable;
import com.facebook.react.devsupport.DisabledDevSupportManager;
import com.facebook.react.devsupport.ReactInstanceManagerDevHelper;
import com.facebook.react.devsupport.RedBoxHandler;
import com.facebook.react.devsupport.interfaces.DevBundleDownloadListener;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.packagerconnection.RequestHandler;
import java.lang.reflect.Constructor;
import java.util.Map;

public class DevSupportManagerFactory {
    private static final String DEVSUPPORT_IMPL_PACKAGE = "com.facebook.react.devsupport";
    private static final String DEVSUPPORT_IMPL_CLASS = "DevSupportManagerImpl";

    public static DevSupportManager create(Context applicationContext, ReactInstanceManagerDevHelper reactInstanceManagerHelper, @Nullable String packagerPathForJSBundleName, boolean enableOnCreate, int minNumShakes) {
        return DevSupportManagerFactory.create(applicationContext, reactInstanceManagerHelper, packagerPathForJSBundleName, enableOnCreate, null, null, minNumShakes, null);
    }

    public static DevSupportManager create(Context applicationContext, ReactInstanceManagerDevHelper reactInstanceManagerHelper, @Nullable String packagerPathForJSBundleName, boolean enableOnCreate, @Nullable RedBoxHandler redBoxHandler, @Nullable DevBundleDownloadListener devBundleDownloadListener, int minNumShakes, @Nullable Map<String, RequestHandler> customPackagerCommandHandlers) {
        if (!enableOnCreate) {
            return new DisabledDevSupportManager();
        }
        try {
            String className = DEVSUPPORT_IMPL_PACKAGE + "." + DEVSUPPORT_IMPL_CLASS;
            Class<?> devSupportManagerClass = Class.forName(className);
            Constructor<?> constructor = devSupportManagerClass.getConstructor(Context.class, ReactInstanceManagerDevHelper.class, String.class, Boolean.TYPE, RedBoxHandler.class, DevBundleDownloadListener.class, Integer.TYPE, Map.class);
            return (DevSupportManager)constructor.newInstance(applicationContext, reactInstanceManagerHelper, packagerPathForJSBundleName, true, redBoxHandler, devBundleDownloadListener, minNumShakes, customPackagerCommandHandlers);
        }
        catch (Exception e) {
            throw new RuntimeException("Requested enabled DevSupportManager, but DevSupportManagerImpl class was not found or could not be created", e);
        }
    }
}

