/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeArray;
import com.facebook.react.bridge.WritableNativeMap;

public class PromiseImpl
implements Promise {
    private static final int ERROR_STACK_FRAME_LIMIT = 50;
    private static final String ERROR_DEFAULT_CODE = "EUNSPECIFIED";
    private static final String ERROR_DEFAULT_MESSAGE = "Error not specified.";
    private static final String ERROR_MAP_KEY_CODE = "code";
    private static final String ERROR_MAP_KEY_MESSAGE = "message";
    private static final String ERROR_MAP_KEY_USER_INFO = "userInfo";
    private static final String ERROR_MAP_KEY_NATIVE_STACK = "nativeStackAndroid";
    private static final String STACK_FRAME_KEY_CLASS = "class";
    private static final String STACK_FRAME_KEY_FILE = "file";
    private static final String STACK_FRAME_KEY_LINE_NUMBER = "lineNumber";
    private static final String STACK_FRAME_KEY_METHOD_NAME = "methodName";
    @Nullable
    private Callback mResolve;
    @Nullable
    private Callback mReject;

    public PromiseImpl(@Nullable Callback resolve, @Nullable Callback reject) {
        this.mResolve = resolve;
        this.mReject = reject;
    }

    @Override
    public void resolve(Object value) {
        if (this.mResolve != null) {
            this.mResolve.invoke(value);
            this.mResolve = null;
            this.mReject = null;
        }
    }

    @Override
    public void reject(String code, String message) {
        this.reject(code, message, null, null);
    }

    @Override
    public void reject(String code, Throwable throwable) {
        this.reject(code, null, throwable, null);
    }

    @Override
    public void reject(String code, String message, Throwable throwable) {
        this.reject(code, message, throwable, null);
    }

    @Override
    public void reject(Throwable throwable) {
        this.reject(null, null, throwable, null);
    }

    @Override
    public void reject(Throwable throwable, WritableMap userInfo) {
        this.reject(null, null, throwable, userInfo);
    }

    @Override
    public void reject(String code, @NonNull WritableMap userInfo) {
        this.reject(code, null, null, userInfo);
    }

    @Override
    public void reject(String code, Throwable throwable, WritableMap userInfo) {
        this.reject(code, null, throwable, userInfo);
    }

    @Override
    public void reject(String code, String message, @NonNull WritableMap userInfo) {
        this.reject(code, message, null, userInfo);
    }

    @Override
    public void reject(@Nullable String code, @Nullable String message, @Nullable Throwable throwable, @Nullable WritableMap userInfo) {
        if (this.mReject == null) {
            this.mResolve = null;
            return;
        }
        WritableNativeMap errorInfo = new WritableNativeMap();
        if (code == null) {
            errorInfo.putString(ERROR_MAP_KEY_CODE, ERROR_DEFAULT_CODE);
        } else {
            errorInfo.putString(ERROR_MAP_KEY_CODE, code);
        }
        if (message != null) {
            errorInfo.putString(ERROR_MAP_KEY_MESSAGE, message);
        } else if (throwable != null) {
            errorInfo.putString(ERROR_MAP_KEY_MESSAGE, throwable.getMessage());
        } else {
            errorInfo.putString(ERROR_MAP_KEY_MESSAGE, ERROR_DEFAULT_MESSAGE);
        }
        if (userInfo != null) {
            errorInfo.putMap(ERROR_MAP_KEY_USER_INFO, userInfo);
        } else {
            errorInfo.putNull(ERROR_MAP_KEY_USER_INFO);
        }
        if (throwable != null) {
            StackTraceElement[] stackTrace = throwable.getStackTrace();
            WritableNativeArray nativeStackAndroid = new WritableNativeArray();
            for (int i = 0; i < stackTrace.length && i < 50; ++i) {
                StackTraceElement frame = stackTrace[i];
                WritableNativeMap frameMap = new WritableNativeMap();
                frameMap.putString(STACK_FRAME_KEY_CLASS, frame.getClassName());
                frameMap.putString(STACK_FRAME_KEY_FILE, frame.getFileName());
                frameMap.putInt(STACK_FRAME_KEY_LINE_NUMBER, frame.getLineNumber());
                frameMap.putString(STACK_FRAME_KEY_METHOD_NAME, frame.getMethodName());
                nativeStackAndroid.pushMap(frameMap);
            }
            errorInfo.putArray(ERROR_MAP_KEY_NATIVE_STACK, nativeStackAndroid);
        } else {
            errorInfo.putArray(ERROR_MAP_KEY_NATIVE_STACK, new WritableNativeArray());
        }
        this.mReject.invoke(errorInfo);
        this.mResolve = null;
        this.mReject = null;
    }

    @Override
    @Deprecated
    public void reject(String message) {
        this.reject(null, message, null, null);
    }
}

