/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.core;

import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.BaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.util.JSStackTrace;
import java.lang.reflect.Method;

@ReactModule(name="ExceptionsManager")
public class ExceptionsManagerModule
extends BaseJavaModule {
    public static final String NAME = "ExceptionsManager";
    private final DevSupportManager mDevSupportManager;

    public ExceptionsManagerModule(DevSupportManager devSupportManager) {
        this.mDevSupportManager = devSupportManager;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @ReactMethod
    public void reportFatalException(String title, ReadableArray details, int exceptionId) {
        this.showOrThrowError(title, details, exceptionId);
    }

    @ReactMethod
    public void reportSoftException(String title, ReadableArray details, int exceptionId) {
        if (this.mDevSupportManager.getDevSupportEnabled()) {
            this.mDevSupportManager.showNewJSError(title, details, exceptionId);
        } else {
            FLog.e((String)"ReactNative", (String)JSStackTrace.format(title, details));
        }
    }

    private void showOrThrowError(String title, ReadableArray details, int exceptionId) {
        if (this.mDevSupportManager.getDevSupportEnabled()) {
            this.mDevSupportManager.showNewJSError(title, details, exceptionId);
        } else {
            String errorMsg = JSStackTrace.format(title, details);
            try {
                Class<?> class1 = Class.forName("com.bytedance.ttgame.module.rn.manager.RNBundleManager");
                Method method = class1.getMethod("getInstance", new Class[0]);
                Object instance = method.invoke(new Object(), new Object[0]);
                Method method1 = class1.getMethod("rnCrash", String.class);
                method1.invoke(instance, errorMsg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @ReactMethod
    public void updateExceptionMessage(String title, ReadableArray details, int exceptionId) {
        if (this.mDevSupportManager.getDevSupportEnabled()) {
            this.mDevSupportManager.updateJSError(title, details, exceptionId);
        }
    }

    @ReactMethod
    public void dismissRedbox() {
        if (this.mDevSupportManager.getDevSupportEnabled()) {
            this.mDevSupportManager.hideRedboxDialog();
        }
    }
}

