/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.common;

import android.support.v4.util.Pools;

public class ClearableSynchronizedPool<T>
implements Pools.Pool<T> {
    private final Object[] mPool;
    private int mSize = 0;

    public ClearableSynchronizedPool(int maxSize) {
        this.mPool = new Object[maxSize];
    }

    public synchronized T acquire() {
        if (this.mSize == 0) {
            return null;
        }
        --this.mSize;
        int lastIndex = this.mSize;
        Object toReturn = this.mPool[lastIndex];
        this.mPool[lastIndex] = null;
        return (T)toReturn;
    }

    public synchronized boolean release(T obj) {
        if (this.mSize == this.mPool.length) {
            return false;
        }
        this.mPool[this.mSize] = obj;
        ++this.mSize;
        return true;
    }

    public synchronized void clear() {
        for (int i = 0; i < this.mSize; ++i) {
            this.mPool[i] = null;
        }
        this.mSize = 0;
    }
}

