/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.view.View;
import com.facebook.react.bridge.BaseJavaModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableNativeMap;
import com.facebook.react.touch.JSResponderHandler;
import com.facebook.react.touch.ReactInterceptingViewGroup;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewManagerPropertyUpdater;
import com.facebook.react.uimanager.annotations.ReactPropertyHolder;
import com.facebook.yoga.YogaMeasureMode;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ReactPropertyHolder
public abstract class ViewManager<T extends View, C extends ReactShadowNode>
extends BaseJavaModule {
    public final void updateProperties(@Nonnull T viewToUpdate, ReactStylesDiffMap props) {
        ViewManagerPropertyUpdater.updateProps(this, viewToUpdate, props);
        this.onAfterUpdateTransaction(viewToUpdate);
    }

    @Nonnull
    public final T createView(@Nonnull ThemedReactContext reactContext, JSResponderHandler jsResponderHandler) {
        T view = this.createViewInstance(reactContext);
        this.addEventEmitters(reactContext, view);
        if (view instanceof ReactInterceptingViewGroup) {
            ((ReactInterceptingViewGroup)view).setOnInterceptTouchEventListener(jsResponderHandler);
        }
        return view;
    }

    @Override
    @Nonnull
    public abstract String getName();

    public C createShadowNodeInstance() {
        throw new RuntimeException("ViewManager subclasses must implement createShadowNodeInstance()");
    }

    @Nonnull
    public C createShadowNodeInstance(@Nonnull ReactApplicationContext context) {
        return this.createShadowNodeInstance();
    }

    public abstract Class<? extends C> getShadowNodeClass();

    @Nonnull
    protected abstract T createViewInstance(@Nonnull ThemedReactContext var1);

    public void onDropViewInstance(@Nonnull T view) {
    }

    protected void addEventEmitters(@Nonnull ThemedReactContext reactContext, @Nonnull T view) {
    }

    protected void onAfterUpdateTransaction(@Nonnull T view) {
    }

    public abstract void updateExtraData(@Nonnull T var1, Object var2);

    public void receiveCommand(@Nonnull T root, int commandId, @Nullable ReadableArray args) {
    }

    @Nullable
    public Map<String, Integer> getCommandsMap() {
        return null;
    }

    @Nullable
    public Map<String, Object> getExportedCustomBubblingEventTypeConstants() {
        return null;
    }

    @Nullable
    public Map<String, Object> getExportedCustomDirectEventTypeConstants() {
        return null;
    }

    @Nullable
    public Map<String, Object> getExportedViewConstants() {
        return null;
    }

    public Map<String, String> getNativeProps() {
        return ViewManagerPropertyUpdater.getNativeProps(this.getClass(), this.getShadowNodeClass());
    }

    @Nullable
    public Object updateLocalData(@Nonnull T view, ReactStylesDiffMap props, ReactStylesDiffMap localData) {
        return null;
    }

    public long measure(ReactContext context, ReadableNativeMap localData, ReadableNativeMap props, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode) {
        return 0L;
    }
}

