/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.util;

import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSStackTrace {
    private static final Pattern FILE_ID_PATTERN = Pattern.compile("\\b((?:seg-\\d+(?:_\\d+)?|\\d+)\\.js)");

    public static String format(String message, ReadableArray stack) {
        StringBuilder stringBuilder = new StringBuilder(message).append(", stack:\n");
        for (int i = 0; i < stack.size(); ++i) {
            ReadableMap frame = stack.getMap(i);
            String methodName = "";
            if (frame.hasKey("methodName") && !frame.isNull("methodName")) {
                methodName = frame.getString("methodName");
            }
            stringBuilder.append(methodName).append("@").append(JSStackTrace.parseFileId(frame));
            if (frame.hasKey("lineNumber") && !frame.isNull("lineNumber") && frame.getType("lineNumber") == ReadableType.Number) {
                stringBuilder.append(frame.getInt("lineNumber"));
            } else {
                stringBuilder.append(-1);
            }
            if (frame.hasKey("column") && !frame.isNull("column") && frame.getType("column") == ReadableType.Number) {
                stringBuilder.append(":").append(frame.getInt("column"));
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    private static String parseFileId(ReadableMap frame) {
        Matcher matcher;
        if (frame.hasKey("file") && !frame.isNull("file") && frame.getType("file") == ReadableType.String && (matcher = FILE_ID_PATTERN.matcher(frame.getString("file"))).find()) {
            return matcher.group(1) + ":";
        }
        return "";
    }
}

