/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.art;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Region;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.art.ARTVirtualNode;
import com.facebook.react.views.art.PropHelper;
import javax.annotation.Nullable;

public class ARTGroupShadowNode
extends ARTVirtualNode {
    @Nullable
    protected RectF mClipping;

    @ReactProp(name="clipping")
    public void setClipping(@Nullable ReadableArray clippingDims) {
        float[] clippingData = PropHelper.toFloatArray(clippingDims);
        if (clippingData != null) {
            this.mClipping = ARTGroupShadowNode.createClipping(clippingData);
            this.markUpdated();
        }
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    public void draw(Canvas canvas, Paint paint, float opacity) {
        if ((opacity *= this.mOpacity) > 0.01f) {
            this.saveAndSetupCanvas(canvas);
            if (this.mClipping != null) {
                canvas.clipRect(this.mClipping.left * this.mScale, this.mClipping.top * this.mScale, this.mClipping.right * this.mScale, this.mClipping.bottom * this.mScale, Region.Op.REPLACE);
            }
            for (int i = 0; i < this.getChildCount(); ++i) {
                ARTVirtualNode child = (ARTVirtualNode)this.getChildAt(i);
                child.draw(canvas, paint, opacity);
                child.markUpdateSeen();
            }
            this.restoreCanvas(canvas);
        }
    }

    private static RectF createClipping(float[] data) {
        if (data.length != 4) {
            throw new JSApplicationIllegalArgumentException("Clipping should be array of length 4 (e.g. [x, y, width, height])");
        }
        RectF clippingRect = new RectF(data[0], data[1], data[0] + data[2], data[1] + data[3]);
        return clippingRect;
    }
}

