/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.netinfo;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.v4.net.ConnectivityManagerCompat;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.core.DeviceEventManagerModule;

@ReactModule(name="NetInfo")
@SuppressLint(value={"MissingPermission"})
public class NetInfoModule
extends ReactContextBaseJavaModule
implements LifecycleEventListener {
    private static final String CONNECTION_TYPE_BLUETOOTH = "bluetooth";
    private static final String CONNECTION_TYPE_CELLULAR = "cellular";
    private static final String CONNECTION_TYPE_ETHERNET = "ethernet";
    private static final String CONNECTION_TYPE_NONE = "none";
    private static final String CONNECTION_TYPE_UNKNOWN = "unknown";
    private static final String CONNECTION_TYPE_WIFI = "wifi";
    private static final String CONNECTION_TYPE_WIMAX = "wimax";
    private static final String EFFECTIVE_CONNECTION_TYPE_UNKNOWN = "unknown";
    private static final String EFFECTIVE_CONNECTION_TYPE_2G = "2g";
    private static final String EFFECTIVE_CONNECTION_TYPE_3G = "3g";
    private static final String EFFECTIVE_CONNECTION_TYPE_4G = "4g";
    private static final String CONNECTION_TYPE_NONE_DEPRECATED = "NONE";
    private static final String CONNECTION_TYPE_UNKNOWN_DEPRECATED = "UNKNOWN";
    private static final String MISSING_PERMISSION_MESSAGE = "To use NetInfo on Android, add the following to your AndroidManifest.xml:\n<uses-permission android:name=\"android.permission.ACCESS_NETWORK_STATE\" />";
    private static final String ERROR_MISSING_PERMISSION = "E_MISSING_PERMISSION";
    public static final String NAME = "NetInfo";
    private final ConnectivityManager mConnectivityManager;
    private final ConnectivityBroadcastReceiver mConnectivityBroadcastReceiver;
    private boolean mNoNetworkPermission = false;
    private String mConnectivityDeprecated = "UNKNOWN";
    private String mConnectionType = "unknown";
    private String mEffectiveConnectionType = "unknown";

    public NetInfoModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.mConnectivityManager = (ConnectivityManager)reactContext.getSystemService("connectivity");
        this.mConnectivityBroadcastReceiver = new ConnectivityBroadcastReceiver();
    }

    @Override
    public void onHostResume() {
        this.registerReceiver();
    }

    @Override
    public void onHostPause() {
        this.unregisterReceiver();
    }

    @Override
    public void onHostDestroy() {
    }

    @Override
    public void initialize() {
        this.getReactApplicationContext().addLifecycleEventListener(this);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @ReactMethod
    public void getCurrentConnectivity(Promise promise) {
        if (this.mNoNetworkPermission) {
            promise.reject(ERROR_MISSING_PERMISSION, MISSING_PERMISSION_MESSAGE);
            return;
        }
        promise.resolve(this.createConnectivityEventMap());
    }

    @ReactMethod
    public void isConnectionMetered(Promise promise) {
        if (this.mNoNetworkPermission) {
            promise.reject(ERROR_MISSING_PERMISSION, MISSING_PERMISSION_MESSAGE);
            return;
        }
        promise.resolve(ConnectivityManagerCompat.isActiveNetworkMetered((ConnectivityManager)this.mConnectivityManager));
    }

    private void registerReceiver() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        try {
            this.getReactApplicationContext().registerReceiver(this.mConnectivityBroadcastReceiver, filter);
            this.mConnectivityBroadcastReceiver.setRegistered(true);
        }
        catch (Exception e) {
            this.mConnectivityBroadcastReceiver.setRegistered(false);
        }
        this.updateAndSendConnectionType();
    }

    private void unregisterReceiver() {
        if (this.mConnectivityBroadcastReceiver.isRegistered()) {
            this.getReactApplicationContext().unregisterReceiver(this.mConnectivityBroadcastReceiver);
            this.mConnectivityBroadcastReceiver.setRegistered(false);
        }
    }

    private void updateAndSendConnectionType() {
        String connectionType = "unknown";
        String effectiveConnectionType = "unknown";
        try {
            NetworkInfo networkInfo = this.mConnectivityManager.getActiveNetworkInfo();
            if (networkInfo == null || !networkInfo.isConnected()) {
                connectionType = CONNECTION_TYPE_NONE;
            } else {
                int networkType = networkInfo.getType();
                switch (networkType) {
                    case 7: {
                        connectionType = CONNECTION_TYPE_BLUETOOTH;
                        break;
                    }
                    case 9: {
                        connectionType = CONNECTION_TYPE_ETHERNET;
                        break;
                    }
                    case 0: 
                    case 4: {
                        connectionType = CONNECTION_TYPE_CELLULAR;
                        effectiveConnectionType = this.getEffectiveConnectionType(networkInfo);
                        break;
                    }
                    case 1: {
                        connectionType = CONNECTION_TYPE_WIFI;
                        break;
                    }
                    case 6: {
                        connectionType = CONNECTION_TYPE_WIMAX;
                        break;
                    }
                    default: {
                        connectionType = "unknown";
                    }
                }
            }
        }
        catch (SecurityException e) {
            this.mNoNetworkPermission = true;
            connectionType = "unknown";
        }
        String currentConnectivity = this.getCurrentConnectionType();
        if (!(connectionType.equalsIgnoreCase(this.mConnectionType) && effectiveConnectionType.equalsIgnoreCase(this.mEffectiveConnectionType) && currentConnectivity.equalsIgnoreCase(this.mConnectivityDeprecated))) {
            this.mConnectionType = connectionType;
            this.mEffectiveConnectionType = effectiveConnectionType;
            this.mConnectivityDeprecated = currentConnectivity;
            this.sendConnectivityChangedEvent();
        }
    }

    private String getCurrentConnectionType() {
        try {
            NetworkInfo networkInfo = this.mConnectivityManager.getActiveNetworkInfo();
            if (networkInfo == null || !networkInfo.isConnected()) {
                return CONNECTION_TYPE_NONE_DEPRECATED;
            }
            if (ConnectivityManager.isNetworkTypeValid((int)networkInfo.getType())) {
                return networkInfo.getTypeName().toUpperCase();
            }
            return CONNECTION_TYPE_UNKNOWN_DEPRECATED;
        }
        catch (SecurityException e) {
            this.mNoNetworkPermission = true;
            return CONNECTION_TYPE_UNKNOWN_DEPRECATED;
        }
    }

    private String getEffectiveConnectionType(NetworkInfo networkInfo) {
        switch (networkInfo.getSubtype()) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return EFFECTIVE_CONNECTION_TYPE_2G;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                return EFFECTIVE_CONNECTION_TYPE_3G;
            }
            case 13: 
            case 15: {
                return EFFECTIVE_CONNECTION_TYPE_4G;
            }
        }
        return "unknown";
    }

    private void sendConnectivityChangedEvent() {
        this.getReactApplicationContext().getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class).emit("networkStatusDidChange", this.createConnectivityEventMap());
    }

    private WritableMap createConnectivityEventMap() {
        WritableNativeMap event = new WritableNativeMap();
        event.putString("network_info", this.mConnectivityDeprecated);
        event.putString("connectionType", this.mConnectionType);
        event.putString("effectiveConnectionType", this.mEffectiveConnectionType);
        return event;
    }

    private class ConnectivityBroadcastReceiver
    extends BroadcastReceiver {
        private boolean isRegistered = false;

        private ConnectivityBroadcastReceiver() {
        }

        public void setRegistered(boolean registered) {
            this.isRegistered = registered;
        }

        public boolean isRegistered() {
            return this.isRegistered;
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                NetInfoModule.this.updateAndSendConnectionType();
            }
        }
    }
}

