/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.os.Build;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.modules.i18nmanager.I18nUtil;
import com.facebook.react.uimanager.FloatUtil;
import com.facebook.react.uimanager.Spacing;
import com.facebook.react.views.view.ColorUtil;
import com.facebook.yoga.YogaConstants;
import java.util.Arrays;
import java.util.Locale;
import javax.annotation.Nullable;

public class ReactViewBackgroundDrawable
extends Drawable {
    private static final int DEFAULT_BORDER_COLOR = -16777216;
    private static final int DEFAULT_BORDER_RGB = 0;
    private static final int DEFAULT_BORDER_ALPHA = 255;
    private static final int ALL_BITS_SET = -1;
    private static final int ALL_BITS_UNSET = 0;
    @Nullable
    private Spacing mBorderWidth;
    @Nullable
    private Spacing mBorderRGB;
    @Nullable
    private Spacing mBorderAlpha;
    @Nullable
    private BorderStyle mBorderStyle;
    @Nullable
    private PathEffect mPathEffectForBorderStyle;
    @Nullable
    private Path mInnerClipPathForBorderRadius;
    @Nullable
    private Path mOuterClipPathForBorderRadius;
    @Nullable
    private Path mPathForBorderRadiusOutline;
    @Nullable
    private Path mPathForBorder;
    @Nullable
    private Path mCenterDrawPath;
    @Nullable
    private RectF mInnerClipTempRectForBorderRadius;
    @Nullable
    private RectF mOuterClipTempRectForBorderRadius;
    @Nullable
    private RectF mTempRectForBorderRadiusOutline;
    @Nullable
    private RectF mTempRectForCenterDrawPath;
    @Nullable
    private PointF mInnerTopLeftCorner;
    @Nullable
    private PointF mInnerTopRightCorner;
    @Nullable
    private PointF mInnerBottomRightCorner;
    @Nullable
    private PointF mInnerBottomLeftCorner;
    private boolean mNeedUpdatePathForBorderRadius = false;
    private float mBorderRadius = Float.NaN;
    private final Paint mPaint = new Paint(1);
    private int mColor = 0;
    private int mAlpha = 255;
    @Nullable
    private float[] mBorderCornerRadii;
    private final Context mContext;
    private int mLayoutDirection;

    public ReactViewBackgroundDrawable(Context context) {
        this.mContext = context;
    }

    public void draw(Canvas canvas) {
        this.updatePathEffect();
        if (!this.hasRoundedBorders()) {
            this.drawRectangularBackgroundWithBorders(canvas);
        } else {
            this.drawRoundedBackgroundWithBorders(canvas);
        }
    }

    public boolean hasRoundedBorders() {
        if (!YogaConstants.isUndefined(this.mBorderRadius) && this.mBorderRadius > 0.0f) {
            return true;
        }
        if (this.mBorderCornerRadii != null) {
            for (float borderRadii : this.mBorderCornerRadii) {
                if (YogaConstants.isUndefined(borderRadii) || !(borderRadii > 0.0f)) continue;
                return true;
            }
        }
        return false;
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.mNeedUpdatePathForBorderRadius = true;
    }

    public void setAlpha(int alpha) {
        if (alpha != this.mAlpha) {
            this.mAlpha = alpha;
            this.invalidateSelf();
        }
    }

    public int getAlpha() {
        return this.mAlpha;
    }

    public void setColorFilter(ColorFilter cf) {
    }

    public int getOpacity() {
        return ColorUtil.getOpacityFromColor(ColorUtil.multiplyColorAlpha(this.mColor, this.mAlpha));
    }

    public void getOutline(Outline outline) {
        if (Build.VERSION.SDK_INT < 21) {
            super.getOutline(outline);
            return;
        }
        if (!YogaConstants.isUndefined(this.mBorderRadius) && this.mBorderRadius > 0.0f || this.mBorderCornerRadii != null) {
            this.updatePath();
            outline.setConvexPath(this.mPathForBorderRadiusOutline);
        } else {
            outline.setRect(this.getBounds());
        }
    }

    public void setBorderWidth(int position, float width) {
        if (this.mBorderWidth == null) {
            this.mBorderWidth = new Spacing();
        }
        if (!FloatUtil.floatsEqual(this.mBorderWidth.getRaw(position), width)) {
            this.mBorderWidth.set(position, width);
            switch (position) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    this.mNeedUpdatePathForBorderRadius = true;
                }
            }
            this.invalidateSelf();
        }
    }

    public void setBorderColor(int position, float rgb, float alpha) {
        this.setBorderRGB(position, rgb);
        this.setBorderAlpha(position, alpha);
    }

    private void setBorderRGB(int position, float rgb) {
        if (this.mBorderRGB == null) {
            this.mBorderRGB = new Spacing(0.0f);
        }
        if (!FloatUtil.floatsEqual(this.mBorderRGB.getRaw(position), rgb)) {
            this.mBorderRGB.set(position, rgb);
            this.invalidateSelf();
        }
    }

    private void setBorderAlpha(int position, float alpha) {
        if (this.mBorderAlpha == null) {
            this.mBorderAlpha = new Spacing(255.0f);
        }
        if (!FloatUtil.floatsEqual(this.mBorderAlpha.getRaw(position), alpha)) {
            this.mBorderAlpha.set(position, alpha);
            this.invalidateSelf();
        }
    }

    public void setBorderStyle(@Nullable String style2) {
        BorderStyle borderStyle;
        BorderStyle borderStyle2 = borderStyle = style2 == null ? null : BorderStyle.valueOf(style2.toUpperCase(Locale.US));
        if (this.mBorderStyle != borderStyle) {
            this.mBorderStyle = borderStyle;
            this.mNeedUpdatePathForBorderRadius = true;
            this.invalidateSelf();
        }
    }

    public void setRadius(float radius) {
        if (!FloatUtil.floatsEqual(this.mBorderRadius, radius)) {
            this.mBorderRadius = radius;
            this.mNeedUpdatePathForBorderRadius = true;
            this.invalidateSelf();
        }
    }

    public void setRadius(float radius, int position) {
        if (this.mBorderCornerRadii == null) {
            this.mBorderCornerRadii = new float[8];
            Arrays.fill(this.mBorderCornerRadii, Float.NaN);
        }
        if (!FloatUtil.floatsEqual(this.mBorderCornerRadii[position], radius)) {
            this.mBorderCornerRadii[position] = radius;
            this.mNeedUpdatePathForBorderRadius = true;
            this.invalidateSelf();
        }
    }

    public float getFullBorderRadius() {
        return YogaConstants.isUndefined(this.mBorderRadius) ? 0.0f : this.mBorderRadius;
    }

    public float getBorderRadius(BorderRadiusLocation location) {
        return this.getBorderRadiusOrDefaultTo(Float.NaN, location);
    }

    public float getBorderRadiusOrDefaultTo(float defaultValue, BorderRadiusLocation location) {
        if (this.mBorderCornerRadii == null) {
            return defaultValue;
        }
        float radius = this.mBorderCornerRadii[location.ordinal()];
        if (YogaConstants.isUndefined(radius)) {
            return defaultValue;
        }
        return radius;
    }

    public void setColor(int color) {
        this.mColor = color;
        this.invalidateSelf();
    }

    public int getResolvedLayoutDirection() {
        return this.mLayoutDirection;
    }

    public boolean setResolvedLayoutDirection(int layoutDirection) {
        if (this.mLayoutDirection != layoutDirection) {
            this.mLayoutDirection = layoutDirection;
            return this.onResolvedLayoutDirectionChanged(layoutDirection);
        }
        return false;
    }

    public boolean onResolvedLayoutDirectionChanged(int layoutDirection) {
        return false;
    }

    @VisibleForTesting
    public int getColor() {
        return this.mColor;
    }

    private void drawRoundedBackgroundWithBorders(Canvas canvas) {
        this.updatePath();
        canvas.save();
        int useColor = ColorUtil.multiplyColorAlpha(this.mColor, this.mAlpha);
        if (Color.alpha((int)useColor) != 0) {
            this.mPaint.setColor(useColor);
            this.mPaint.setStyle(Paint.Style.FILL);
            canvas.drawPath(this.mInnerClipPathForBorderRadius, this.mPaint);
        }
        RectF borderWidth = this.getDirectionAwareBorderInsets();
        if (borderWidth.top > 0.0f || borderWidth.bottom > 0.0f || borderWidth.left > 0.0f || borderWidth.right > 0.0f) {
            float fullBorderWidth = this.getFullBorderWidth();
            if (borderWidth.top == fullBorderWidth && borderWidth.bottom == fullBorderWidth && borderWidth.left == fullBorderWidth && borderWidth.right == fullBorderWidth) {
                if (fullBorderWidth > 0.0f) {
                    int borderColor = this.getBorderColor(8);
                    this.mPaint.setColor(ColorUtil.multiplyColorAlpha(borderColor, this.mAlpha));
                    this.mPaint.setStyle(Paint.Style.STROKE);
                    this.mPaint.setStrokeWidth(fullBorderWidth);
                    canvas.drawPath(this.mCenterDrawPath, this.mPaint);
                }
            } else {
                float y4;
                float x4;
                float y3;
                this.mPaint.setStyle(Paint.Style.FILL);
                canvas.clipPath(this.mOuterClipPathForBorderRadius, Region.Op.INTERSECT);
                canvas.clipPath(this.mInnerClipPathForBorderRadius, Region.Op.DIFFERENCE);
                int colorLeft = this.getBorderColor(0);
                int colorTop = this.getBorderColor(1);
                int colorRight = this.getBorderColor(2);
                int colorBottom = this.getBorderColor(3);
                if (Build.VERSION.SDK_INT >= 17) {
                    int directionAwareColorRight;
                    int directionAwareColorLeft;
                    boolean isRTL = this.getResolvedLayoutDirection() == 1;
                    int colorStart = this.getBorderColor(4);
                    int colorEnd = this.getBorderColor(5);
                    if (I18nUtil.getInstance().doLeftAndRightSwapInRTL(this.mContext)) {
                        if (!this.isBorderColorDefined(4)) {
                            colorStart = colorLeft;
                        }
                        if (!this.isBorderColorDefined(5)) {
                            colorEnd = colorRight;
                        }
                        directionAwareColorLeft = isRTL ? colorEnd : colorStart;
                        directionAwareColorRight = isRTL ? colorStart : colorEnd;
                        colorLeft = directionAwareColorLeft;
                        colorRight = directionAwareColorRight;
                    } else {
                        boolean isDirectionAwareColorRightDefined;
                        directionAwareColorLeft = isRTL ? colorEnd : colorStart;
                        directionAwareColorRight = isRTL ? colorStart : colorEnd;
                        boolean isColorStartDefined = this.isBorderColorDefined(4);
                        boolean isColorEndDefined = this.isBorderColorDefined(5);
                        boolean isDirectionAwareColorLeftDefined = isRTL ? isColorEndDefined : isColorStartDefined;
                        boolean bl = isDirectionAwareColorRightDefined = isRTL ? isColorStartDefined : isColorEndDefined;
                        if (isDirectionAwareColorLeftDefined) {
                            colorLeft = directionAwareColorLeft;
                        }
                        if (isDirectionAwareColorRightDefined) {
                            colorRight = directionAwareColorRight;
                        }
                    }
                }
                float left = this.mOuterClipTempRectForBorderRadius.left;
                float right = this.mOuterClipTempRectForBorderRadius.right;
                float top = this.mOuterClipTempRectForBorderRadius.top;
                float bottom = this.mOuterClipTempRectForBorderRadius.bottom;
                if (borderWidth.left > 0.0f) {
                    float x1 = left;
                    float y1 = top;
                    float x2 = this.mInnerTopLeftCorner.x;
                    float y2 = this.mInnerTopLeftCorner.y;
                    float x3 = this.mInnerBottomLeftCorner.x;
                    y3 = this.mInnerBottomLeftCorner.y;
                    x4 = left;
                    y4 = bottom;
                    this.drawQuadrilateral(canvas, colorLeft, x1, y1, x2, y2, x3, y3, x4, y4);
                }
                if (borderWidth.top > 0.0f) {
                    float x1 = left;
                    float y1 = top;
                    float x2 = this.mInnerTopLeftCorner.x;
                    float y2 = this.mInnerTopLeftCorner.y;
                    float x3 = this.mInnerTopRightCorner.x;
                    y3 = this.mInnerTopRightCorner.y;
                    x4 = right;
                    y4 = top;
                    this.drawQuadrilateral(canvas, colorTop, x1, y1, x2, y2, x3, y3, x4, y4);
                }
                if (borderWidth.right > 0.0f) {
                    float x1 = right;
                    float y1 = top;
                    float x2 = this.mInnerTopRightCorner.x;
                    float y2 = this.mInnerTopRightCorner.y;
                    float x3 = this.mInnerBottomRightCorner.x;
                    y3 = this.mInnerBottomRightCorner.y;
                    x4 = right;
                    y4 = bottom;
                    this.drawQuadrilateral(canvas, colorRight, x1, y1, x2, y2, x3, y3, x4, y4);
                }
                if (borderWidth.bottom > 0.0f) {
                    float x1 = left;
                    float y1 = bottom;
                    float x2 = this.mInnerBottomLeftCorner.x;
                    float y2 = this.mInnerBottomLeftCorner.y;
                    float x3 = this.mInnerBottomRightCorner.x;
                    y3 = this.mInnerBottomRightCorner.y;
                    x4 = right;
                    y4 = bottom;
                    this.drawQuadrilateral(canvas, colorBottom, x1, y1, x2, y2, x3, y3, x4, y4);
                }
            }
        }
        canvas.restore();
    }

    private void updatePath() {
        if (!this.mNeedUpdatePathForBorderRadius) {
            return;
        }
        this.mNeedUpdatePathForBorderRadius = false;
        if (this.mInnerClipPathForBorderRadius == null) {
            this.mInnerClipPathForBorderRadius = new Path();
        }
        if (this.mOuterClipPathForBorderRadius == null) {
            this.mOuterClipPathForBorderRadius = new Path();
        }
        if (this.mPathForBorderRadiusOutline == null) {
            this.mPathForBorderRadiusOutline = new Path();
        }
        if (this.mCenterDrawPath == null) {
            this.mCenterDrawPath = new Path();
        }
        if (this.mInnerClipTempRectForBorderRadius == null) {
            this.mInnerClipTempRectForBorderRadius = new RectF();
        }
        if (this.mOuterClipTempRectForBorderRadius == null) {
            this.mOuterClipTempRectForBorderRadius = new RectF();
        }
        if (this.mTempRectForBorderRadiusOutline == null) {
            this.mTempRectForBorderRadiusOutline = new RectF();
        }
        if (this.mTempRectForCenterDrawPath == null) {
            this.mTempRectForCenterDrawPath = new RectF();
        }
        this.mInnerClipPathForBorderRadius.reset();
        this.mOuterClipPathForBorderRadius.reset();
        this.mPathForBorderRadiusOutline.reset();
        this.mCenterDrawPath.reset();
        this.mInnerClipTempRectForBorderRadius.set(this.getBounds());
        this.mOuterClipTempRectForBorderRadius.set(this.getBounds());
        this.mTempRectForBorderRadiusOutline.set(this.getBounds());
        this.mTempRectForCenterDrawPath.set(this.getBounds());
        float fullBorderWidth = this.getFullBorderWidth();
        if (fullBorderWidth > 0.0f) {
            this.mTempRectForCenterDrawPath.inset(fullBorderWidth * 0.5f, fullBorderWidth * 0.5f);
        }
        RectF borderWidth = this.getDirectionAwareBorderInsets();
        this.mInnerClipTempRectForBorderRadius.top += borderWidth.top;
        this.mInnerClipTempRectForBorderRadius.bottom -= borderWidth.bottom;
        this.mInnerClipTempRectForBorderRadius.left += borderWidth.left;
        this.mInnerClipTempRectForBorderRadius.right -= borderWidth.right;
        float borderRadius = this.getFullBorderRadius();
        float topLeftRadius = this.getBorderRadiusOrDefaultTo(borderRadius, BorderRadiusLocation.TOP_LEFT);
        float topRightRadius = this.getBorderRadiusOrDefaultTo(borderRadius, BorderRadiusLocation.TOP_RIGHT);
        float bottomLeftRadius = this.getBorderRadiusOrDefaultTo(borderRadius, BorderRadiusLocation.BOTTOM_LEFT);
        float bottomRightRadius = this.getBorderRadiusOrDefaultTo(borderRadius, BorderRadiusLocation.BOTTOM_RIGHT);
        if (Build.VERSION.SDK_INT >= 17) {
            float directionAwareBottomRightRadius;
            float directionAwareBottomLeftRadius;
            float directionAwareTopRightRadius;
            float directionAwareTopLeftRadius;
            boolean isRTL = this.getResolvedLayoutDirection() == 1;
            float topStartRadius = this.getBorderRadius(BorderRadiusLocation.TOP_START);
            float topEndRadius = this.getBorderRadius(BorderRadiusLocation.TOP_END);
            float bottomStartRadius = this.getBorderRadius(BorderRadiusLocation.BOTTOM_START);
            float bottomEndRadius = this.getBorderRadius(BorderRadiusLocation.BOTTOM_END);
            if (I18nUtil.getInstance().doLeftAndRightSwapInRTL(this.mContext)) {
                if (YogaConstants.isUndefined(topStartRadius)) {
                    topStartRadius = topLeftRadius;
                }
                if (YogaConstants.isUndefined(topEndRadius)) {
                    topEndRadius = topRightRadius;
                }
                if (YogaConstants.isUndefined(bottomStartRadius)) {
                    bottomStartRadius = bottomLeftRadius;
                }
                if (YogaConstants.isUndefined(bottomEndRadius)) {
                    bottomEndRadius = bottomRightRadius;
                }
                directionAwareTopLeftRadius = isRTL ? topEndRadius : topStartRadius;
                directionAwareTopRightRadius = isRTL ? topStartRadius : topEndRadius;
                directionAwareBottomLeftRadius = isRTL ? bottomEndRadius : bottomStartRadius;
                directionAwareBottomRightRadius = isRTL ? bottomStartRadius : bottomEndRadius;
                topLeftRadius = directionAwareTopLeftRadius;
                topRightRadius = directionAwareTopRightRadius;
                bottomLeftRadius = directionAwareBottomLeftRadius;
                bottomRightRadius = directionAwareBottomRightRadius;
            } else {
                directionAwareTopLeftRadius = isRTL ? topEndRadius : topStartRadius;
                directionAwareTopRightRadius = isRTL ? topStartRadius : topEndRadius;
                directionAwareBottomLeftRadius = isRTL ? bottomEndRadius : bottomStartRadius;
                float f = directionAwareBottomRightRadius = isRTL ? bottomStartRadius : bottomEndRadius;
                if (!YogaConstants.isUndefined(directionAwareTopLeftRadius)) {
                    topLeftRadius = directionAwareTopLeftRadius;
                }
                if (!YogaConstants.isUndefined(directionAwareTopRightRadius)) {
                    topRightRadius = directionAwareTopRightRadius;
                }
                if (!YogaConstants.isUndefined(directionAwareBottomLeftRadius)) {
                    bottomLeftRadius = directionAwareBottomLeftRadius;
                }
                if (!YogaConstants.isUndefined(directionAwareBottomRightRadius)) {
                    bottomRightRadius = directionAwareBottomRightRadius;
                }
            }
        }
        float innerTopLeftRadiusX = Math.max(topLeftRadius - borderWidth.left, 0.0f);
        float innerTopLeftRadiusY = Math.max(topLeftRadius - borderWidth.top, 0.0f);
        float innerTopRightRadiusX = Math.max(topRightRadius - borderWidth.right, 0.0f);
        float innerTopRightRadiusY = Math.max(topRightRadius - borderWidth.top, 0.0f);
        float innerBottomRightRadiusX = Math.max(bottomRightRadius - borderWidth.right, 0.0f);
        float innerBottomRightRadiusY = Math.max(bottomRightRadius - borderWidth.bottom, 0.0f);
        float innerBottomLeftRadiusX = Math.max(bottomLeftRadius - borderWidth.left, 0.0f);
        float innerBottomLeftRadiusY = Math.max(bottomLeftRadius - borderWidth.bottom, 0.0f);
        this.mInnerClipPathForBorderRadius.addRoundRect(this.mInnerClipTempRectForBorderRadius, new float[]{innerTopLeftRadiusX, innerTopLeftRadiusY, innerTopRightRadiusX, innerTopRightRadiusY, innerBottomRightRadiusX, innerBottomRightRadiusY, innerBottomLeftRadiusX, innerBottomLeftRadiusY}, Path.Direction.CW);
        this.mOuterClipPathForBorderRadius.addRoundRect(this.mOuterClipTempRectForBorderRadius, new float[]{topLeftRadius, topLeftRadius, topRightRadius, topRightRadius, bottomRightRadius, bottomRightRadius, bottomLeftRadius, bottomLeftRadius}, Path.Direction.CW);
        float extraRadiusForOutline = 0.0f;
        if (this.mBorderWidth != null) {
            extraRadiusForOutline = this.mBorderWidth.get(8) / 2.0f;
        }
        this.mPathForBorderRadiusOutline.addRoundRect(this.mTempRectForBorderRadiusOutline, new float[]{topLeftRadius + extraRadiusForOutline, topLeftRadius + extraRadiusForOutline, topRightRadius + extraRadiusForOutline, topRightRadius + extraRadiusForOutline, bottomRightRadius + extraRadiusForOutline, bottomRightRadius + extraRadiusForOutline, bottomLeftRadius + extraRadiusForOutline, bottomLeftRadius + extraRadiusForOutline}, Path.Direction.CW);
        this.mCenterDrawPath.addRoundRect(this.mTempRectForCenterDrawPath, new float[]{innerTopLeftRadiusX + extraRadiusForOutline, innerTopLeftRadiusY + extraRadiusForOutline, innerTopRightRadiusX + extraRadiusForOutline, innerTopRightRadiusY + extraRadiusForOutline, innerBottomRightRadiusX + extraRadiusForOutline, innerBottomRightRadiusY + extraRadiusForOutline, innerBottomLeftRadiusX + extraRadiusForOutline, innerBottomLeftRadiusY + extraRadiusForOutline}, Path.Direction.CW);
        if (this.mInnerTopLeftCorner == null) {
            this.mInnerTopLeftCorner = new PointF();
        }
        this.mInnerTopLeftCorner.x = this.mInnerClipTempRectForBorderRadius.left;
        this.mInnerTopLeftCorner.y = this.mInnerClipTempRectForBorderRadius.top;
        ReactViewBackgroundDrawable.getEllipseIntersectionWithLine(this.mInnerClipTempRectForBorderRadius.left, this.mInnerClipTempRectForBorderRadius.top, this.mInnerClipTempRectForBorderRadius.left + 2.0f * innerTopLeftRadiusX, this.mInnerClipTempRectForBorderRadius.top + 2.0f * innerTopLeftRadiusY, this.mOuterClipTempRectForBorderRadius.left, this.mOuterClipTempRectForBorderRadius.top, this.mInnerClipTempRectForBorderRadius.left, this.mInnerClipTempRectForBorderRadius.top, this.mInnerTopLeftCorner);
        if (this.mInnerBottomLeftCorner == null) {
            this.mInnerBottomLeftCorner = new PointF();
        }
        this.mInnerBottomLeftCorner.x = this.mInnerClipTempRectForBorderRadius.left;
        this.mInnerBottomLeftCorner.y = this.mInnerClipTempRectForBorderRadius.bottom;
        ReactViewBackgroundDrawable.getEllipseIntersectionWithLine(this.mInnerClipTempRectForBorderRadius.left, this.mInnerClipTempRectForBorderRadius.bottom - 2.0f * innerBottomLeftRadiusY, this.mInnerClipTempRectForBorderRadius.left + 2.0f * innerBottomLeftRadiusX, this.mInnerClipTempRectForBorderRadius.bottom, this.mOuterClipTempRectForBorderRadius.left, this.mOuterClipTempRectForBorderRadius.bottom, this.mInnerClipTempRectForBorderRadius.left, this.mInnerClipTempRectForBorderRadius.bottom, this.mInnerBottomLeftCorner);
        if (this.mInnerTopRightCorner == null) {
            this.mInnerTopRightCorner = new PointF();
        }
        this.mInnerTopRightCorner.x = this.mInnerClipTempRectForBorderRadius.right;
        this.mInnerTopRightCorner.y = this.mInnerClipTempRectForBorderRadius.top;
        ReactViewBackgroundDrawable.getEllipseIntersectionWithLine(this.mInnerClipTempRectForBorderRadius.right - 2.0f * innerTopRightRadiusX, this.mInnerClipTempRectForBorderRadius.top, this.mInnerClipTempRectForBorderRadius.right, this.mInnerClipTempRectForBorderRadius.top + 2.0f * innerTopRightRadiusY, this.mOuterClipTempRectForBorderRadius.right, this.mOuterClipTempRectForBorderRadius.top, this.mInnerClipTempRectForBorderRadius.right, this.mInnerClipTempRectForBorderRadius.top, this.mInnerTopRightCorner);
        if (this.mInnerBottomRightCorner == null) {
            this.mInnerBottomRightCorner = new PointF();
        }
        this.mInnerBottomRightCorner.x = this.mInnerClipTempRectForBorderRadius.right;
        this.mInnerBottomRightCorner.y = this.mInnerClipTempRectForBorderRadius.bottom;
        ReactViewBackgroundDrawable.getEllipseIntersectionWithLine(this.mInnerClipTempRectForBorderRadius.right - 2.0f * innerBottomRightRadiusX, this.mInnerClipTempRectForBorderRadius.bottom - 2.0f * innerBottomRightRadiusY, this.mInnerClipTempRectForBorderRadius.right, this.mInnerClipTempRectForBorderRadius.bottom, this.mOuterClipTempRectForBorderRadius.right, this.mOuterClipTempRectForBorderRadius.bottom, this.mInnerClipTempRectForBorderRadius.right, this.mInnerClipTempRectForBorderRadius.bottom, this.mInnerBottomRightCorner);
    }

    private static void getEllipseIntersectionWithLine(double ellipseBoundsLeft, double ellipseBoundsTop, double ellipseBoundsRight, double ellipseBoundsBottom, double lineStartX, double lineStartY, double lineEndX, double lineEndY, PointF result) {
        double ellipseCenterX = (ellipseBoundsLeft + ellipseBoundsRight) / 2.0;
        double ellipseCenterY = (ellipseBoundsTop + ellipseBoundsBottom) / 2.0;
        double a = Math.abs(ellipseBoundsRight - ellipseBoundsLeft) / 2.0;
        double b = Math.abs(ellipseBoundsBottom - ellipseBoundsTop) / 2.0;
        double m = ((lineEndY -= ellipseCenterY) - (lineStartY -= ellipseCenterY)) / ((lineEndX -= ellipseCenterX) - (lineStartX -= ellipseCenterX));
        double c = lineStartY - m * lineStartX;
        double A = b * b + a * a * m * m;
        double B = 2.0 * a * a * c * m;
        double C = a * a * (c * c - b * b);
        double D = Math.sqrt(-C / A + Math.pow(B / (2.0 * A), 2.0));
        double x2 = -B / (2.0 * A) - D;
        double y2 = m * x2 + c;
        double x = x2 + ellipseCenterX;
        double y = y2 + ellipseCenterY;
        if (!Double.isNaN(x) && !Double.isNaN(y)) {
            result.x = (float)x;
            result.y = (float)y;
        }
    }

    public float getBorderWidthOrDefaultTo(float defaultValue, int spacingType) {
        if (this.mBorderWidth == null) {
            return defaultValue;
        }
        float width = this.mBorderWidth.getRaw(spacingType);
        if (YogaConstants.isUndefined(width)) {
            return defaultValue;
        }
        return width;
    }

    private void updatePathEffect() {
        this.mPathEffectForBorderStyle = this.mBorderStyle != null ? BorderStyle.getPathEffect(this.mBorderStyle, this.getFullBorderWidth()) : null;
        this.mPaint.setPathEffect(this.mPathEffectForBorderStyle);
    }

    public float getFullBorderWidth() {
        return this.mBorderWidth != null && !YogaConstants.isUndefined(this.mBorderWidth.getRaw(8)) ? this.mBorderWidth.getRaw(8) : 0.0f;
    }

    private static int fastBorderCompatibleColorOrZero(int borderLeft, int borderTop, int borderRight, int borderBottom, int colorLeft, int colorTop, int colorRight, int colorBottom) {
        int andSmear = (borderLeft > 0 ? colorLeft : -1) & (borderTop > 0 ? colorTop : -1) & (borderRight > 0 ? colorRight : -1) & (borderBottom > 0 ? colorBottom : -1);
        int orSmear = (borderLeft > 0 ? colorLeft : 0) | (borderTop > 0 ? colorTop : 0) | (borderRight > 0 ? colorRight : 0) | (borderBottom > 0 ? colorBottom : 0);
        return andSmear == orSmear ? andSmear : 0;
    }

    private void drawRectangularBackgroundWithBorders(Canvas canvas) {
        int useColor = ColorUtil.multiplyColorAlpha(this.mColor, this.mAlpha);
        if (Color.alpha((int)useColor) != 0) {
            this.mPaint.setColor(useColor);
            this.mPaint.setStyle(Paint.Style.FILL);
            canvas.drawRect(this.getBounds(), this.mPaint);
        }
        RectF borderWidth = this.getDirectionAwareBorderInsets();
        int borderLeft = Math.round(borderWidth.left);
        int borderTop = Math.round(borderWidth.top);
        int borderRight = Math.round(borderWidth.right);
        int borderBottom = Math.round(borderWidth.bottom);
        if (borderLeft > 0 || borderRight > 0 || borderTop > 0 || borderBottom > 0) {
            Rect bounds = this.getBounds();
            int colorLeft = this.getBorderColor(0);
            int colorTop = this.getBorderColor(1);
            int colorRight = this.getBorderColor(2);
            int colorBottom = this.getBorderColor(3);
            if (Build.VERSION.SDK_INT >= 17) {
                int directionAwareColorRight;
                int directionAwareColorLeft;
                boolean isRTL = this.getResolvedLayoutDirection() == 1;
                int colorStart = this.getBorderColor(4);
                int colorEnd = this.getBorderColor(5);
                if (I18nUtil.getInstance().doLeftAndRightSwapInRTL(this.mContext)) {
                    if (!this.isBorderColorDefined(4)) {
                        colorStart = colorLeft;
                    }
                    if (!this.isBorderColorDefined(5)) {
                        colorEnd = colorRight;
                    }
                    directionAwareColorLeft = isRTL ? colorEnd : colorStart;
                    directionAwareColorRight = isRTL ? colorStart : colorEnd;
                    colorLeft = directionAwareColorLeft;
                    colorRight = directionAwareColorRight;
                } else {
                    boolean isDirectionAwareColorRightDefined;
                    directionAwareColorLeft = isRTL ? colorEnd : colorStart;
                    directionAwareColorRight = isRTL ? colorStart : colorEnd;
                    boolean isColorStartDefined = this.isBorderColorDefined(4);
                    boolean isColorEndDefined = this.isBorderColorDefined(5);
                    boolean isDirectionAwareColorLeftDefined = isRTL ? isColorEndDefined : isColorStartDefined;
                    boolean bl = isDirectionAwareColorRightDefined = isRTL ? isColorStartDefined : isColorEndDefined;
                    if (isDirectionAwareColorLeftDefined) {
                        colorLeft = directionAwareColorLeft;
                    }
                    if (isDirectionAwareColorRightDefined) {
                        colorRight = directionAwareColorRight;
                    }
                }
            }
            int left = bounds.left;
            int top = bounds.top;
            int fastBorderColor = ReactViewBackgroundDrawable.fastBorderCompatibleColorOrZero(borderLeft, borderTop, borderRight, borderBottom, colorLeft, colorTop, colorRight, colorBottom);
            if (fastBorderColor != 0) {
                if (Color.alpha((int)fastBorderColor) != 0) {
                    int right = bounds.right;
                    int bottom = bounds.bottom;
                    this.mPaint.setColor(fastBorderColor);
                    if (borderLeft > 0) {
                        int leftInset = left + borderLeft;
                        canvas.drawRect((float)left, (float)top, (float)leftInset, (float)(bottom - borderBottom), this.mPaint);
                    }
                    if (borderTop > 0) {
                        int topInset = top + borderTop;
                        canvas.drawRect((float)(left + borderLeft), (float)top, (float)right, (float)topInset, this.mPaint);
                    }
                    if (borderRight > 0) {
                        int rightInset = right - borderRight;
                        canvas.drawRect((float)rightInset, (float)(top + borderTop), (float)right, (float)bottom, this.mPaint);
                    }
                    if (borderBottom > 0) {
                        int bottomInset = bottom - borderBottom;
                        canvas.drawRect((float)left, (float)bottomInset, (float)(right - borderRight), (float)bottom, this.mPaint);
                    }
                }
            } else {
                float y4;
                float x4;
                float y3;
                float x3;
                this.mPaint.setAntiAlias(false);
                int width = bounds.width();
                int height = bounds.height();
                if (borderLeft > 0) {
                    float x1 = left;
                    float y1 = top;
                    float x2 = left + borderLeft;
                    float y2 = top + borderTop;
                    x3 = left + borderLeft;
                    y3 = top + height - borderBottom;
                    x4 = left;
                    y4 = top + height;
                    this.drawQuadrilateral(canvas, colorLeft, x1, y1, x2, y2, x3, y3, x4, y4);
                }
                if (borderTop > 0) {
                    float x1 = left;
                    float y1 = top;
                    float x2 = left + borderLeft;
                    float y2 = top + borderTop;
                    x3 = left + width - borderRight;
                    y3 = top + borderTop;
                    x4 = left + width;
                    y4 = top;
                    this.drawQuadrilateral(canvas, colorTop, x1, y1, x2, y2, x3, y3, x4, y4);
                }
                if (borderRight > 0) {
                    float x1 = left + width;
                    float y1 = top;
                    float x2 = left + width;
                    float y2 = top + height;
                    x3 = left + width - borderRight;
                    y3 = top + height - borderBottom;
                    x4 = left + width - borderRight;
                    y4 = top + borderTop;
                    this.drawQuadrilateral(canvas, colorRight, x1, y1, x2, y2, x3, y3, x4, y4);
                }
                if (borderBottom > 0) {
                    float x1 = left;
                    float y1 = top + height;
                    float x2 = left + width;
                    float y2 = top + height;
                    x3 = left + width - borderRight;
                    y3 = top + height - borderBottom;
                    x4 = left + borderLeft;
                    y4 = top + height - borderBottom;
                    this.drawQuadrilateral(canvas, colorBottom, x1, y1, x2, y2, x3, y3, x4, y4);
                }
                this.mPaint.setAntiAlias(true);
            }
        }
    }

    private void drawQuadrilateral(Canvas canvas, int fillColor, float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        if (fillColor == 0) {
            return;
        }
        if (this.mPathForBorder == null) {
            this.mPathForBorder = new Path();
        }
        this.mPaint.setColor(fillColor);
        this.mPathForBorder.reset();
        this.mPathForBorder.moveTo(x1, y1);
        this.mPathForBorder.lineTo(x2, y2);
        this.mPathForBorder.lineTo(x3, y3);
        this.mPathForBorder.lineTo(x4, y4);
        this.mPathForBorder.lineTo(x1, y1);
        canvas.drawPath(this.mPathForBorder, this.mPaint);
    }

    private int getBorderWidth(int position) {
        if (this.mBorderWidth == null) {
            return 0;
        }
        float width = this.mBorderWidth.get(position);
        return YogaConstants.isUndefined(width) ? -1 : Math.round(width);
    }

    private static int colorFromAlphaAndRGBComponents(float alpha, float rgb) {
        int rgbComponent = 0xFFFFFF & (int)rgb;
        int alphaComponent = 0xFF000000 & (int)alpha << 24;
        return rgbComponent | alphaComponent;
    }

    private boolean isBorderColorDefined(int position) {
        float rgb = this.mBorderRGB != null ? this.mBorderRGB.get(position) : Float.NaN;
        float alpha = this.mBorderAlpha != null ? this.mBorderAlpha.get(position) : Float.NaN;
        return !YogaConstants.isUndefined(rgb) && !YogaConstants.isUndefined(alpha);
    }

    private int getBorderColor(int position) {
        float rgb = this.mBorderRGB != null ? this.mBorderRGB.get(position) : 0.0f;
        float alpha = this.mBorderAlpha != null ? this.mBorderAlpha.get(position) : 255.0f;
        return ReactViewBackgroundDrawable.colorFromAlphaAndRGBComponents(alpha, rgb);
    }

    public RectF getDirectionAwareBorderInsets() {
        float borderWidth = this.getBorderWidthOrDefaultTo(0.0f, 8);
        float borderTopWidth = this.getBorderWidthOrDefaultTo(borderWidth, 1);
        float borderBottomWidth = this.getBorderWidthOrDefaultTo(borderWidth, 3);
        float borderLeftWidth = this.getBorderWidthOrDefaultTo(borderWidth, 0);
        float borderRightWidth = this.getBorderWidthOrDefaultTo(borderWidth, 2);
        if (Build.VERSION.SDK_INT >= 17 && this.mBorderWidth != null) {
            boolean isRTL = this.getResolvedLayoutDirection() == 1;
            float borderStartWidth = this.mBorderWidth.getRaw(4);
            float borderEndWidth = this.mBorderWidth.getRaw(5);
            if (I18nUtil.getInstance().doLeftAndRightSwapInRTL(this.mContext)) {
                if (YogaConstants.isUndefined(borderStartWidth)) {
                    borderStartWidth = borderLeftWidth;
                }
                if (YogaConstants.isUndefined(borderEndWidth)) {
                    borderEndWidth = borderRightWidth;
                }
                float directionAwareBorderLeftWidth = isRTL ? borderEndWidth : borderStartWidth;
                float directionAwareBorderRightWidth = isRTL ? borderStartWidth : borderEndWidth;
                borderLeftWidth = directionAwareBorderLeftWidth;
                borderRightWidth = directionAwareBorderRightWidth;
            } else {
                float directionAwareBorderRightWidth;
                float directionAwareBorderLeftWidth = isRTL ? borderEndWidth : borderStartWidth;
                float f = directionAwareBorderRightWidth = isRTL ? borderStartWidth : borderEndWidth;
                if (!YogaConstants.isUndefined(directionAwareBorderLeftWidth)) {
                    borderLeftWidth = directionAwareBorderLeftWidth;
                }
                if (!YogaConstants.isUndefined(directionAwareBorderRightWidth)) {
                    borderRightWidth = directionAwareBorderRightWidth;
                }
            }
        }
        return new RectF(borderLeftWidth, borderTopWidth, borderRightWidth, borderBottomWidth);
    }

    public static enum BorderRadiusLocation {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_RIGHT,
        BOTTOM_LEFT,
        TOP_START,
        TOP_END,
        BOTTOM_START,
        BOTTOM_END;

    }

    private static enum BorderStyle {
        SOLID,
        DASHED,
        DOTTED;


        @Nullable
        public static PathEffect getPathEffect(BorderStyle style2, float borderWidth) {
            switch (style2) {
                case SOLID: {
                    return null;
                }
                case DASHED: {
                    return new DashPathEffect(new float[]{borderWidth * 3.0f, borderWidth * 3.0f, borderWidth * 3.0f, borderWidth * 3.0f}, 0.0f);
                }
                case DOTTED: {
                    return new DashPathEffect(new float[]{borderWidth, borderWidth, borderWidth, borderWidth}, 0.0f);
                }
            }
            return null;
        }
    }
}

