/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.intent;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.module.annotations.ReactModule;
import java.io.Serializable;
import javax.annotation.Nullable;

@ReactModule(name="IntentAndroid")
public class IntentModule
extends ReactContextBaseJavaModule {
    public static final String NAME = "IntentAndroid";

    public IntentModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @ReactMethod
    public void getInitialURL(Promise promise) {
        try {
            Activity currentActivity = this.getCurrentActivity();
            String initialURL = null;
            if (currentActivity != null) {
                Intent intent = currentActivity.getIntent();
                String action = intent.getAction();
                Uri uri = intent.getData();
                if ("android.intent.action.VIEW".equals(action) && uri != null) {
                    initialURL = uri.toString();
                }
            }
            promise.resolve(initialURL);
        }
        catch (Exception e) {
            promise.reject(new JSApplicationIllegalArgumentException("Could not get the initial URL : " + e.getMessage()));
        }
    }

    @ReactMethod
    public void openURL(String url, Promise promise) {
        if (url == null || url.isEmpty()) {
            promise.reject(new JSApplicationIllegalArgumentException("Invalid URL: " + url));
            return;
        }
        try {
            String otherPackageName;
            Activity currentActivity = this.getCurrentActivity();
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url).normalizeScheme());
            String selfPackageName = this.getReactApplicationContext().getPackageName();
            ComponentName componentName = intent.resolveActivity(this.getReactApplicationContext().getPackageManager());
            String string2 = otherPackageName = componentName != null ? componentName.getPackageName() : "";
            if (currentActivity == null || !selfPackageName.equals(otherPackageName)) {
                intent.addFlags(0x10000000);
            }
            if (currentActivity != null) {
                currentActivity.startActivity(intent);
            } else {
                this.getReactApplicationContext().startActivity(intent);
            }
            promise.resolve(true);
        }
        catch (Exception e) {
            promise.reject(new JSApplicationIllegalArgumentException("Could not open URL '" + url + "': " + e.getMessage()));
        }
    }

    @ReactMethod
    public void canOpenURL(String url, Promise promise) {
        if (url == null || url.isEmpty()) {
            promise.reject(new JSApplicationIllegalArgumentException("Invalid URL: " + url));
            return;
        }
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            intent.addFlags(0x10000000);
            boolean canOpen = intent.resolveActivity(this.getReactApplicationContext().getPackageManager()) != null;
            promise.resolve(canOpen);
        }
        catch (Exception e) {
            promise.reject(new JSApplicationIllegalArgumentException("Could not check if URL '" + url + "' can be opened: " + e.getMessage()));
        }
    }

    @ReactMethod
    public void sendIntent(String action, @Nullable ReadableArray extras, Promise promise) {
        if (action == null || action.isEmpty()) {
            promise.reject(new JSApplicationIllegalArgumentException("Invalid Action: " + action + "."));
            return;
        }
        Intent intent = new Intent(action);
        PackageManager packageManager = this.getReactApplicationContext().getPackageManager();
        if (intent.resolveActivity(packageManager) == null) {
            promise.reject(new JSApplicationIllegalArgumentException("Could not launch Intent with action " + action + "."));
            return;
        }
        if (extras != null) {
            block5: for (int i = 0; i < extras.size(); ++i) {
                ReadableMap map = extras.getMap(i);
                String name = map.keySetIterator().nextKey();
                ReadableType type = map.getType(name);
                switch (type) {
                    case String: {
                        intent.putExtra(name, map.getString(name));
                        continue block5;
                    }
                    case Number: {
                        Double number = map.getDouble(name);
                        intent.putExtra(name, (Serializable)number);
                        continue block5;
                    }
                    case Boolean: {
                        intent.putExtra(name, map.getBoolean(name));
                        continue block5;
                    }
                    default: {
                        promise.reject(new JSApplicationIllegalArgumentException("Extra type for " + name + " not supported."));
                        return;
                    }
                }
            }
        }
        this.getReactApplicationContext().startActivity(intent);
    }
}

