/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.events;

import com.facebook.react.common.SystemClock;
import com.facebook.react.uimanager.events.RCTEventEmitter;

public abstract class Event<T extends Event> {
    private static int sUniqueID = 0;
    private boolean mInitialized;
    private int mViewTag;
    private long mTimestampMs;
    private int mUniqueID = sUniqueID++;

    protected Event() {
    }

    protected Event(int viewTag) {
        this.init(viewTag);
    }

    protected void init(int viewTag) {
        this.mViewTag = viewTag;
        this.mTimestampMs = SystemClock.uptimeMillis();
        this.mInitialized = true;
    }

    public final int getViewTag() {
        return this.mViewTag;
    }

    public final long getTimestampMs() {
        return this.mTimestampMs;
    }

    public boolean canCoalesce() {
        return true;
    }

    public T coalesce(T otherEvent) {
        return (T)(this.getTimestampMs() >= ((Event)otherEvent).getTimestampMs() ? this : otherEvent);
    }

    public short getCoalescingKey() {
        return 0;
    }

    public int getUniqueID() {
        return this.mUniqueID;
    }

    public void onDispose() {
    }

    boolean isInitialized() {
        return this.mInitialized;
    }

    final void dispose() {
        this.mInitialized = false;
        this.onDispose();
    }

    public abstract String getEventName();

    public abstract void dispatch(RCTEventEmitter var1);
}

