/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.permissions;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.util.SparseArray;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.core.PermissionAwareActivity;
import com.facebook.react.modules.core.PermissionListener;
import java.util.ArrayList;

@ReactModule(name="PermissionsAndroid")
public class PermissionsModule
extends ReactContextBaseJavaModule
implements PermissionListener {
    private static final String ERROR_INVALID_ACTIVITY = "E_INVALID_ACTIVITY";
    public static final String NAME = "PermissionsAndroid";
    private final SparseArray<Callback> mCallbacks = new SparseArray();
    private int mRequestCode = 0;
    private final String GRANTED = "granted";
    private final String DENIED = "denied";
    private final String NEVER_ASK_AGAIN = "never_ask_again";

    public PermissionsModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @ReactMethod
    public void checkPermission(String permission2, Promise promise) {
        Context context = this.getReactApplicationContext().getBaseContext();
        if (Build.VERSION.SDK_INT < 23) {
            promise.resolve(context.checkPermission(permission2, Process.myPid(), Process.myUid()) == 0);
            return;
        }
        promise.resolve(context.checkSelfPermission(permission2) == 0);
    }

    @ReactMethod
    public void shouldShowRequestPermissionRationale(String permission2, Promise promise) {
        if (Build.VERSION.SDK_INT < 23) {
            promise.resolve(false);
            return;
        }
        try {
            promise.resolve(this.getPermissionAwareActivity().shouldShowRequestPermissionRationale(permission2));
        }
        catch (IllegalStateException e) {
            promise.reject(ERROR_INVALID_ACTIVITY, e);
        }
    }

    @ReactMethod
    public void requestPermission(final String permission2, final Promise promise) {
        Context context = this.getReactApplicationContext().getBaseContext();
        if (Build.VERSION.SDK_INT < 23) {
            promise.resolve(context.checkPermission(permission2, Process.myPid(), Process.myUid()) == 0 ? "granted" : "denied");
            return;
        }
        if (context.checkSelfPermission(permission2) == 0) {
            promise.resolve("granted");
            return;
        }
        try {
            PermissionAwareActivity activity = this.getPermissionAwareActivity();
            this.mCallbacks.put(this.mRequestCode, (Object)new Callback(){

                @Override
                public void invoke(Object ... args) {
                    int[] results = (int[])args[0];
                    if (results.length > 0 && results[0] == 0) {
                        promise.resolve("granted");
                    } else {
                        PermissionAwareActivity activity = (PermissionAwareActivity)args[1];
                        if (activity.shouldShowRequestPermissionRationale(permission2)) {
                            promise.resolve("denied");
                        } else {
                            promise.resolve("never_ask_again");
                        }
                    }
                }
            });
            activity.requestPermissions(new String[]{permission2}, this.mRequestCode, this);
            ++this.mRequestCode;
        }
        catch (IllegalStateException e) {
            promise.reject(ERROR_INVALID_ACTIVITY, e);
        }
    }

    @ReactMethod
    public void requestMultiplePermissions(ReadableArray permissions, final Promise promise) {
        final WritableNativeMap grantedPermissions = new WritableNativeMap();
        final ArrayList<String> permissionsToCheck = new ArrayList<String>();
        int checkedPermissionsCount = 0;
        Context context = this.getReactApplicationContext().getBaseContext();
        for (int i = 0; i < permissions.size(); ++i) {
            String perm = permissions.getString(i);
            if (Build.VERSION.SDK_INT < 23) {
                grantedPermissions.putString(perm, context.checkPermission(perm, Process.myPid(), Process.myUid()) == 0 ? "granted" : "denied");
                ++checkedPermissionsCount;
                continue;
            }
            if (context.checkSelfPermission(perm) == 0) {
                grantedPermissions.putString(perm, "granted");
                ++checkedPermissionsCount;
                continue;
            }
            permissionsToCheck.add(perm);
        }
        if (permissions.size() == checkedPermissionsCount) {
            promise.resolve(grantedPermissions);
            return;
        }
        try {
            PermissionAwareActivity activity = this.getPermissionAwareActivity();
            this.mCallbacks.put(this.mRequestCode, (Object)new Callback(){

                @Override
                public void invoke(Object ... args) {
                    int[] results = (int[])args[0];
                    PermissionAwareActivity activity = (PermissionAwareActivity)args[1];
                    for (int j = 0; j < permissionsToCheck.size(); ++j) {
                        String permission2 = (String)permissionsToCheck.get(j);
                        if (results.length > 0 && results[j] == 0) {
                            grantedPermissions.putString(permission2, "granted");
                            continue;
                        }
                        if (activity.shouldShowRequestPermissionRationale(permission2)) {
                            grantedPermissions.putString(permission2, "denied");
                            continue;
                        }
                        grantedPermissions.putString(permission2, "never_ask_again");
                    }
                    promise.resolve(grantedPermissions);
                }
            });
            activity.requestPermissions(permissionsToCheck.toArray(new String[0]), this.mRequestCode, this);
            ++this.mRequestCode;
        }
        catch (IllegalStateException e) {
            promise.reject(ERROR_INVALID_ACTIVITY, e);
        }
    }

    @Override
    public boolean onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        ((Callback)this.mCallbacks.get(requestCode)).invoke(grantResults, this.getPermissionAwareActivity());
        this.mCallbacks.remove(requestCode);
        return this.mCallbacks.size() == 0;
    }

    private PermissionAwareActivity getPermissionAwareActivity() {
        Activity activity = this.getCurrentActivity();
        if (activity == null) {
            throw new IllegalStateException("Tried to use permissions API while not attached to an Activity.");
        }
        if (!(activity instanceof PermissionAwareActivity)) {
            throw new IllegalStateException("Tried to use permissions API but the host Activity doesn't implement PermissionAwareActivity.");
        }
        return (PermissionAwareActivity)activity;
    }
}

