/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.util.JsonReader;
import android.util.Pair;
import com.facebook.react.bridge.NativeDeltaClient;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.channels.ReadableByteChannel;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;
import okhttp3.Headers;
import okio.BufferedSource;

public abstract class BundleDeltaClient {
    private static final String METRO_DELTA_ID_HEADER = "X-Metro-Delta-ID";
    @Nullable
    private String mRevisionId;

    static boolean isDeltaUrl(String bundleUrl) {
        return bundleUrl.indexOf(".delta?") != -1;
    }

    @Nullable
    static BundleDeltaClient create(ClientType type) {
        switch (type) {
            case DEV_SUPPORT: {
                return new BundleDeltaJavaClient();
            }
            case NATIVE: {
                return new BundleDeltaNativeClient();
            }
        }
        return null;
    }

    public abstract boolean canHandle(ClientType var1);

    protected abstract Pair<Boolean, NativeDeltaClient> processDelta(BufferedSource var1, File var2) throws IOException;

    public final synchronized String extendUrlForDelta(String bundleURL) {
        return this.mRevisionId != null ? bundleURL + "&revisionId=" + this.mRevisionId : bundleURL;
    }

    public synchronized void reset() {
        this.mRevisionId = null;
    }

    public synchronized Pair<Boolean, NativeDeltaClient> processDelta(Headers headers, BufferedSource body, File outputFile) throws IOException {
        this.mRevisionId = headers.get(METRO_DELTA_ID_HEADER);
        return this.processDelta(body, outputFile);
    }

    private static class BundleDeltaNativeClient
    extends BundleDeltaClient {
        private final NativeDeltaClient nativeClient = new NativeDeltaClient();

        private BundleDeltaNativeClient() {
        }

        @Override
        public boolean canHandle(ClientType type) {
            return type == ClientType.NATIVE;
        }

        @Override
        protected Pair<Boolean, NativeDeltaClient> processDelta(BufferedSource body, File outputFile) throws IOException {
            this.nativeClient.processDelta((ReadableByteChannel)body);
            return Pair.create((Object)Boolean.FALSE, (Object)this.nativeClient);
        }

        @Override
        public void reset() {
            super.reset();
            this.nativeClient.reset();
        }
    }

    private static class BundleDeltaJavaClient
    extends BundleDeltaClient {
        byte[] mPreCode;
        byte[] mPostCode;
        final LinkedHashMap<Number, byte[]> mModules = new LinkedHashMap();

        private BundleDeltaJavaClient() {
        }

        @Override
        public boolean canHandle(ClientType type) {
            return type == ClientType.DEV_SUPPORT;
        }

        @Override
        public synchronized void reset() {
            super.reset();
            this.mPreCode = null;
            this.mPostCode = null;
            this.mModules.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Pair<Boolean, NativeDeltaClient> processDelta(BufferedSource body, File outputFile) throws IOException {
            JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(body.inputStream()));
            jsonReader.beginObject();
            int numChangedModules = 0;
            while (jsonReader.hasNext()) {
                String name = jsonReader.nextName();
                if (name.equals("pre")) {
                    this.mPreCode = jsonReader.nextString().getBytes();
                    continue;
                }
                if (name.equals("post")) {
                    this.mPostCode = jsonReader.nextString().getBytes();
                    continue;
                }
                if (name.equals("modules")) {
                    numChangedModules += BundleDeltaJavaClient.setModules(jsonReader, this.mModules);
                    continue;
                }
                if (name.equals("added")) {
                    numChangedModules += BundleDeltaJavaClient.setModules(jsonReader, this.mModules);
                    continue;
                }
                if (name.equals("modified")) {
                    numChangedModules += BundleDeltaJavaClient.setModules(jsonReader, this.mModules);
                    continue;
                }
                if (name.equals("deleted")) {
                    numChangedModules += BundleDeltaJavaClient.removeModules(jsonReader, this.mModules);
                    continue;
                }
                jsonReader.skipValue();
            }
            jsonReader.endObject();
            jsonReader.close();
            if (numChangedModules == 0) {
                return Pair.create((Object)Boolean.FALSE, null);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
            try {
                fileOutputStream.write(this.mPreCode);
                fileOutputStream.write(10);
                for (byte[] code : this.mModules.values()) {
                    fileOutputStream.write(code);
                    fileOutputStream.write(10);
                }
                fileOutputStream.write(this.mPostCode);
                fileOutputStream.write(10);
            }
            finally {
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            return Pair.create((Object)Boolean.TRUE, null);
        }

        private static int setModules(JsonReader jsonReader, LinkedHashMap<Number, byte[]> map) throws IOException {
            jsonReader.beginArray();
            int numModules = 0;
            while (jsonReader.hasNext()) {
                jsonReader.beginArray();
                int moduleId = jsonReader.nextInt();
                map.put(moduleId, jsonReader.nextString().getBytes());
                jsonReader.endArray();
                ++numModules;
            }
            jsonReader.endArray();
            return numModules;
        }

        private static int removeModules(JsonReader jsonReader, LinkedHashMap<Number, byte[]> map) throws IOException {
            jsonReader.beginArray();
            int numModules = 0;
            while (jsonReader.hasNext()) {
                int moduleId = jsonReader.nextInt();
                map.remove(moduleId);
                ++numModules;
            }
            jsonReader.endArray();
            return numModules;
        }
    }

    public static enum ClientType {
        NONE,
        DEV_SUPPORT,
        NATIVE;

    }
}

