/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.accessibilityinfo;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.view.accessibility.AccessibilityManager;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import javax.annotation.Nullable;

@ReactModule(name="AccessibilityInfo")
public class AccessibilityInfoModule
extends ReactContextBaseJavaModule
implements LifecycleEventListener {
    public static final String NAME = "AccessibilityInfo";
    @Nullable
    private AccessibilityManager mAccessibilityManager;
    @Nullable
    private ReactTouchExplorationStateChangeListener mTouchExplorationStateChangeListener;
    private boolean mEnabled = false;
    private static final String EVENT_NAME = "touchExplorationDidChange";

    public AccessibilityInfoModule(ReactApplicationContext context) {
        super(context);
        Context appContext = context.getApplicationContext();
        this.mAccessibilityManager = (AccessibilityManager)appContext.getSystemService("accessibility");
        this.mEnabled = this.mAccessibilityManager.isTouchExplorationEnabled();
        if (Build.VERSION.SDK_INT >= 19) {
            this.mTouchExplorationStateChangeListener = new ReactTouchExplorationStateChangeListener();
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @ReactMethod
    public void isTouchExplorationEnabled(Callback successCallback) {
        successCallback.invoke(this.mEnabled);
    }

    private void updateAndSendChangeEvent(boolean enabled) {
        if (this.mEnabled != enabled) {
            this.mEnabled = enabled;
            this.getReactApplicationContext().getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class).emit(EVENT_NAME, this.mEnabled);
        }
    }

    @Override
    public void onHostResume() {
        if (Build.VERSION.SDK_INT >= 19) {
            this.mAccessibilityManager.addTouchExplorationStateChangeListener((AccessibilityManager.TouchExplorationStateChangeListener)this.mTouchExplorationStateChangeListener);
        }
        this.updateAndSendChangeEvent(this.mAccessibilityManager.isTouchExplorationEnabled());
    }

    @Override
    public void onHostPause() {
        if (Build.VERSION.SDK_INT >= 19) {
            this.mAccessibilityManager.removeTouchExplorationStateChangeListener((AccessibilityManager.TouchExplorationStateChangeListener)this.mTouchExplorationStateChangeListener);
        }
    }

    @Override
    public void initialize() {
        this.getReactApplicationContext().addLifecycleEventListener(this);
        this.updateAndSendChangeEvent(this.mAccessibilityManager.isTouchExplorationEnabled());
    }

    @Override
    public void onCatalystInstanceDestroy() {
        super.onCatalystInstanceDestroy();
        this.getReactApplicationContext().removeLifecycleEventListener(this);
    }

    @Override
    public void onHostDestroy() {
    }

    @TargetApi(value=19)
    private class ReactTouchExplorationStateChangeListener
    implements AccessibilityManager.TouchExplorationStateChangeListener {
        private ReactTouchExplorationStateChangeListener() {
        }

        public void onTouchExplorationStateChanged(boolean enabled) {
            AccessibilityInfoModule.this.updateAndSendChangeEvent(enabled);
        }
    }
}

