/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import android.os.Handler;
import android.os.Looper;
import com.facebook.react.bridge.SoftAssertions;
import javax.annotation.Nullable;

public class UiThreadUtil {
    @Nullable
    private static Handler sMainHandler;

    public static boolean isOnUiThread() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    public static void assertOnUiThread() {
        SoftAssertions.assertCondition(UiThreadUtil.isOnUiThread(), "Expected to run on UI thread!");
    }

    public static void assertNotOnUiThread() {
        SoftAssertions.assertCondition(!UiThreadUtil.isOnUiThread(), "Expected not to run on UI thread!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runOnUiThread(Runnable runnable) {
        Class<UiThreadUtil> clazz = UiThreadUtil.class;
        synchronized (UiThreadUtil.class) {
            if (sMainHandler == null) {
                sMainHandler = new Handler(Looper.getMainLooper());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            sMainHandler.post(runnable);
            return;
        }
    }
}

