/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.appstate;

import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.LifecycleState;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import java.util.HashMap;
import java.util.Map;

@ReactModule(name="AppState")
public class AppStateModule
extends ReactContextBaseJavaModule
implements LifecycleEventListener {
    protected static final String NAME = "AppState";
    public static final String APP_STATE_ACTIVE = "active";
    public static final String APP_STATE_BACKGROUND = "background";
    private static final String INITIAL_STATE = "initialAppState";
    private String mAppState;

    public AppStateModule(ReactApplicationContext reactContext) {
        super(reactContext);
        reactContext.addLifecycleEventListener(this);
        this.mAppState = reactContext.getLifecycleState() == LifecycleState.RESUMED ? APP_STATE_ACTIVE : APP_STATE_BACKGROUND;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Map<String, Object> getConstants() {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        constants.put(INITIAL_STATE, this.mAppState);
        return constants;
    }

    @ReactMethod
    public void getCurrentAppState(Callback success, Callback error) {
        success.invoke(this.createAppStateEventMap());
    }

    @Override
    public void onHostResume() {
        this.mAppState = APP_STATE_ACTIVE;
        this.sendAppStateChangeEvent();
    }

    @Override
    public void onHostPause() {
        this.mAppState = APP_STATE_BACKGROUND;
        this.sendAppStateChangeEvent();
    }

    @Override
    public void onHostDestroy() {
    }

    private WritableMap createAppStateEventMap() {
        WritableMap appState = Arguments.createMap();
        appState.putString("app_state", this.mAppState);
        return appState;
    }

    private void sendAppStateChangeEvent() {
        this.getReactApplicationContext().getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class).emit("appStateDidChange", this.createAppStateEventMap());
    }
}

