/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import android.support.v4.util.Pools;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import javax.annotation.Nullable;

public class DynamicFromArray
implements Dynamic {
    private static final Pools.SimplePool<DynamicFromArray> sPool = new Pools.SimplePool(10);
    @Nullable
    private ReadableArray mArray;
    private int mIndex = -1;

    private DynamicFromArray() {
    }

    public static DynamicFromArray create(ReadableArray array, int index) {
        DynamicFromArray dynamic = (DynamicFromArray)sPool.acquire();
        if (dynamic == null) {
            dynamic = new DynamicFromArray();
        }
        dynamic.mArray = array;
        dynamic.mIndex = index;
        return dynamic;
    }

    @Override
    public void recycle() {
        this.mArray = null;
        this.mIndex = -1;
        sPool.release((Object)this);
    }

    @Override
    public boolean isNull() {
        if (this.mArray == null) {
            throw new IllegalStateException("This dynamic value has been recycled");
        }
        return this.mArray.isNull(this.mIndex);
    }

    @Override
    public boolean asBoolean() {
        if (this.mArray == null) {
            throw new IllegalStateException("This dynamic value has been recycled");
        }
        return this.mArray.getBoolean(this.mIndex);
    }

    @Override
    public double asDouble() {
        if (this.mArray == null) {
            throw new IllegalStateException("This dynamic value has been recycled");
        }
        return this.mArray.getDouble(this.mIndex);
    }

    @Override
    public int asInt() {
        if (this.mArray == null) {
            throw new IllegalStateException("This dynamic value has been recycled");
        }
        return this.mArray.getInt(this.mIndex);
    }

    @Override
    public String asString() {
        if (this.mArray == null) {
            throw new IllegalStateException("This dynamic value has been recycled");
        }
        return this.mArray.getString(this.mIndex);
    }

    @Override
    public ReadableArray asArray() {
        if (this.mArray == null) {
            throw new IllegalStateException("This dynamic value has been recycled");
        }
        return this.mArray.getArray(this.mIndex);
    }

    @Override
    public ReadableMap asMap() {
        if (this.mArray == null) {
            throw new IllegalStateException("This dynamic value has been recycled");
        }
        return this.mArray.getMap(this.mIndex);
    }

    @Override
    public ReadableType getType() {
        if (this.mArray == null) {
            throw new IllegalStateException("This dynamic value has been recycled");
        }
        return this.mArray.getType(this.mIndex);
    }
}

