/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.debug;

import com.facebook.react.bridge.NotThreadSafeBridgeIdleDebugListener;
import com.facebook.react.common.LongArray;
import com.facebook.react.uimanager.debug.NotThreadSafeViewHierarchyUpdateDebugListener;

public class DidJSUpdateUiDuringFrameDetector
implements NotThreadSafeBridgeIdleDebugListener,
NotThreadSafeViewHierarchyUpdateDebugListener {
    private final LongArray mTransitionToIdleEvents = LongArray.createWithInitialCapacity(20);
    private final LongArray mTransitionToBusyEvents = LongArray.createWithInitialCapacity(20);
    private final LongArray mViewHierarchyUpdateEnqueuedEvents = LongArray.createWithInitialCapacity(20);
    private final LongArray mViewHierarchyUpdateFinishedEvents = LongArray.createWithInitialCapacity(20);
    private volatile boolean mWasIdleAtEndOfLastFrame = true;

    @Override
    public synchronized void onTransitionToBridgeIdle() {
        this.mTransitionToIdleEvents.add(System.nanoTime());
    }

    @Override
    public synchronized void onTransitionToBridgeBusy() {
        this.mTransitionToBusyEvents.add(System.nanoTime());
    }

    @Override
    public synchronized void onBridgeDestroyed() {
    }

    @Override
    public synchronized void onViewHierarchyUpdateEnqueued() {
        this.mViewHierarchyUpdateEnqueuedEvents.add(System.nanoTime());
    }

    @Override
    public synchronized void onViewHierarchyUpdateFinished() {
        this.mViewHierarchyUpdateFinishedEvents.add(System.nanoTime());
    }

    public synchronized boolean getDidJSHitFrameAndCleanup(long frameStartTimeNanos, long frameEndTimeNanos) {
        boolean finishedUiUpdate = DidJSUpdateUiDuringFrameDetector.hasEventBetweenTimestamps(this.mViewHierarchyUpdateFinishedEvents, frameStartTimeNanos, frameEndTimeNanos);
        boolean didEndFrameIdle = this.didEndFrameIdle(frameStartTimeNanos, frameEndTimeNanos);
        boolean hitFrame = finishedUiUpdate ? true : didEndFrameIdle && !DidJSUpdateUiDuringFrameDetector.hasEventBetweenTimestamps(this.mViewHierarchyUpdateEnqueuedEvents, frameStartTimeNanos, frameEndTimeNanos);
        DidJSUpdateUiDuringFrameDetector.cleanUp(this.mTransitionToIdleEvents, frameEndTimeNanos);
        DidJSUpdateUiDuringFrameDetector.cleanUp(this.mTransitionToBusyEvents, frameEndTimeNanos);
        DidJSUpdateUiDuringFrameDetector.cleanUp(this.mViewHierarchyUpdateEnqueuedEvents, frameEndTimeNanos);
        DidJSUpdateUiDuringFrameDetector.cleanUp(this.mViewHierarchyUpdateFinishedEvents, frameEndTimeNanos);
        this.mWasIdleAtEndOfLastFrame = didEndFrameIdle;
        return hitFrame;
    }

    private static boolean hasEventBetweenTimestamps(LongArray eventArray, long startTime, long endTime) {
        for (int i = 0; i < eventArray.size(); ++i) {
            long time = eventArray.get(i);
            if (time < startTime || time >= endTime) continue;
            return true;
        }
        return false;
    }

    private static long getLastEventBetweenTimestamps(LongArray eventArray, long startTime, long endTime) {
        long lastEvent = -1L;
        for (int i = 0; i < eventArray.size(); ++i) {
            long time = eventArray.get(i);
            if (time >= startTime && time < endTime) {
                lastEvent = time;
                continue;
            }
            if (time >= endTime) break;
        }
        return lastEvent;
    }

    private boolean didEndFrameIdle(long startTime, long endTime) {
        long lastIdleTransition = DidJSUpdateUiDuringFrameDetector.getLastEventBetweenTimestamps(this.mTransitionToIdleEvents, startTime, endTime);
        long lastBusyTransition = DidJSUpdateUiDuringFrameDetector.getLastEventBetweenTimestamps(this.mTransitionToBusyEvents, startTime, endTime);
        if (lastIdleTransition == -1L && lastBusyTransition == -1L) {
            return this.mWasIdleAtEndOfLastFrame;
        }
        return lastIdleTransition > lastBusyTransition;
    }

    private static void cleanUp(LongArray eventArray, long endTime) {
        int i;
        int size = eventArray.size();
        int indicesToRemove = 0;
        for (i = 0; i < size; ++i) {
            if (eventArray.get(i) >= endTime) continue;
            ++indicesToRemove;
        }
        if (indicesToRemove > 0) {
            for (i = 0; i < size - indicesToRemove; ++i) {
                eventArray.set(i, eventArray.get(i + indicesToRemove));
            }
            eventArray.dropTail(indicesToRemove);
        }
    }
}

