/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric;

import android.util.Pair;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeArray;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.fabric.FabricUIManager;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.facebook.systrace.Systrace;
import java.util.HashSet;
import javax.annotation.Nullable;

public class FabricEventEmitter
implements RCTEventEmitter {
    private static final String TAG = FabricEventEmitter.class.getSimpleName();
    private final FabricUIManager mUIManager;

    public FabricEventEmitter(FabricUIManager uiManager) {
        this.mUIManager = uiManager;
    }

    @Override
    public void receiveEvent(int reactTag, String eventName, @Nullable WritableMap params) {
        Systrace.beginSection(0L, "FabricEventEmitter.receiveEvent('" + eventName + "')");
        this.mUIManager.receiveEvent(reactTag, eventName, params);
        Systrace.endSection(0L);
    }

    @Override
    public void receiveTouches(String eventTopLevelType, WritableArray touches, WritableArray changedIndices) {
        Pair<WritableArray, WritableArray> result = "topTouchEnd".equalsIgnoreCase(eventTopLevelType) || "topTouchCancel".equalsIgnoreCase(eventTopLevelType) ? this.removeTouchesAtIndices(touches, changedIndices) : this.touchSubsequence(touches, changedIndices);
        WritableArray changedTouches = (WritableArray)result.first;
        touches = (WritableArray)result.second;
        for (int jj = 0; jj < changedTouches.size(); ++jj) {
            WritableMap touch = this.getWritableMap(changedTouches.getMap(jj));
            touch.putArray("changedTouches", this.copyWritableArray(changedTouches));
            touch.putArray("touches", this.copyWritableArray(touches));
            WritableMap nativeEvent = touch;
            int rootNodeID = 0;
            int target = nativeEvent.getInt("target");
            if (target < 1) {
                FLog.e((String)TAG, (String)"A view is reporting that a touch occurred on tag zero.");
            } else {
                rootNodeID = target;
            }
            this.receiveEvent(rootNodeID, eventTopLevelType, touch);
        }
    }

    private WritableArray copyWritableArray(WritableArray array) {
        WritableNativeArray ret = new WritableNativeArray();
        for (int i = 0; i < array.size(); ++i) {
            ret.pushMap(this.getWritableMap(array.getMap(i)));
        }
        return ret;
    }

    private Pair<WritableArray, WritableArray> removeTouchesAtIndices(WritableArray touches, WritableArray indices) {
        WritableNativeArray rippedOut = new WritableNativeArray();
        WritableNativeArray tempTouches = new WritableNativeArray();
        HashSet<Integer> rippedOutIndices = new HashSet<Integer>();
        for (int i = 0; i < indices.size(); ++i) {
            int index = indices.getInt(i);
            rippedOut.pushMap(this.getWritableMap(touches.getMap(index)));
            rippedOutIndices.add(index);
        }
        for (int j = 0; j < touches.size(); ++j) {
            if (rippedOutIndices.contains(j)) continue;
            tempTouches.pushMap(this.getWritableMap(touches.getMap(j)));
        }
        return new Pair((Object)rippedOut, (Object)tempTouches);
    }

    private Pair<WritableArray, WritableArray> touchSubsequence(WritableArray touches, WritableArray changedIndices) {
        WritableNativeArray result = new WritableNativeArray();
        for (int i = 0; i < changedIndices.size(); ++i) {
            result.pushMap(this.getWritableMap(touches.getMap(changedIndices.getInt(i))));
        }
        return new Pair((Object)result, (Object)touches);
    }

    private WritableMap getWritableMap(ReadableMap readableMap) {
        WritableNativeMap map = new WritableNativeMap();
        map.merge(readableMap);
        return map;
    }
}

