/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import android.util.Log;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.JSInstance;
import com.facebook.react.bridge.JavaModuleWrapper;
import com.facebook.react.bridge.ModuleHolder;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.OnBatchCompleteListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.systrace.Systrace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class NativeModuleRegistry {
    private final ReactApplicationContext mReactApplicationContext;
    private final Map<String, ModuleHolder> mModules;
    private NativeModule mUIManager;

    public NativeModuleRegistry(ReactApplicationContext reactApplicationContext, Map<String, ModuleHolder> modules) {
        this.mReactApplicationContext = reactApplicationContext;
        this.mModules = modules;
    }

    private Map<String, ModuleHolder> getModuleMap() {
        return this.mModules;
    }

    private ReactApplicationContext getReactApplicationContext() {
        return this.mReactApplicationContext;
    }

    Collection<JavaModuleWrapper> getJavaModules(JSInstance jsInstance) {
        ArrayList<JavaModuleWrapper> javaModules = new ArrayList<JavaModuleWrapper>();
        for (Map.Entry<String, ModuleHolder> entry : this.mModules.entrySet()) {
            if (entry.getValue().isCxxModule()) continue;
            javaModules.add(new JavaModuleWrapper(jsInstance, entry.getValue()));
        }
        return javaModules;
    }

    Collection<ModuleHolder> getCxxModules() {
        ArrayList<ModuleHolder> cxxModules = new ArrayList<ModuleHolder>();
        for (Map.Entry<String, ModuleHolder> entry : this.mModules.entrySet()) {
            if (!entry.getValue().isCxxModule()) continue;
            cxxModules.add(entry.getValue());
        }
        return cxxModules;
    }

    void registerModules(NativeModuleRegistry newRegister) {
        Assertions.assertCondition((boolean)((Object)((Object)this.mReactApplicationContext)).equals((Object)newRegister.getReactApplicationContext()), (String)"Extending native modules with non-matching application contexts.");
        Map<String, ModuleHolder> newModules = newRegister.getModuleMap();
        for (Map.Entry<String, ModuleHolder> entry : newModules.entrySet()) {
            String key = entry.getKey();
            if (this.mModules.containsKey(key)) continue;
            ModuleHolder value = entry.getValue();
            Log.e((String)"kris test module", (String)key);
            if ("UIManager".equals(key)) {
                this.mUIManager = value.getModule();
            }
            this.mModules.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyJSInstanceDestroy(boolean clear) {
        this.mReactApplicationContext.assertOnNativeModulesQueueThread();
        Systrace.beginSection(0L, "NativeModuleRegistry_notifyJSInstanceDestroy");
        try {
            for (ModuleHolder module : this.mModules.values()) {
                module.destroy();
            }
            Log.e((String)"kris", (String)("notifyJSInstanceDestroy clear:" + clear));
            if (clear) {
                this.clearNativeModule();
            }
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    public void clearNativeModule() {
        this.mUIManager = this.getModule("UIManager");
        if (this.mUIManager != null) {
            Log.e((String)"kris", (String)"UIManager not null");
        }
        if (this.mModules != null) {
            this.mModules.clear();
        }
    }

    void notifyJSInstanceInitialized() {
        this.mReactApplicationContext.assertOnNativeModulesQueueThread("From version React Native v0.44, native modules are explicitly not initialized on the UI thread. See https://github.com/facebook/react-native/wiki/Breaking-Changes#d4611211-reactnativeandroidbreaking-move-nativemodule-initialization-off-ui-thread---aaachiuuu  for more details.");
        ReactMarker.logMarker(ReactMarkerConstants.NATIVE_MODULE_INITIALIZE_START);
        Systrace.beginSection(0L, "NativeModuleRegistry_notifyJSInstanceInitialized");
        try {
            for (ModuleHolder module : this.mModules.values()) {
                module.markInitializable();
            }
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker(ReactMarkerConstants.NATIVE_MODULE_INITIALIZE_END);
        }
    }

    public void onBatchComplete() {
        ModuleHolder moduleHolder = this.mModules.get("UIManager");
        if (moduleHolder != null && moduleHolder.hasInstance()) {
            ((OnBatchCompleteListener)((Object)moduleHolder.getModule())).onBatchComplete();
        }
    }

    public <T extends NativeModule> boolean hasModule(Class<T> moduleInterface) {
        String name = moduleInterface.getAnnotation(ReactModule.class).name();
        return this.mModules.containsKey(name);
    }

    public <T extends NativeModule> T getModule(Class<T> moduleInterface) {
        ReactModule annotation = moduleInterface.getAnnotation(ReactModule.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Could not find @ReactModule annotation in class " + moduleInterface.getName());
        }
        ModuleHolder moduleHolder = this.mModules.get(annotation.name());
        if (moduleHolder == null) {
            if ("UIManager".equals(annotation.name())) {
                Log.e((String)"kris", (String)("get default UIManager2" + (this.mUIManager == null)));
                return (T)this.mUIManager;
            }
            return null;
        }
        return (T)moduleHolder.getModule();
    }

    public boolean hasModule(String name) {
        return this.mModules.containsKey(name);
    }

    public NativeModule getModule(String name) {
        ModuleHolder moduleHolder = this.mModules.get(name);
        if (moduleHolder == null) {
            if ("UIManager".equals(name)) {
                Log.e((String)"kris", (String)("get default UIManager" + (this.mUIManager == null)));
                return this.mUIManager;
            }
            return null;
        }
        return moduleHolder.getModule();
    }

    public List<NativeModule> getAllModules() {
        ArrayList<NativeModule> modules = new ArrayList<NativeModule>();
        for (ModuleHolder module : this.mModules.values()) {
            modules.add(module.getModule());
        }
        return modules;
    }
}

