/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric.mounting;

import android.support.annotation.UiThread;
import android.view.View;
import com.facebook.react.common.ClearableSynchronizedPool;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.ViewManagerRegistry;
import java.util.HashMap;
import java.util.Map;

public final class ViewPool {
    private static final int POOL_SIZE = 512;
    private final Map<String, ClearableSynchronizedPool<View>> mViewPool = new HashMap<String, ClearableSynchronizedPool<View>>();
    private final ViewManagerRegistry mViewManagerRegistry;

    ViewPool(ViewManagerRegistry viewManagerRegistry) {
        this.mViewManagerRegistry = viewManagerRegistry;
    }

    @UiThread
    void createView(String componentName, ThemedReactContext context) {
        ClearableSynchronizedPool<View> viewPool = this.getViewPoolForComponent(componentName);
        ViewManager viewManager = this.mViewManagerRegistry.get(componentName);
        if (viewManager == null) {
            return;
        }
        Object view = viewManager.createView(context, null);
        viewPool.release((View)view);
    }

    @UiThread
    View getOrCreateView(String componentName, ThemedReactContext context) {
        ClearableSynchronizedPool<View> viewPool = this.getViewPoolForComponent(componentName);
        View view = viewPool.acquire();
        if (view == null) {
            this.createView(componentName, context);
            view = viewPool.acquire();
        }
        return view;
    }

    @UiThread
    void returnToPool(String componentName, View view) {
        ClearableSynchronizedPool<View> viewPool = this.mViewPool.get(componentName);
        if (viewPool != null) {
            viewPool.release(view);
        }
    }

    private ClearableSynchronizedPool<View> getViewPoolForComponent(String componentName) {
        ClearableSynchronizedPool<Object> viewPool = this.mViewPool.get(componentName);
        if (viewPool == null) {
            viewPool = new ClearableSynchronizedPool(512);
            this.mViewPool.put(componentName, viewPool);
        }
        return viewPool;
    }
}

