/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ActivityEventListener;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.JavaScriptContextHolder;
import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.NativeModuleCallExceptionHandler;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.queue.MessageQueueThread;
import com.facebook.react.bridge.queue.ReactQueueConfiguration;
import com.facebook.react.common.LifecycleState;
import java.lang.ref.WeakReference;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nullable;

public class ReactContext
extends ContextWrapper {
    private static final String EARLY_JS_ACCESS_EXCEPTION_MESSAGE = "Tried to access a JS module before the React instance was fully set up. Calls to ReactContext#getJSModule should only happen once initialize() has been called on your native module.";
    private final CopyOnWriteArraySet<LifecycleEventListener> mLifecycleEventListeners = new CopyOnWriteArraySet();
    private final CopyOnWriteArraySet<ActivityEventListener> mActivityEventListeners = new CopyOnWriteArraySet();
    private LifecycleState mLifecycleState = LifecycleState.BEFORE_CREATE;
    @Nullable
    private CatalystInstance mCatalystInstance;
    @Nullable
    private LayoutInflater mInflater;
    @Nullable
    private MessageQueueThread mUiMessageQueueThread;
    @Nullable
    private MessageQueueThread mNativeModulesMessageQueueThread;
    @Nullable
    private MessageQueueThread mJSMessageQueueThread;
    @Nullable
    private NativeModuleCallExceptionHandler mNativeModuleCallExceptionHandler;
    @Nullable
    private WeakReference<Activity> mCurrentActivity;

    public ReactContext(Context base) {
        super(base);
    }

    public void initializeWithInstance(CatalystInstance catalystInstance) {
        if (catalystInstance == null) {
            throw new IllegalArgumentException("CatalystInstance cannot be null.");
        }
        if (this.mCatalystInstance != null) {
            throw new IllegalStateException("ReactContext has been already initialized");
        }
        this.mCatalystInstance = catalystInstance;
        ReactQueueConfiguration queueConfig = catalystInstance.getReactQueueConfiguration();
        this.mUiMessageQueueThread = queueConfig.getUIQueueThread();
        this.mNativeModulesMessageQueueThread = queueConfig.getNativeModulesQueueThread();
        this.mJSMessageQueueThread = queueConfig.getJSQueueThread();
    }

    public void resetPerfStats() {
        if (this.mNativeModulesMessageQueueThread != null) {
            this.mNativeModulesMessageQueueThread.resetPerfStats();
        }
        if (this.mJSMessageQueueThread != null) {
            this.mJSMessageQueueThread.resetPerfStats();
        }
    }

    public void setNativeModuleCallExceptionHandler(@Nullable NativeModuleCallExceptionHandler nativeModuleCallExceptionHandler) {
        this.mNativeModuleCallExceptionHandler = nativeModuleCallExceptionHandler;
    }

    public Object getSystemService(String name) {
        if ("layout_inflater".equals(name)) {
            if (this.mInflater == null) {
                this.mInflater = LayoutInflater.from((Context)this.getBaseContext()).cloneInContext((Context)this);
            }
            return this.mInflater;
        }
        return this.getBaseContext().getSystemService(name);
    }

    public <T extends JavaScriptModule> T getJSModule(Class<T> jsInterface) {
        if (this.mCatalystInstance == null) {
            throw new RuntimeException(EARLY_JS_ACCESS_EXCEPTION_MESSAGE);
        }
        return this.mCatalystInstance.getJSModule(jsInterface);
    }

    public <T extends NativeModule> boolean hasNativeModule(Class<T> nativeModuleInterface) {
        if (this.mCatalystInstance == null) {
            throw new RuntimeException("Trying to call native module before CatalystInstance has been set!");
        }
        return this.mCatalystInstance.hasNativeModule(nativeModuleInterface);
    }

    public <T extends NativeModule> T getNativeModule(Class<T> nativeModuleInterface) {
        if (this.mCatalystInstance == null) {
            throw new RuntimeException("Trying to call native module before CatalystInstance has been set!");
        }
        return this.mCatalystInstance.getNativeModule(nativeModuleInterface);
    }

    public CatalystInstance getCatalystInstance() {
        return this.mCatalystInstance;
    }

    public boolean hasActiveCatalystInstance() {
        return this.mCatalystInstance != null && !this.mCatalystInstance.isDestroyed();
    }

    public LifecycleState getLifecycleState() {
        return this.mLifecycleState;
    }

    public void addLifecycleEventListener(final LifecycleEventListener listener) {
        this.mLifecycleEventListeners.add(listener);
        if (this.hasActiveCatalystInstance()) {
            switch (this.mLifecycleState) {
                case BEFORE_CREATE: 
                case BEFORE_RESUME: {
                    break;
                }
                case RESUMED: {
                    this.runOnUiQueueThread(new Runnable(){

                        @Override
                        public void run() {
                            if (!ReactContext.this.mLifecycleEventListeners.contains(listener)) {
                                return;
                            }
                            try {
                                listener.onHostResume();
                            }
                            catch (RuntimeException e) {
                                ReactContext.this.handleException(e);
                            }
                        }
                    });
                    break;
                }
                default: {
                    throw new RuntimeException("Unhandled lifecycle state.");
                }
            }
        }
    }

    public void removeLifecycleEventListener(LifecycleEventListener listener) {
        this.mLifecycleEventListeners.remove(listener);
    }

    public void addActivityEventListener(ActivityEventListener listener) {
        this.mActivityEventListeners.add(listener);
    }

    public void removeActivityEventListener(ActivityEventListener listener) {
        this.mActivityEventListeners.remove(listener);
    }

    public void onHostResume(@Nullable Activity activity) {
        this.mLifecycleState = LifecycleState.RESUMED;
        this.mCurrentActivity = new WeakReference<Activity>(activity);
        ReactMarker.logMarker(ReactMarkerConstants.ON_HOST_RESUME_START);
        for (LifecycleEventListener listener : this.mLifecycleEventListeners) {
            try {
                listener.onHostResume();
            }
            catch (RuntimeException e) {
                this.handleException(e);
            }
        }
        ReactMarker.logMarker(ReactMarkerConstants.ON_HOST_RESUME_END);
    }

    public void onNewIntent(@Nullable Activity activity, Intent intent) {
        UiThreadUtil.assertOnUiThread();
        this.mCurrentActivity = new WeakReference<Activity>(activity);
        for (ActivityEventListener listener : this.mActivityEventListeners) {
            try {
                listener.onNewIntent(intent);
            }
            catch (RuntimeException e) {
                this.handleException(e);
            }
        }
    }

    public void onHostPause() {
        this.mLifecycleState = LifecycleState.BEFORE_RESUME;
        ReactMarker.logMarker(ReactMarkerConstants.ON_HOST_PAUSE_START);
        for (LifecycleEventListener listener : this.mLifecycleEventListeners) {
            try {
                listener.onHostPause();
            }
            catch (RuntimeException e) {
                this.handleException(e);
            }
        }
        ReactMarker.logMarker(ReactMarkerConstants.ON_HOST_PAUSE_END);
    }

    public void onHostDestroy() {
        UiThreadUtil.assertOnUiThread();
        this.mLifecycleState = LifecycleState.BEFORE_CREATE;
        for (LifecycleEventListener listener : this.mLifecycleEventListeners) {
            try {
                listener.onHostDestroy();
            }
            catch (RuntimeException e) {
                this.handleException(e);
            }
        }
        this.mCurrentActivity = null;
    }

    public void destroy(boolean clearRegistry) {
        UiThreadUtil.assertOnUiThread();
        if (this.mCatalystInstance != null) {
            this.mCatalystInstance.destroy();
            Log.e((String)"ReactContext", (String)("clearRegistry:" + clearRegistry));
            if (clearRegistry) {
                Log.e((String)"ReactContext", (String)"clear Registry now");
            }
        }
    }

    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {
        for (ActivityEventListener listener : this.mActivityEventListeners) {
            try {
                listener.onActivityResult(activity, requestCode, resultCode, data);
            }
            catch (RuntimeException e) {
                this.handleException(e);
            }
        }
    }

    public void assertOnUiQueueThread() {
        ((MessageQueueThread)Assertions.assertNotNull((Object)this.mUiMessageQueueThread)).assertIsOnThread();
    }

    public boolean isOnUiQueueThread() {
        return ((MessageQueueThread)Assertions.assertNotNull((Object)this.mUiMessageQueueThread)).isOnThread();
    }

    public void runOnUiQueueThread(Runnable runnable) {
        ((MessageQueueThread)Assertions.assertNotNull((Object)this.mUiMessageQueueThread)).runOnQueue(runnable);
    }

    public void assertOnNativeModulesQueueThread() {
        ((MessageQueueThread)Assertions.assertNotNull((Object)this.mNativeModulesMessageQueueThread)).assertIsOnThread();
    }

    public void assertOnNativeModulesQueueThread(String message) {
        ((MessageQueueThread)Assertions.assertNotNull((Object)this.mNativeModulesMessageQueueThread)).assertIsOnThread(message);
    }

    public boolean isOnNativeModulesQueueThread() {
        return ((MessageQueueThread)Assertions.assertNotNull((Object)this.mNativeModulesMessageQueueThread)).isOnThread();
    }

    public void runOnNativeModulesQueueThread(Runnable runnable) {
        ((MessageQueueThread)Assertions.assertNotNull((Object)this.mNativeModulesMessageQueueThread)).runOnQueue(runnable);
    }

    public void assertOnJSQueueThread() {
        ((MessageQueueThread)Assertions.assertNotNull((Object)this.mJSMessageQueueThread)).assertIsOnThread();
    }

    public boolean isOnJSQueueThread() {
        return ((MessageQueueThread)Assertions.assertNotNull((Object)this.mJSMessageQueueThread)).isOnThread();
    }

    public void runOnJSQueueThread(Runnable runnable) {
        ((MessageQueueThread)Assertions.assertNotNull((Object)this.mJSMessageQueueThread)).runOnQueue(runnable);
    }

    public void handleException(Exception e) {
        if (this.mCatalystInstance != null && !this.mCatalystInstance.isDestroyed() && this.mNativeModuleCallExceptionHandler != null) {
            this.mNativeModuleCallExceptionHandler.handleException(e);
        }
    }

    public boolean hasCurrentActivity() {
        return this.mCurrentActivity != null && this.mCurrentActivity.get() != null;
    }

    public boolean startActivityForResult(Intent intent, int code, Bundle bundle) {
        Activity activity = this.getCurrentActivity();
        Assertions.assertNotNull((Object)activity);
        activity.startActivityForResult(intent, code, bundle);
        return true;
    }

    @Nullable
    public Activity getCurrentActivity() {
        if (this.mCurrentActivity == null) {
            return null;
        }
        return (Activity)this.mCurrentActivity.get();
    }

    public JavaScriptContextHolder getJavaScriptContextHolder() {
        return this.mCatalystInstance.getJavaScriptContextHolder();
    }
}

