/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.Inspector;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class InspectorPackagerConnection {
    private static final String TAG = "InspectorPackagerConnection";
    private final Connection mConnection;
    private final Map<String, Inspector.LocalConnection> mInspectorConnections;
    private final String mPackageName;
    private BundleStatusProvider mBundleStatusProvider;

    public InspectorPackagerConnection(String url, String packageName, BundleStatusProvider bundleStatusProvider) {
        this.mConnection = new Connection(url);
        this.mInspectorConnections = new HashMap<String, Inspector.LocalConnection>();
        this.mPackageName = packageName;
        this.mBundleStatusProvider = bundleStatusProvider;
    }

    public void connect() {
        this.mConnection.connect();
    }

    public void closeQuietly() {
        this.mConnection.close();
    }

    public void sendEventToAllConnections(String event) {
        for (Map.Entry<String, Inspector.LocalConnection> inspectorConnectionEntry : this.mInspectorConnections.entrySet()) {
            Inspector.LocalConnection inspectorConnection = inspectorConnectionEntry.getValue();
            inspectorConnection.sendMessage(event);
        }
    }

    void handleProxyMessage(JSONObject message) throws JSONException, IOException {
        String event;
        switch (event = message.getString("event")) {
            case "getPages": {
                this.sendEvent("getPages", this.getPages());
                break;
            }
            case "wrappedEvent": {
                this.handleWrappedEvent(message.getJSONObject("payload"));
                break;
            }
            case "connect": {
                this.handleConnect(message.getJSONObject("payload"));
                break;
            }
            case "disconnect": {
                this.handleDisconnect(message.getJSONObject("payload"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown event: " + event);
            }
        }
    }

    void closeAllConnections() {
        for (Map.Entry<String, Inspector.LocalConnection> entry : this.mInspectorConnections.entrySet()) {
            entry.getValue().disconnect();
        }
        this.mInspectorConnections.clear();
    }

    private void handleConnect(JSONObject payload) throws JSONException {
        final String pageId = payload.getString("pageId");
        Inspector.LocalConnection inspectorConnection = this.mInspectorConnections.remove(pageId);
        if (inspectorConnection != null) {
            throw new IllegalStateException("Already connected: " + pageId);
        }
        try {
            inspectorConnection = Inspector.connect(Integer.parseInt(pageId), new Inspector.RemoteConnection(){

                @Override
                public void onMessage(String message) {
                    try {
                        InspectorPackagerConnection.this.sendWrappedEvent(pageId, message);
                    }
                    catch (JSONException e) {
                        FLog.w((String)InspectorPackagerConnection.TAG, (String)"Couldn't send event to packager", (Throwable)e);
                    }
                }

                @Override
                public void onDisconnect() {
                    try {
                        InspectorPackagerConnection.this.mInspectorConnections.remove(pageId);
                        InspectorPackagerConnection.this.sendEvent("disconnect", InspectorPackagerConnection.this.makePageIdPayload(pageId));
                    }
                    catch (JSONException e) {
                        FLog.w((String)InspectorPackagerConnection.TAG, (String)"Couldn't send event to packager", (Throwable)e);
                    }
                }
            });
            this.mInspectorConnections.put(pageId, inspectorConnection);
        }
        catch (Exception e) {
            FLog.w((String)TAG, (String)("Failed to open page: " + pageId), (Throwable)e);
            this.sendEvent("disconnect", this.makePageIdPayload(pageId));
        }
    }

    private void handleDisconnect(JSONObject payload) throws JSONException {
        String pageId = payload.getString("pageId");
        Inspector.LocalConnection inspectorConnection = this.mInspectorConnections.remove(pageId);
        if (inspectorConnection == null) {
            return;
        }
        inspectorConnection.disconnect();
    }

    private void handleWrappedEvent(JSONObject payload) throws JSONException {
        String pageId = payload.getString("pageId");
        String wrappedEvent = payload.getString("wrappedEvent");
        Inspector.LocalConnection inspectorConnection = this.mInspectorConnections.get(pageId);
        if (inspectorConnection == null) {
            throw new IllegalStateException("Not connected: " + pageId);
        }
        inspectorConnection.sendMessage(wrappedEvent);
    }

    private JSONArray getPages() throws JSONException {
        List<Inspector.Page> pages = Inspector.getPages();
        JSONArray array = new JSONArray();
        BundleStatus bundleStatus = this.mBundleStatusProvider.getBundleStatus();
        for (Inspector.Page page : pages) {
            JSONObject jsonPage = new JSONObject();
            jsonPage.put("id", (Object)String.valueOf(page.getId()));
            jsonPage.put("title", (Object)page.getTitle());
            jsonPage.put("app", (Object)this.mPackageName);
            jsonPage.put("vm", (Object)page.getVM());
            jsonPage.put("isLastBundleDownloadSuccess", (Object)bundleStatus.isLastDownloadSucess);
            jsonPage.put("bundleUpdateTimestamp", bundleStatus.updateTimestamp);
            array.put((Object)jsonPage);
        }
        return array;
    }

    private void sendWrappedEvent(String pageId, String message) throws JSONException {
        JSONObject payload = new JSONObject();
        payload.put("pageId", (Object)pageId);
        payload.put("wrappedEvent", (Object)message);
        this.sendEvent("wrappedEvent", payload);
    }

    private void sendEvent(String name, Object payload) throws JSONException {
        JSONObject jsonMessage = new JSONObject();
        jsonMessage.put("event", (Object)name);
        jsonMessage.put("payload", payload);
        this.mConnection.send(jsonMessage);
    }

    private JSONObject makePageIdPayload(String pageId) throws JSONException {
        JSONObject payload = new JSONObject();
        payload.put("pageId", (Object)pageId);
        return payload;
    }

    public static interface BundleStatusProvider {
        public BundleStatus getBundleStatus();
    }

    public static class BundleStatus {
        public Boolean isLastDownloadSucess;
        public long updateTimestamp = -1L;

        public BundleStatus(Boolean isLastDownloadSucess, long updateTimestamp) {
            this.isLastDownloadSucess = isLastDownloadSucess;
            this.updateTimestamp = updateTimestamp;
        }

        public BundleStatus() {
            this(false, -1L);
        }
    }

    private class Connection
    extends WebSocketListener {
        private static final int RECONNECT_DELAY_MS = 2000;
        private final String mUrl;
        private OkHttpClient mHttpClient;
        @Nullable
        private WebSocket mWebSocket;
        private final Handler mHandler;
        private boolean mClosed;
        private boolean mSuppressConnectionErrors;

        public Connection(String url) {
            this.mUrl = url;
            this.mHandler = new Handler(Looper.getMainLooper());
        }

        public void onOpen(WebSocket webSocket, Response response) {
            this.mWebSocket = webSocket;
        }

        public void onFailure(WebSocket webSocket, Throwable t, Response response) {
            if (this.mWebSocket != null) {
                this.abort("Websocket exception", t);
            }
            if (!this.mClosed) {
                this.reconnect();
            }
        }

        public void onMessage(WebSocket webSocket, String text) {
            try {
                InspectorPackagerConnection.this.handleProxyMessage(new JSONObject(text));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void onClosed(WebSocket webSocket, int code, String reason) {
            this.mWebSocket = null;
            InspectorPackagerConnection.this.closeAllConnections();
            if (!this.mClosed) {
                this.reconnect();
            }
        }

        public void connect() {
            if (this.mClosed) {
                throw new IllegalStateException("Can't connect closed client");
            }
            if (this.mHttpClient == null) {
                this.mHttpClient = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.MINUTES).build();
            }
            Request request = new Request.Builder().url(this.mUrl).build();
            this.mHttpClient.newWebSocket(request, (WebSocketListener)this);
        }

        private void reconnect() {
            if (this.mClosed) {
                throw new IllegalStateException("Can't reconnect closed client");
            }
            if (!this.mSuppressConnectionErrors) {
                FLog.w((String)InspectorPackagerConnection.TAG, (String)"Couldn't connect to packager, will silently retry");
                this.mSuppressConnectionErrors = true;
            }
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (!Connection.this.mClosed) {
                        Connection.this.connect();
                    }
                }
            }, 2000L);
        }

        public void close() {
            this.mClosed = true;
            if (this.mWebSocket != null) {
                try {
                    this.mWebSocket.close(1000, "End of session");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mWebSocket = null;
            }
        }

        public void send(final JSONObject object) {
            new AsyncTask<WebSocket, Void, Void>(){

                protected Void doInBackground(WebSocket ... sockets) {
                    if (sockets == null || sockets.length == 0) {
                        return null;
                    }
                    try {
                        sockets[0].send(object.toString());
                    }
                    catch (Exception e) {
                        FLog.w((String)InspectorPackagerConnection.TAG, (String)"Couldn't send event to packager", (Throwable)e);
                    }
                    return null;
                }
            }.execute((Object[])new WebSocket[]{this.mWebSocket});
        }

        private void abort(String message, Throwable cause) {
            FLog.e((String)InspectorPackagerConnection.TAG, (String)("Error occurred, shutting down websocket connection: " + message), (Throwable)cause);
            InspectorPackagerConnection.this.closeAllConnections();
            this.closeWebSocketQuietly();
        }

        private void closeWebSocketQuietly() {
            if (this.mWebSocket != null) {
                try {
                    this.mWebSocket.close(1000, "End of session");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mWebSocket = null;
            }
        }
    }
}

