/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.devsupport.FpsView;
import com.facebook.react.devsupport.WindowOverlayCompat;
import javax.annotation.Nullable;

class DebugOverlayController {
    private final WindowManager mWindowManager;
    private final ReactContext mReactContext;
    @Nullable
    private FrameLayout mFPSDebugViewContainer;

    public static void requestPermission(Context context) {
        if (Build.VERSION.SDK_INT >= 23 && !Settings.canDrawOverlays((Context)context)) {
            Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", Uri.parse((String)("package:" + context.getPackageName())));
            intent.setFlags(0x10000000);
            FLog.w((String)"ReactNative", (String)"Overlay permissions needs to be granted in order for react native apps to run in dev mode");
            if (DebugOverlayController.canHandleIntent(context, intent)) {
                context.startActivity(intent);
            }
        }
    }

    private static boolean permissionCheck(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            return Settings.canDrawOverlays((Context)context);
        }
        return DebugOverlayController.hasPermission(context, "android.permission.SYSTEM_ALERT_WINDOW");
    }

    private static boolean hasPermission(Context context, String permission2) {
        try {
            PackageInfo info = context.getPackageManager().getPackageInfo(context.getPackageName(), 4096);
            if (info.requestedPermissions != null) {
                for (String p : info.requestedPermissions) {
                    if (!p.equals(permission2)) continue;
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            FLog.e((String)"ReactNative", (String)"Error while retrieving package info", (Throwable)e);
        }
        return false;
    }

    private static boolean canHandleIntent(Context context, Intent intent) {
        PackageManager packageManager = context.getPackageManager();
        return intent.resolveActivity(packageManager) != null;
    }

    public DebugOverlayController(ReactContext reactContext) {
        this.mReactContext = reactContext;
        this.mWindowManager = (WindowManager)reactContext.getSystemService("window");
    }

    public void setFpsDebugViewVisible(final boolean fpsDebugViewVisible) {
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (fpsDebugViewVisible && DebugOverlayController.this.mFPSDebugViewContainer == null) {
                    if (!DebugOverlayController.permissionCheck((Context)DebugOverlayController.this.mReactContext)) {
                        FLog.d((String)"ReactNative", (String)"Wait for overlay permission to be set");
                        return;
                    }
                    DebugOverlayController.this.mFPSDebugViewContainer = new FpsView(DebugOverlayController.this.mReactContext);
                    WindowManager.LayoutParams params = new WindowManager.LayoutParams(-1, -1, WindowOverlayCompat.TYPE_SYSTEM_OVERLAY, 24, -3);
                    DebugOverlayController.this.mWindowManager.addView((View)DebugOverlayController.this.mFPSDebugViewContainer, (ViewGroup.LayoutParams)params);
                } else if (!fpsDebugViewVisible && DebugOverlayController.this.mFPSDebugViewContainer != null) {
                    DebugOverlayController.this.mFPSDebugViewContainer.removeAllViews();
                    DebugOverlayController.this.mWindowManager.removeView((View)DebugOverlayController.this.mFPSDebugViewContainer);
                    DebugOverlayController.this.mFPSDebugViewContainer = null;
                }
            }
        });
    }
}

