/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.DynamicFromMap;
import com.facebook.react.bridge.JavaOnlyArray;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JavaOnlyMap
implements ReadableMap,
WritableMap {
    private final Map mBackingMap;

    public static JavaOnlyMap of(Object ... keysAndValues) {
        return new JavaOnlyMap(keysAndValues);
    }

    public static JavaOnlyMap deepClone(ReadableMap map) {
        JavaOnlyMap res = new JavaOnlyMap();
        ReadableMapKeySetIterator iter = map.keySetIterator();
        while (iter.hasNextKey()) {
            String propKey = iter.nextKey();
            ReadableType type = map.getType(propKey);
            switch (type) {
                case Null: {
                    res.putNull(propKey);
                    break;
                }
                case Boolean: {
                    res.putBoolean(propKey, map.getBoolean(propKey));
                    break;
                }
                case Number: {
                    res.putDouble(propKey, map.getDouble(propKey));
                    break;
                }
                case String: {
                    res.putString(propKey, map.getString(propKey));
                    break;
                }
                case Map: {
                    res.putMap(propKey, JavaOnlyMap.deepClone(map.getMap(propKey)));
                    break;
                }
                case Array: {
                    res.putArray(propKey, JavaOnlyArray.deepClone(map.getArray(propKey)));
                }
            }
        }
        return res;
    }

    private JavaOnlyMap(Object ... keysAndValues) {
        if (keysAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("You must provide the same number of keys and values");
        }
        this.mBackingMap = new HashMap();
        for (int i = 0; i < keysAndValues.length; i += 2) {
            this.mBackingMap.put(keysAndValues[i], keysAndValues[i + 1]);
        }
    }

    public JavaOnlyMap() {
        this.mBackingMap = new HashMap();
    }

    @Override
    public boolean hasKey(@Nonnull String name) {
        return this.mBackingMap.containsKey(name);
    }

    @Override
    public boolean isNull(@Nonnull String name) {
        return this.mBackingMap.get(name) == null;
    }

    @Override
    public boolean getBoolean(@Nonnull String name) {
        return (Boolean)this.mBackingMap.get(name);
    }

    @Override
    public double getDouble(@Nonnull String name) {
        return ((Number)this.mBackingMap.get(name)).doubleValue();
    }

    @Override
    public int getInt(@Nonnull String name) {
        return ((Number)this.mBackingMap.get(name)).intValue();
    }

    @Override
    public String getString(@Nonnull String name) {
        return (String)this.mBackingMap.get(name);
    }

    @Override
    public ReadableMap getMap(@Nonnull String name) {
        return (ReadableMap)this.mBackingMap.get(name);
    }

    @Override
    public JavaOnlyArray getArray(@Nonnull String name) {
        return (JavaOnlyArray)this.mBackingMap.get(name);
    }

    @Override
    @Nonnull
    public Dynamic getDynamic(@Nonnull String name) {
        return DynamicFromMap.create(this, name);
    }

    @Override
    @Nonnull
    public ReadableType getType(@Nonnull String name) {
        Object value = this.mBackingMap.get(name);
        if (value == null) {
            return ReadableType.Null;
        }
        if (value instanceof Number) {
            return ReadableType.Number;
        }
        if (value instanceof String) {
            return ReadableType.String;
        }
        if (value instanceof Boolean) {
            return ReadableType.Boolean;
        }
        if (value instanceof ReadableMap) {
            return ReadableType.Map;
        }
        if (value instanceof ReadableArray) {
            return ReadableType.Array;
        }
        if (value instanceof Dynamic) {
            return ((Dynamic)value).getType();
        }
        throw new IllegalArgumentException("Invalid value " + value.toString() + " for key " + name + "contained in JavaOnlyMap");
    }

    @Override
    @Nonnull
    public ReadableMapKeySetIterator keySetIterator() {
        return new ReadableMapKeySetIterator(){
            Iterator<String> mIterator;
            {
                this.mIterator = JavaOnlyMap.this.mBackingMap.keySet().iterator();
            }

            @Override
            public boolean hasNextKey() {
                return this.mIterator.hasNext();
            }

            @Override
            public String nextKey() {
                return this.mIterator.next();
            }
        };
    }

    @Override
    public void putBoolean(@Nonnull String key, boolean value) {
        this.mBackingMap.put(key, value);
    }

    @Override
    public void putDouble(@Nonnull String key, double value) {
        this.mBackingMap.put(key, value);
    }

    @Override
    public void putInt(@Nonnull String key, int value) {
        this.mBackingMap.put(key, value);
    }

    @Override
    public void putString(@Nonnull String key, @Nullable String value) {
        this.mBackingMap.put(key, value);
    }

    @Override
    public void putNull(@Nonnull String key) {
        this.mBackingMap.put(key, null);
    }

    @Override
    public void putMap(@Nonnull String key, @Nullable WritableMap value) {
        this.mBackingMap.put(key, value);
    }

    @Override
    public void merge(@Nonnull ReadableMap source) {
        this.mBackingMap.putAll(((JavaOnlyMap)source).mBackingMap);
    }

    @Override
    public void putArray(@Nonnull String key, @Nullable WritableArray value) {
        this.mBackingMap.put(key, value);
    }

    @Override
    @Nonnull
    public HashMap<String, Object> toHashMap() {
        return new HashMap<String, Object>(this.mBackingMap);
    }

    public String toString() {
        return this.mBackingMap.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaOnlyMap that = (JavaOnlyMap)o;
        return !(this.mBackingMap != null ? !this.mBackingMap.equals(that.mBackingMap) : that.mBackingMap != null);
    }

    public int hashCode() {
        return this.mBackingMap != null ? this.mBackingMap.hashCode() : 0;
    }
}

