/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.facebook.react.uimanager.DisplayMetricsHolder;

public class PixelUtil {
    public static float toPixelFromDIP(float value) {
        return TypedValue.applyDimension((int)1, (float)value, (DisplayMetrics)DisplayMetricsHolder.getWindowDisplayMetrics());
    }

    public static float toPixelFromDIP(double value) {
        return PixelUtil.toPixelFromDIP((float)value);
    }

    public static float toSPFromPixel(float value) {
        return value / DisplayMetricsHolder.getScreenDisplayMetrics().scaledDensity;
    }

    public static float toPixelFromSP(float value) {
        return PixelUtil.toPixelFromSP(value, Float.NaN);
    }

    public static float toPixelFromSP(float value, float maxFontScale) {
        DisplayMetrics displayMetrics = DisplayMetricsHolder.getWindowDisplayMetrics();
        float scaledDensity = displayMetrics.scaledDensity;
        float currentFontScale = scaledDensity / displayMetrics.density;
        if (maxFontScale >= 1.0f && maxFontScale < currentFontScale) {
            scaledDensity = displayMetrics.density * maxFontScale;
        }
        return value * scaledDensity;
    }

    public static float toPixelFromSP(double value) {
        return PixelUtil.toPixelFromSP((float)value);
    }

    public static float toDIPFromPixel(float value) {
        return value / DisplayMetricsHolder.getWindowDisplayMetrics().density;
    }

    public static float getDisplayMetricDensity() {
        return DisplayMetricsHolder.getScreenDisplayMetrics().density;
    }
}

