/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.yoga;

import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.soloader.SoLoader;
import com.facebook.yoga.YogaExperimentalFeature;
import com.facebook.yoga.YogaLogger;
import com.facebook.yoga.YogaNode;
import com.facebook.yoga.YogaNodeCloneFunction;

@DoNotStrip
public class YogaConfig {
    public static int SPACING_TYPE = 1;
    long mNativePointer = this.jni_YGConfigNew();
    private YogaLogger mLogger;
    private YogaNodeCloneFunction mYogaNodeCloneFunction;

    private native long jni_YGConfigNew();

    public YogaConfig() {
        if (this.mNativePointer == 0L) {
            throw new IllegalStateException("Failed to allocate native memory");
        }
    }

    private native void jni_YGConfigFree(long var1);

    protected void finalize() throws Throwable {
        try {
            this.jni_YGConfigFree(this.mNativePointer);
        }
        finally {
            super.finalize();
        }
    }

    private native void jni_YGConfigSetExperimentalFeatureEnabled(long var1, int var3, boolean var4);

    public void setExperimentalFeatureEnabled(YogaExperimentalFeature feature, boolean enabled) {
        this.jni_YGConfigSetExperimentalFeatureEnabled(this.mNativePointer, feature.intValue(), enabled);
    }

    private native void jni_YGConfigSetUseWebDefaults(long var1, boolean var3);

    public void setUseWebDefaults(boolean useWebDefaults) {
        this.jni_YGConfigSetUseWebDefaults(this.mNativePointer, useWebDefaults);
    }

    private native void jni_YGConfigSetPrintTreeFlag(long var1, boolean var3);

    public void setPrintTreeFlag(boolean enable) {
        this.jni_YGConfigSetPrintTreeFlag(this.mNativePointer, enable);
    }

    private native void jni_YGConfigSetPointScaleFactor(long var1, float var3);

    public void setPointScaleFactor(float pixelsInPoint) {
        this.jni_YGConfigSetPointScaleFactor(this.mNativePointer, pixelsInPoint);
    }

    private native void jni_YGConfigSetUseLegacyStretchBehaviour(long var1, boolean var3);

    public void setUseLegacyStretchBehaviour(boolean useLegacyStretchBehaviour) {
        this.jni_YGConfigSetUseLegacyStretchBehaviour(this.mNativePointer, useLegacyStretchBehaviour);
    }

    private native void jni_YGConfigSetShouldDiffLayoutWithoutLegacyStretchBehaviour(long var1, boolean var3);

    public void setShouldDiffLayoutWithoutLegacyStretchBehaviour(boolean shouldDiffLayoutWithoutLegacyStretchBehaviour) {
        this.jni_YGConfigSetShouldDiffLayoutWithoutLegacyStretchBehaviour(this.mNativePointer, shouldDiffLayoutWithoutLegacyStretchBehaviour);
    }

    private native void jni_YGConfigSetLogger(long var1, Object var3);

    public void setLogger(YogaLogger logger) {
        this.mLogger = logger;
        this.jni_YGConfigSetLogger(this.mNativePointer, logger);
    }

    public YogaLogger getLogger() {
        return this.mLogger;
    }

    private native void jni_YGConfigSetHasCloneNodeFunc(long var1, boolean var3);

    public void setOnCloneNode(YogaNodeCloneFunction cloneYogaNodeFunction) {
        this.mYogaNodeCloneFunction = cloneYogaNodeFunction;
        this.jni_YGConfigSetHasCloneNodeFunc(this.mNativePointer, cloneYogaNodeFunction != null);
    }

    @DoNotStrip
    private final YogaNode cloneNode(YogaNode oldNode, YogaNode parent, int childIndex) {
        return this.mYogaNodeCloneFunction.cloneNode(oldNode, parent, childIndex);
    }

    static {
        SoLoader.loadLibrary((String)"yoga");
    }
}

