/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.toolbar;

import android.content.Context;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.drawee.backends.pipeline.PipelineDraweeControllerBuilder;
import com.facebook.drawee.controller.AbstractDraweeController;
import com.facebook.drawee.controller.BaseControllerListener;
import com.facebook.drawee.controller.ControllerListener;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.generic.GenericDraweeHierarchyBuilder;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.drawee.interfaces.DraweeHierarchy;
import com.facebook.drawee.view.DraweeHolder;
import com.facebook.drawee.view.MultiDraweeHolder;
import com.facebook.imagepipeline.image.ImageInfo;
import com.facebook.imagepipeline.image.QualityInfo;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.views.toolbar.DrawableWithIntrinsicSize;
import javax.annotation.Nullable;

public class ReactToolbar
extends Toolbar {
    private static final String PROP_ACTION_ICON = "icon";
    private static final String PROP_ACTION_SHOW = "show";
    private static final String PROP_ACTION_SHOW_WITH_TEXT = "showWithText";
    private static final String PROP_ACTION_TITLE = "title";
    private static final String PROP_ICON_URI = "uri";
    private static final String PROP_ICON_WIDTH = "width";
    private static final String PROP_ICON_HEIGHT = "height";
    private final DraweeHolder mLogoHolder;
    private final DraweeHolder mNavIconHolder;
    private final DraweeHolder mOverflowIconHolder;
    private final MultiDraweeHolder<GenericDraweeHierarchy> mActionsHolder = new MultiDraweeHolder();
    private IconControllerListener mLogoControllerListener;
    private IconControllerListener mNavIconControllerListener;
    private IconControllerListener mOverflowIconControllerListener;
    private final Runnable mLayoutRunnable = new Runnable(){

        @Override
        public void run() {
            ReactToolbar.this.measure(View.MeasureSpec.makeMeasureSpec((int)ReactToolbar.this.getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)ReactToolbar.this.getHeight(), (int)0x40000000));
            ReactToolbar.this.layout(ReactToolbar.this.getLeft(), ReactToolbar.this.getTop(), ReactToolbar.this.getRight(), ReactToolbar.this.getBottom());
        }
    };

    public ReactToolbar(Context context) {
        super(context);
        this.mLogoHolder = DraweeHolder.create((DraweeHierarchy)this.createDraweeHierarchy(), (Context)context);
        this.mNavIconHolder = DraweeHolder.create((DraweeHierarchy)this.createDraweeHierarchy(), (Context)context);
        this.mOverflowIconHolder = DraweeHolder.create((DraweeHierarchy)this.createDraweeHierarchy(), (Context)context);
        this.mLogoControllerListener = new IconControllerListener(this.mLogoHolder){

            @Override
            protected void setDrawable(Drawable d) {
                ReactToolbar.this.setLogo(d);
            }
        };
        this.mNavIconControllerListener = new IconControllerListener(this.mNavIconHolder){

            @Override
            protected void setDrawable(Drawable d) {
                ReactToolbar.this.setNavigationIcon(d);
            }
        };
        this.mOverflowIconControllerListener = new IconControllerListener(this.mOverflowIconHolder){

            @Override
            protected void setDrawable(Drawable d) {
                ReactToolbar.this.setOverflowIcon(d);
            }
        };
    }

    public void requestLayout() {
        super.requestLayout();
        this.post(this.mLayoutRunnable);
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.detachDraweeHolders();
    }

    public void onStartTemporaryDetach() {
        super.onStartTemporaryDetach();
        this.detachDraweeHolders();
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.attachDraweeHolders();
    }

    public void onFinishTemporaryDetach() {
        super.onFinishTemporaryDetach();
        this.attachDraweeHolders();
    }

    private void detachDraweeHolders() {
        this.mLogoHolder.onDetach();
        this.mNavIconHolder.onDetach();
        this.mOverflowIconHolder.onDetach();
        this.mActionsHolder.onDetach();
    }

    private void attachDraweeHolders() {
        this.mLogoHolder.onAttach();
        this.mNavIconHolder.onAttach();
        this.mOverflowIconHolder.onAttach();
        this.mActionsHolder.onAttach();
    }

    void setLogoSource(@Nullable ReadableMap source) {
        this.setIconSource(source, this.mLogoControllerListener, this.mLogoHolder);
    }

    void setNavIconSource(@Nullable ReadableMap source) {
        this.setIconSource(source, this.mNavIconControllerListener, this.mNavIconHolder);
    }

    void setOverflowIconSource(@Nullable ReadableMap source) {
        this.setIconSource(source, this.mOverflowIconControllerListener, this.mOverflowIconHolder);
    }

    void setActions(@Nullable ReadableArray actions) {
        Menu menu = this.getMenu();
        menu.clear();
        this.mActionsHolder.clear();
        if (actions != null) {
            for (int i = 0; i < actions.size(); ++i) {
                int showAsAction;
                ReadableMap action = actions.getMap(i);
                MenuItem item = menu.add(0, 0, i, (CharSequence)action.getString(PROP_ACTION_TITLE));
                if (action.hasKey(PROP_ACTION_ICON)) {
                    this.setMenuItemIcon(item, action.getMap(PROP_ACTION_ICON));
                }
                int n = showAsAction = action.hasKey(PROP_ACTION_SHOW) ? action.getInt(PROP_ACTION_SHOW) : 0;
                if (action.hasKey(PROP_ACTION_SHOW_WITH_TEXT) && action.getBoolean(PROP_ACTION_SHOW_WITH_TEXT)) {
                    showAsAction |= 4;
                }
                item.setShowAsAction(showAsAction);
            }
        }
    }

    private void setMenuItemIcon(MenuItem item, ReadableMap iconSource) {
        DraweeHolder holder = DraweeHolder.create((DraweeHierarchy)this.createDraweeHierarchy(), (Context)this.getContext());
        ActionIconControllerListener controllerListener = new ActionIconControllerListener(item, holder);
        controllerListener.setIconImageInfo(this.getIconImageInfo(iconSource));
        this.setIconSource(iconSource, controllerListener, holder);
        this.mActionsHolder.add(holder);
    }

    private void setIconSource(ReadableMap source, IconControllerListener controllerListener, DraweeHolder holder) {
        String uri;
        String string2 = uri = source != null ? source.getString(PROP_ICON_URI) : null;
        if (uri == null) {
            controllerListener.setIconImageInfo(null);
            controllerListener.setDrawable(null);
        } else if (uri.startsWith("http://") || uri.startsWith("https://") || uri.startsWith("file://")) {
            controllerListener.setIconImageInfo(this.getIconImageInfo(source));
            AbstractDraweeController controller = ((PipelineDraweeControllerBuilder)((PipelineDraweeControllerBuilder)Fresco.newDraweeControllerBuilder().setUri(Uri.parse((String)uri)).setControllerListener((ControllerListener)controllerListener)).setOldController(holder.getController())).build();
            holder.setController((DraweeController)controller);
            holder.getTopLevelDrawable().setVisible(true, true);
        } else {
            controllerListener.setDrawable(this.getDrawableByName(uri));
        }
    }

    private GenericDraweeHierarchy createDraweeHierarchy() {
        return new GenericDraweeHierarchyBuilder(this.getResources()).setActualImageScaleType(ScalingUtils.ScaleType.FIT_CENTER).setFadeDuration(0).build();
    }

    private int getDrawableResourceByName(String name) {
        return this.getResources().getIdentifier(name, "drawable", this.getContext().getPackageName());
    }

    private Drawable getDrawableByName(String name) {
        int drawableResId = this.getDrawableResourceByName(name);
        if (drawableResId != 0) {
            return this.getResources().getDrawable(this.getDrawableResourceByName(name));
        }
        return null;
    }

    private IconImageInfo getIconImageInfo(ReadableMap source) {
        if (source.hasKey(PROP_ICON_WIDTH) && source.hasKey(PROP_ICON_HEIGHT)) {
            int width = Math.round(PixelUtil.toPixelFromDIP(source.getInt(PROP_ICON_WIDTH)));
            int height = Math.round(PixelUtil.toPixelFromDIP(source.getInt(PROP_ICON_HEIGHT)));
            return new IconImageInfo(width, height);
        }
        return null;
    }

    private static class IconImageInfo
    implements ImageInfo {
        private int mWidth;
        private int mHeight;

        public IconImageInfo(int width, int height) {
            this.mWidth = width;
            this.mHeight = height;
        }

        public int getWidth() {
            return this.mWidth;
        }

        public int getHeight() {
            return this.mHeight;
        }

        public QualityInfo getQualityInfo() {
            return null;
        }
    }

    private class ActionIconControllerListener
    extends IconControllerListener {
        private final MenuItem mItem;

        ActionIconControllerListener(MenuItem item, DraweeHolder holder) {
            super(holder);
            this.mItem = item;
        }

        @Override
        protected void setDrawable(Drawable d) {
            this.mItem.setIcon(d);
            ReactToolbar.this.requestLayout();
        }
    }

    private abstract class IconControllerListener
    extends BaseControllerListener<ImageInfo> {
        private final DraweeHolder mHolder;
        private IconImageInfo mIconImageInfo;

        public IconControllerListener(DraweeHolder holder) {
            this.mHolder = holder;
        }

        public void setIconImageInfo(IconImageInfo iconImageInfo) {
            this.mIconImageInfo = iconImageInfo;
        }

        public void onFinalImageSet(String id2, @Nullable ImageInfo imageInfo, @Nullable Animatable animatable) {
            super.onFinalImageSet(id2, (Object)imageInfo, animatable);
            ImageInfo info = this.mIconImageInfo != null ? this.mIconImageInfo : imageInfo;
            this.setDrawable((Drawable)new DrawableWithIntrinsicSize(this.mHolder.getTopLevelDrawable(), info));
        }

        protected abstract void setDrawable(Drawable var1);
    }
}

