/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Layout;
import android.text.TextPaint;
import android.util.DisplayMetrics;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;

public class FontMetricsUtil {
    private static final String CAP_HEIGHT_MEASUREMENT_TEXT = "T";
    private static final String X_HEIGHT_MEASUREMENT_TEXT = "x";
    private static final float AMPLIFICATION_FACTOR = 100.0f;

    public static WritableArray getFontMetrics(CharSequence text, Layout layout2, TextPaint paint, Context context) {
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        WritableArray lines = Arguments.createArray();
        TextPaint paintCopy = new TextPaint((Paint)paint);
        paintCopy.setTextSize(paintCopy.getTextSize() * 100.0f);
        Rect capHeightBounds = new Rect();
        paintCopy.getTextBounds(CAP_HEIGHT_MEASUREMENT_TEXT, 0, CAP_HEIGHT_MEASUREMENT_TEXT.length(), capHeightBounds);
        double capHeight = (float)capHeightBounds.height() / 100.0f / dm.density;
        Rect xHeightBounds = new Rect();
        paintCopy.getTextBounds(X_HEIGHT_MEASUREMENT_TEXT, 0, X_HEIGHT_MEASUREMENT_TEXT.length(), xHeightBounds);
        double xHeight = (float)xHeightBounds.height() / 100.0f / dm.density;
        for (int i = 0; i < layout2.getLineCount(); ++i) {
            Rect bounds = new Rect();
            layout2.getLineBounds(i, bounds);
            WritableMap line = Arguments.createMap();
            line.putDouble(X_HEIGHT_MEASUREMENT_TEXT, layout2.getLineLeft(i) / dm.density);
            line.putDouble("y", (float)bounds.top / dm.density);
            line.putDouble("width", layout2.getLineWidth(i) / dm.density);
            line.putDouble("height", (float)bounds.height() / dm.density);
            line.putDouble("descender", (float)layout2.getLineDescent(i) / dm.density);
            line.putDouble("ascender", (float)(-layout2.getLineAscent(i)) / dm.density);
            line.putDouble("baseline", (float)layout2.getLineBaseline(i) / dm.density);
            line.putDouble("capHeight", capHeight);
            line.putDouble("xHeight", xHeight);
            line.putString("text", text.subSequence(layout2.getLineStart(i), layout2.getLineEnd(i)).toString());
            lines.pushMap(line);
        }
        return lines;
    }
}

