/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.switchview;

import android.content.Context;
import android.view.View;
import android.widget.CompoundButton;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.SimpleViewManager;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.switchview.ReactSwitch;
import com.facebook.react.views.switchview.ReactSwitchEvent;
import com.facebook.yoga.YogaMeasureFunction;
import com.facebook.yoga.YogaMeasureMode;
import com.facebook.yoga.YogaMeasureOutput;
import com.facebook.yoga.YogaNode;
import javax.annotation.Nullable;

public class ReactSwitchManager
extends SimpleViewManager<ReactSwitch> {
    public static final String REACT_CLASS = "AndroidSwitch";
    private static final CompoundButton.OnCheckedChangeListener ON_CHECKED_CHANGE_LISTENER = new CompoundButton.OnCheckedChangeListener(){

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            ReactContext reactContext = (ReactContext)buttonView.getContext();
            reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher().dispatchEvent(new ReactSwitchEvent(buttonView.getId(), isChecked));
        }
    };

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    public LayoutShadowNode createShadowNodeInstance() {
        return new ReactSwitchShadowNode();
    }

    @Override
    public Class getShadowNodeClass() {
        return ReactSwitchShadowNode.class;
    }

    @Override
    protected ReactSwitch createViewInstance(ThemedReactContext context) {
        ReactSwitch view = new ReactSwitch((Context)context);
        view.setShowText(false);
        return view;
    }

    @ReactProp(name="disabled", defaultBoolean=false)
    public void setDisabled(ReactSwitch view, boolean disabled) {
        view.setEnabled(!disabled);
    }

    @ReactProp(name="enabled", defaultBoolean=true)
    public void setEnabled(ReactSwitch view, boolean enabled) {
        view.setEnabled(enabled);
    }

    @ReactProp(name="on")
    public void setOn(ReactSwitch view, boolean on) {
        this.setValue(view, on);
    }

    @ReactProp(name="value")
    public void setValue(ReactSwitch view, boolean value) {
        view.setOnCheckedChangeListener(null);
        view.setOn(value);
        view.setOnCheckedChangeListener(ON_CHECKED_CHANGE_LISTENER);
    }

    @ReactProp(name="thumbTintColor", customType="Color")
    public void setThumbTintColor(ReactSwitch view, @Nullable Integer color) {
        this.setThumbColor(view, color);
    }

    @ReactProp(name="thumbColor", customType="Color")
    public void setThumbColor(ReactSwitch view, @Nullable Integer color) {
        view.setThumbColor(color);
    }

    @ReactProp(name="trackColorForFalse", customType="Color")
    public void setTrackColorForFalse(ReactSwitch view, @Nullable Integer color) {
        view.setTrackColorForFalse(color);
    }

    @ReactProp(name="trackColorForTrue", customType="Color")
    public void setTrackColorForTrue(ReactSwitch view, @Nullable Integer color) {
        view.setTrackColorForTrue(color);
    }

    @ReactProp(name="trackTintColor", customType="Color")
    public void setTrackTintColor(ReactSwitch view, @Nullable Integer color) {
        view.setTrackColor(color);
    }

    @Override
    protected void addEventEmitters(ThemedReactContext reactContext, ReactSwitch view) {
        view.setOnCheckedChangeListener(ON_CHECKED_CHANGE_LISTENER);
    }

    static class ReactSwitchShadowNode
    extends LayoutShadowNode
    implements YogaMeasureFunction {
        private int mWidth;
        private int mHeight;
        private boolean mMeasured;

        private ReactSwitchShadowNode() {
            this.initMeasureFunction();
        }

        private void initMeasureFunction() {
            this.setMeasureFunction(this);
        }

        @Override
        public long measure(YogaNode node, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode) {
            if (!this.mMeasured) {
                ReactSwitch reactSwitch = new ReactSwitch((Context)this.getThemedContext());
                reactSwitch.setShowText(false);
                int spec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                reactSwitch.measure(spec, spec);
                this.mWidth = reactSwitch.getMeasuredWidth();
                this.mHeight = reactSwitch.getMeasuredHeight();
                this.mMeasured = true;
            }
            return YogaMeasureOutput.make(this.mWidth, this.mHeight);
        }
    }
}

