/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.viewpager;

import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.uimanager.events.NativeGestureUtil;
import com.facebook.react.views.viewpager.PageScrollEvent;
import com.facebook.react.views.viewpager.PageScrollStateChangedEvent;
import com.facebook.react.views.viewpager.PageSelectedEvent;
import java.util.ArrayList;
import java.util.List;

public class ReactViewPager
extends ViewPager {
    private final EventDispatcher mEventDispatcher;
    private boolean mIsCurrentItemFromJs;
    private boolean mScrollEnabled = true;
    private final Runnable measureAndLayout = new Runnable(){

        @Override
        public void run() {
            ReactViewPager.this.measure(View.MeasureSpec.makeMeasureSpec((int)ReactViewPager.this.getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)ReactViewPager.this.getHeight(), (int)0x40000000));
            ReactViewPager.this.layout(ReactViewPager.this.getLeft(), ReactViewPager.this.getTop(), ReactViewPager.this.getRight(), ReactViewPager.this.getBottom());
        }
    };

    public ReactViewPager(ReactContext reactContext) {
        super((Context)reactContext);
        this.mEventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
        this.mIsCurrentItemFromJs = false;
        this.setOnPageChangeListener(new PageChangeListener());
        this.setAdapter(new Adapter());
    }

    public Adapter getAdapter() {
        return (Adapter)super.getAdapter();
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.mScrollEnabled) {
            return false;
        }
        try {
            if (super.onInterceptTouchEvent(ev)) {
                NativeGestureUtil.notifyNativeGestureStarted((View)this, ev);
                return true;
            }
        }
        catch (IllegalArgumentException e) {
            FLog.w((String)"ReactNative", (String)"Error intercepting touch event.", (Throwable)e);
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.mScrollEnabled) {
            return false;
        }
        try {
            return super.onTouchEvent(ev);
        }
        catch (IllegalArgumentException e) {
            FLog.w((String)"ReactNative", (String)"Error handling touch event.", (Throwable)e);
            return false;
        }
    }

    public void setCurrentItemFromJs(int item, boolean animated) {
        this.mIsCurrentItemFromJs = true;
        this.setCurrentItem(item, animated);
        this.mIsCurrentItemFromJs = false;
    }

    public void setScrollEnabled(boolean scrollEnabled) {
        this.mScrollEnabled = scrollEnabled;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.requestLayout();
        this.post(this.measureAndLayout);
    }

    void addViewToAdapter(View child, int index) {
        this.getAdapter().addView(child, index);
    }

    void removeViewFromAdapter(int index) {
        this.getAdapter().removeViewAt(index);
    }

    int getViewCountInAdapter() {
        return this.getAdapter().getCount();
    }

    View getViewFromAdapter(int index) {
        return this.getAdapter().getViewAt(index);
    }

    public void setViews(List<View> views) {
        this.getAdapter().setViews(views);
    }

    public void removeAllViewsFromAdapter() {
        this.getAdapter().removeAllViewsFromAdapter(this);
    }

    private class PageChangeListener
    implements ViewPager.OnPageChangeListener {
        private PageChangeListener() {
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            ReactViewPager.this.mEventDispatcher.dispatchEvent(new PageScrollEvent(ReactViewPager.this.getId(), position, positionOffset));
        }

        public void onPageSelected(int position) {
            if (!ReactViewPager.this.mIsCurrentItemFromJs) {
                ReactViewPager.this.mEventDispatcher.dispatchEvent(new PageSelectedEvent(ReactViewPager.this.getId(), position));
            }
        }

        public void onPageScrollStateChanged(int state) {
            String pageScrollState;
            switch (state) {
                case 0: {
                    pageScrollState = "idle";
                    break;
                }
                case 1: {
                    pageScrollState = "dragging";
                    break;
                }
                case 2: {
                    pageScrollState = "settling";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported pageScrollState");
                }
            }
            ReactViewPager.this.mEventDispatcher.dispatchEvent(new PageScrollStateChangedEvent(ReactViewPager.this.getId(), pageScrollState));
        }
    }

    private class Adapter
    extends PagerAdapter {
        private final List<View> mViews = new ArrayList<View>();
        private boolean mIsViewPagerInIntentionallyInconsistentState = false;

        private Adapter() {
        }

        void addView(View child, int index) {
            this.mViews.add(index, child);
            this.notifyDataSetChanged();
            ReactViewPager.this.setOffscreenPageLimit(this.mViews.size());
        }

        void removeViewAt(int index) {
            this.mViews.remove(index);
            this.notifyDataSetChanged();
            ReactViewPager.this.setOffscreenPageLimit(this.mViews.size());
        }

        void setViews(List<View> views) {
            this.mViews.clear();
            this.mViews.addAll(views);
            this.notifyDataSetChanged();
            this.mIsViewPagerInIntentionallyInconsistentState = false;
        }

        void removeAllViewsFromAdapter(ViewPager pager) {
            this.mViews.clear();
            pager.removeAllViews();
            this.mIsViewPagerInIntentionallyInconsistentState = true;
        }

        View getViewAt(int index) {
            return this.mViews.get(index);
        }

        public int getCount() {
            return this.mViews.size();
        }

        public int getItemPosition(Object object) {
            return this.mIsViewPagerInIntentionallyInconsistentState || !this.mViews.contains(object) ? -2 : this.mViews.indexOf(object);
        }

        public Object instantiateItem(ViewGroup container, int position) {
            View view = this.mViews.get(position);
            container.addView(view, 0, ReactViewPager.this.generateDefaultLayoutParams());
            return view;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            container.removeView((View)object);
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == object;
        }
    }
}

