/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.util.Pair;
import android.view.View;
import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.devsupport.JSCHeapCapture;
import com.facebook.react.devsupport.ViewHierarchyUtil;
import com.facebook.react.module.annotations.ReactModule;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

@ReactModule(name="JSDevSupport")
public class JSDevSupport
extends ReactContextBaseJavaModule {
    public static final String MODULE_NAME = "JSDevSupport";
    public static final int ERROR_CODE_EXCEPTION = 0;
    public static final int ERROR_CODE_VIEW_NOT_FOUND = 1;
    @Nullable
    private volatile DevSupportCallback mCurrentCallback = null;

    public JSDevSupport(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    public synchronized void computeDeepestJSHierarchy(View root, DevSupportCallback callback) {
        Pair<View, Integer> deepestPairView = ViewHierarchyUtil.getDeepestLeaf(root);
        View deepestView = (View)deepestPairView.first;
        Integer tagId = deepestView.getId();
        this.getJSHierarchy(tagId, callback);
    }

    public synchronized void getJSHierarchy(int reactTag, DevSupportCallback callback) {
        JSDevSupportModule jsDevSupportModule = this.getReactApplicationContext().getJSModule(JSDevSupportModule.class);
        if (jsDevSupportModule == null) {
            callback.onFailure(0, new JSCHeapCapture.CaptureException("JSDevSupport module not registered."));
            return;
        }
        this.mCurrentCallback = callback;
        jsDevSupportModule.getJSHierarchy(reactTag);
    }

    @ReactMethod
    public synchronized void onSuccess(String data) {
        if (this.mCurrentCallback != null) {
            this.mCurrentCallback.onSuccess(data);
        }
    }

    @ReactMethod
    public synchronized void onFailure(int errorCode, String error) {
        if (this.mCurrentCallback != null) {
            this.mCurrentCallback.onFailure(errorCode, new RuntimeException(error));
        }
    }

    @Override
    public Map<String, Object> getConstants() {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        constants.put("ERROR_CODE_EXCEPTION", 0);
        constants.put("ERROR_CODE_VIEW_NOT_FOUND", 1);
        return constants;
    }

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    public static interface DevSupportCallback {
        public void onSuccess(String var1);

        public void onFailure(int var1, Exception var2);
    }

    public static interface JSDevSupportModule
    extends JavaScriptModule {
        public void getJSHierarchy(int var1);
    }
}

