/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.v4.text.TextUtilsCompat;
import android.support.v4.view.ViewCompat;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import android.widget.OverScroller;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.uimanager.MeasureSpecAssertions;
import com.facebook.react.uimanager.ReactClippingViewGroup;
import com.facebook.react.uimanager.ReactClippingViewGroupHelper;
import com.facebook.react.uimanager.events.NativeGestureUtil;
import com.facebook.react.views.scroll.FpsListener;
import com.facebook.react.views.scroll.OnScrollDispatchHelper;
import com.facebook.react.views.scroll.ReactScrollViewHelper;
import com.facebook.react.views.scroll.VelocityHelper;
import com.facebook.react.views.view.ReactViewBackgroundManager;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;

public class ReactHorizontalScrollView
extends HorizontalScrollView
implements ReactClippingViewGroup {
    @Nullable
    private static Field sScrollerField;
    private static boolean sTriedToGetScrollerField;
    private final OnScrollDispatchHelper mOnScrollDispatchHelper = new OnScrollDispatchHelper();
    @Nullable
    private final OverScroller mScroller;
    private final VelocityHelper mVelocityHelper = new VelocityHelper();
    private final Rect mRect = new Rect();
    private boolean mActivelyScrolling;
    @Nullable
    private Rect mClippingRect;
    @Nullable
    private String mOverflow = "hidden";
    private boolean mDragging;
    private boolean mPagingEnabled = false;
    @Nullable
    private Runnable mPostTouchRunnable;
    private boolean mRemoveClippedSubviews;
    private boolean mScrollEnabled = true;
    private boolean mSendMomentumEvents;
    @Nullable
    private FpsListener mFpsListener = null;
    @Nullable
    private String mScrollPerfTag;
    @Nullable
    private Drawable mEndBackground;
    private int mEndFillColor = 0;
    private int mSnapInterval = 0;
    private float mDecelerationRate = 0.985f;
    @Nullable
    private List<Integer> mSnapOffsets;
    private boolean mSnapToStart = true;
    private boolean mSnapToEnd = true;
    private ReactViewBackgroundManager mReactBackgroundManager = new ReactViewBackgroundManager((View)this);

    public ReactHorizontalScrollView(Context context) {
        this(context, null);
    }

    public ReactHorizontalScrollView(Context context, @Nullable FpsListener fpsListener) {
        super(context);
        this.mFpsListener = fpsListener;
        this.mScroller = this.getOverScrollerFromParent();
    }

    @Nullable
    private OverScroller getOverScrollerFromParent() {
        OverScroller scroller;
        if (!sTriedToGetScrollerField) {
            sTriedToGetScrollerField = true;
            try {
                sScrollerField = HorizontalScrollView.class.getDeclaredField("mScroller");
                sScrollerField.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                Log.w((String)"ReactNative", (String)"Failed to get mScroller field for HorizontalScrollView! This app will exhibit the bounce-back scrolling bug :(");
            }
        }
        if (sScrollerField != null) {
            try {
                Object scrollerValue = sScrollerField.get(this);
                if (scrollerValue instanceof OverScroller) {
                    scroller = (OverScroller)scrollerValue;
                }
                Log.w((String)"ReactNative", (String)"Failed to cast mScroller field in HorizontalScrollView (probably due to OEM changes to AOSP)! This app will exhibit the bounce-back scrolling bug :(");
                scroller = null;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to get mScroller from HorizontalScrollView!", e);
            }
        } else {
            scroller = null;
        }
        return scroller;
    }

    public void setScrollPerfTag(@Nullable String scrollPerfTag) {
        this.mScrollPerfTag = scrollPerfTag;
    }

    @Override
    public void setRemoveClippedSubviews(boolean removeClippedSubviews) {
        if (removeClippedSubviews && this.mClippingRect == null) {
            this.mClippingRect = new Rect();
        }
        this.mRemoveClippedSubviews = removeClippedSubviews;
        this.updateClippingRect();
    }

    @Override
    public boolean getRemoveClippedSubviews() {
        return this.mRemoveClippedSubviews;
    }

    public void setSendMomentumEvents(boolean sendMomentumEvents) {
        this.mSendMomentumEvents = sendMomentumEvents;
    }

    public void setScrollEnabled(boolean scrollEnabled) {
        this.mScrollEnabled = scrollEnabled;
    }

    public void setPagingEnabled(boolean pagingEnabled) {
        this.mPagingEnabled = pagingEnabled;
    }

    public void setDecelerationRate(float decelerationRate) {
        this.mDecelerationRate = decelerationRate;
        if (this.mScroller != null) {
            this.mScroller.setFriction(1.0f - this.mDecelerationRate);
        }
    }

    public void setSnapInterval(int snapInterval) {
        this.mSnapInterval = snapInterval;
    }

    public void setSnapOffsets(List<Integer> snapOffsets) {
        this.mSnapOffsets = snapOffsets;
    }

    public void setSnapToStart(boolean snapToStart) {
        this.mSnapToStart = snapToStart;
    }

    public void setSnapToEnd(boolean snapToEnd) {
        this.mSnapToEnd = snapToEnd;
    }

    public void flashScrollIndicators() {
        this.awakenScrollBars();
    }

    public void setOverflow(String overflow) {
        this.mOverflow = overflow;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        this.getDrawingRect(this.mRect);
        switch (this.mOverflow) {
            case "visible": {
                break;
            }
            default: {
                canvas.clipRect(this.mRect);
            }
        }
        super.onDraw(canvas);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        MeasureSpecAssertions.assertExplicitMeasureSpec(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.scrollTo(this.getScrollX(), this.getScrollY());
    }

    protected void onScrollChanged(int x, int y, int oldX, int oldY) {
        super.onScrollChanged(x, y, oldX, oldY);
        this.mActivelyScrolling = true;
        if (this.mOnScrollDispatchHelper.onScrollChanged(x, y)) {
            if (this.mRemoveClippedSubviews) {
                this.updateClippingRect();
            }
            ReactScrollViewHelper.emitScrollEvent((ViewGroup)this, this.mOnScrollDispatchHelper.getXFlingVelocity(), this.mOnScrollDispatchHelper.getYFlingVelocity());
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.mScrollEnabled) {
            return false;
        }
        try {
            if (super.onInterceptTouchEvent(ev)) {
                NativeGestureUtil.notifyNativeGestureStarted((View)this, ev);
                ReactScrollViewHelper.emitScrollBeginDragEvent((ViewGroup)this);
                this.mDragging = true;
                this.enableFpsListener();
                return true;
            }
        }
        catch (IllegalArgumentException e) {
            Log.w((String)"ReactNative", (String)"Error intercepting touch event.", (Throwable)e);
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.mScrollEnabled) {
            return false;
        }
        this.mVelocityHelper.calculateVelocity(ev);
        int action = ev.getAction() & 0xFF;
        if (action == 1 && this.mDragging) {
            float velocityX = this.mVelocityHelper.getXVelocity();
            float velocityY = this.mVelocityHelper.getYVelocity();
            ReactScrollViewHelper.emitScrollEndDragEvent((ViewGroup)this, velocityX, velocityY);
            this.mDragging = false;
            this.handlePostTouchScrolling(Math.round(velocityX), Math.round(velocityY));
        }
        return super.onTouchEvent(ev);
    }

    public void fling(int velocityX) {
        int correctedVelocityX = (int)((float)Math.abs(velocityX) * Math.signum(this.mOnScrollDispatchHelper.getXFlingVelocity()));
        if (this.mPagingEnabled) {
            this.flingAndSnap(correctedVelocityX);
        } else if (this.mScroller != null) {
            int scrollWindowWidth = this.getWidth() - ViewCompat.getPaddingStart((View)this) - ViewCompat.getPaddingEnd((View)this);
            this.mScroller.fling(this.getScrollX(), this.getScrollY(), correctedVelocityX, 0, 0, Integer.MAX_VALUE, 0, 0, scrollWindowWidth / 2, 0);
            ViewCompat.postInvalidateOnAnimation((View)this);
        } else {
            super.fling(correctedVelocityX);
        }
        this.handlePostTouchScrolling(correctedVelocityX, 0);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mRemoveClippedSubviews) {
            this.updateClippingRect();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mRemoveClippedSubviews) {
            this.updateClippingRect();
        }
    }

    @Override
    public void updateClippingRect() {
        if (!this.mRemoveClippedSubviews) {
            return;
        }
        Assertions.assertNotNull((Object)this.mClippingRect);
        ReactClippingViewGroupHelper.calculateClippingRect((View)this, this.mClippingRect);
        View contentView = this.getChildAt(0);
        if (contentView instanceof ReactClippingViewGroup) {
            ((ReactClippingViewGroup)contentView).updateClippingRect();
        }
    }

    @Override
    public void getClippingRect(Rect outClippingRect) {
        outClippingRect.set((Rect)Assertions.assertNotNull((Object)this.mClippingRect));
    }

    private int getSnapInterval() {
        if (this.mSnapInterval != 0) {
            return this.mSnapInterval;
        }
        return this.getWidth();
    }

    public void setEndFillColor(int color) {
        if (color != this.mEndFillColor) {
            this.mEndFillColor = color;
            this.mEndBackground = new ColorDrawable(this.mEndFillColor);
        }
    }

    protected void onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
        int scrollRange;
        if (this.mScroller != null && !this.mScroller.isFinished() && this.mScroller.getCurrX() != this.mScroller.getFinalX() && scrollX >= (scrollRange = this.computeHorizontalScrollRange() - this.getWidth())) {
            this.mScroller.abortAnimation();
            scrollX = scrollRange;
        }
        super.onOverScrolled(scrollX, scrollY, clampedX, clampedY);
    }

    private void enableFpsListener() {
        if (this.isScrollPerfLoggingEnabled()) {
            Assertions.assertNotNull((Object)this.mFpsListener);
            Assertions.assertNotNull((Object)this.mScrollPerfTag);
            this.mFpsListener.enable(this.mScrollPerfTag);
        }
    }

    private void disableFpsListener() {
        if (this.isScrollPerfLoggingEnabled()) {
            Assertions.assertNotNull((Object)this.mFpsListener);
            Assertions.assertNotNull((Object)this.mScrollPerfTag);
            this.mFpsListener.disable(this.mScrollPerfTag);
        }
    }

    private boolean isScrollPerfLoggingEnabled() {
        return this.mFpsListener != null && this.mScrollPerfTag != null && !this.mScrollPerfTag.isEmpty();
    }

    public void draw(Canvas canvas) {
        if (this.mEndFillColor != 0) {
            View content = this.getChildAt(0);
            if (this.mEndBackground != null && content != null && content.getRight() < this.getWidth()) {
                this.mEndBackground.setBounds(content.getRight(), 0, this.getWidth(), this.getHeight());
                this.mEndBackground.draw(canvas);
            }
        }
        super.draw(canvas);
    }

    private void handlePostTouchScrolling(int velocityX, int velocityY) {
        if (!(this.mSendMomentumEvents || this.mPagingEnabled || this.isScrollPerfLoggingEnabled())) {
            return;
        }
        if (this.mPostTouchRunnable != null) {
            return;
        }
        if (this.mSendMomentumEvents) {
            ReactScrollViewHelper.emitScrollMomentumBeginEvent((ViewGroup)this, velocityX, velocityY);
        }
        this.mActivelyScrolling = false;
        this.mPostTouchRunnable = new Runnable(){
            private boolean mSnappingToPage = false;

            @Override
            public void run() {
                if (ReactHorizontalScrollView.this.mActivelyScrolling) {
                    ReactHorizontalScrollView.this.mActivelyScrolling = false;
                    ViewCompat.postOnAnimationDelayed((View)ReactHorizontalScrollView.this, (Runnable)this, (long)20L);
                } else if (ReactHorizontalScrollView.this.mPagingEnabled && !this.mSnappingToPage) {
                    this.mSnappingToPage = true;
                    ReactHorizontalScrollView.this.flingAndSnap(0);
                    ViewCompat.postOnAnimationDelayed((View)ReactHorizontalScrollView.this, (Runnable)this, (long)20L);
                } else {
                    if (ReactHorizontalScrollView.this.mSendMomentumEvents) {
                        ReactScrollViewHelper.emitScrollMomentumEndEvent((ViewGroup)ReactHorizontalScrollView.this);
                    }
                    ReactHorizontalScrollView.this.mPostTouchRunnable = null;
                    ReactHorizontalScrollView.this.disableFpsListener();
                }
            }
        };
        ViewCompat.postOnAnimationDelayed((View)this, (Runnable)this.mPostTouchRunnable, (long)20L);
    }

    private int predictFinalScrollPosition(int velocityX) {
        OverScroller scroller = new OverScroller(this.getContext());
        scroller.setFriction(1.0f - this.mDecelerationRate);
        int maximumOffset = Math.max(0, this.computeHorizontalScrollRange() - this.getWidth());
        int width = this.getWidth() - ViewCompat.getPaddingStart((View)this) - ViewCompat.getPaddingEnd((View)this);
        scroller.fling(this.getScrollX(), this.getScrollY(), velocityX, 0, 0, maximumOffset, 0, 0, width / 2, 0);
        return scroller.getFinalX();
    }

    private void smoothScrollAndSnap(int velocity) {
        double interval = this.getSnapInterval();
        double currentOffset = this.getScrollX();
        double targetOffset = this.predictFinalScrollPosition(velocity);
        int previousPage = (int)Math.floor(currentOffset / interval);
        int nextPage = (int)Math.ceil(currentOffset / interval);
        int currentPage = (int)Math.round(currentOffset / interval);
        int targetPage = (int)Math.round(targetOffset / interval);
        if (velocity > 0 && nextPage == previousPage) {
            ++nextPage;
        } else if (velocity < 0 && previousPage == nextPage) {
            --previousPage;
        }
        if (velocity > 0 && currentPage < nextPage && targetPage > previousPage) {
            currentPage = nextPage;
        } else if (velocity < 0 && currentPage > previousPage && targetPage < nextPage) {
            currentPage = previousPage;
        }
        targetOffset = (double)currentPage * interval;
        if (targetOffset != currentOffset) {
            this.mActivelyScrolling = true;
            this.smoothScrollTo((int)targetOffset, this.getScrollY());
        }
    }

    private void flingAndSnap(int velocityX) {
        boolean isRTL;
        if (this.getChildCount() <= 0) {
            return;
        }
        if (this.mSnapInterval == 0 && this.mSnapOffsets == null) {
            this.smoothScrollAndSnap(velocityX);
            return;
        }
        int maximumOffset = Math.max(0, this.computeHorizontalScrollRange() - this.getWidth());
        int targetOffset = this.predictFinalScrollPosition(velocityX);
        int smallerOffset = 0;
        int largerOffset = maximumOffset;
        int firstOffset = 0;
        int lastOffset = maximumOffset;
        int width = this.getWidth() - ViewCompat.getPaddingStart((View)this) - ViewCompat.getPaddingEnd((View)this);
        boolean bl = isRTL = TextUtilsCompat.getLayoutDirectionFromLocale((Locale)Locale.getDefault()) == 1;
        if (isRTL) {
            targetOffset = maximumOffset - targetOffset;
            velocityX = -velocityX;
        }
        if (this.mSnapOffsets != null) {
            firstOffset = this.mSnapOffsets.get(0);
            lastOffset = this.mSnapOffsets.get(this.mSnapOffsets.size() - 1);
            for (int i = 0; i < this.mSnapOffsets.size(); ++i) {
                int offset = this.mSnapOffsets.get(i);
                if (offset <= targetOffset && targetOffset - offset < targetOffset - smallerOffset) {
                    smallerOffset = offset;
                }
                if (offset < targetOffset || offset - targetOffset >= largerOffset - targetOffset) continue;
                largerOffset = offset;
            }
        } else {
            double interval = this.getSnapInterval();
            double ratio = (double)targetOffset / interval;
            smallerOffset = (int)(Math.floor(ratio) * interval);
            largerOffset = Math.min((int)(Math.ceil(ratio) * interval), maximumOffset);
        }
        int nearestOffset = targetOffset - smallerOffset < largerOffset - targetOffset ? smallerOffset : largerOffset;
        int currentOffset = this.getScrollX();
        if (isRTL) {
            currentOffset = maximumOffset - currentOffset;
        }
        if (!this.mSnapToEnd && targetOffset >= lastOffset) {
            if (currentOffset < lastOffset) {
                targetOffset = lastOffset;
            }
        } else if (!this.mSnapToStart && targetOffset <= firstOffset) {
            if (currentOffset > firstOffset) {
                targetOffset = firstOffset;
            }
        } else if (velocityX > 0) {
            velocityX += (int)((double)(largerOffset - targetOffset) * 10.0);
            targetOffset = largerOffset;
        } else if (velocityX < 0) {
            velocityX -= (int)((double)(targetOffset - smallerOffset) * 10.0);
            targetOffset = smallerOffset;
        } else {
            targetOffset = nearestOffset;
        }
        targetOffset = Math.min(Math.max(0, targetOffset), maximumOffset);
        if (isRTL) {
            targetOffset = maximumOffset - targetOffset;
            velocityX = -velocityX;
        }
        if (this.mScroller != null) {
            this.mActivelyScrolling = true;
            this.mScroller.fling(this.getScrollX(), this.getScrollY(), velocityX != 0 ? velocityX : targetOffset - this.getScrollX(), 0, targetOffset, targetOffset, 0, 0, targetOffset == 0 || targetOffset == maximumOffset ? width / 2 : 0, 0);
            this.postInvalidateOnAnimation();
        } else {
            this.smoothScrollTo(targetOffset, this.getScrollY());
        }
    }

    public void setBackgroundColor(int color) {
        this.mReactBackgroundManager.setBackgroundColor(color);
    }

    public void setBorderWidth(int position, float width) {
        this.mReactBackgroundManager.setBorderWidth(position, width);
    }

    public void setBorderColor(int position, float color, float alpha) {
        this.mReactBackgroundManager.setBorderColor(position, color, alpha);
    }

    public void setBorderRadius(float borderRadius) {
        this.mReactBackgroundManager.setBorderRadius(borderRadius);
    }

    public void setBorderRadius(float borderRadius, int position) {
        this.mReactBackgroundManager.setBorderRadius(borderRadius, position);
    }

    public void setBorderStyle(@Nullable String style2) {
        this.mReactBackgroundManager.setBorderStyle(style2);
    }

    static {
        sTriedToGetScrollerField = false;
    }
}

