/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import java.text.BreakIterator;

public enum TextTransform {
    NONE,
    UPPERCASE,
    LOWERCASE,
    CAPITALIZE,
    UNSET;


    public static String apply(String text, TextTransform textTransform) {
        String transformed;
        if (text == null) {
            return null;
        }
        switch (textTransform) {
            case UPPERCASE: {
                transformed = text.toUpperCase();
                break;
            }
            case LOWERCASE: {
                transformed = text.toLowerCase();
                break;
            }
            case CAPITALIZE: {
                transformed = TextTransform.capitalize(text);
                break;
            }
            default: {
                transformed = text;
            }
        }
        return transformed;
    }

    private static String capitalize(String text) {
        BreakIterator wordIterator = BreakIterator.getWordInstance();
        wordIterator.setText(text);
        StringBuilder res = new StringBuilder(text.length());
        int start = wordIterator.first();
        int end = wordIterator.next();
        while (end != -1) {
            String word = text.substring(start, end);
            if (Character.isLetterOrDigit(word.charAt(0))) {
                res.append(Character.toUpperCase(word.charAt(0)));
                res.append(word.substring(1).toLowerCase());
            } else {
                res.append(word);
            }
            start = end;
            end = wordIterator.next();
        }
        return res.toString();
    }
}

