/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.core;

import android.os.Handler;
import android.util.Log;
import android.view.Choreographer;
import com.facebook.react.bridge.UiThreadUtil;

public class ChoreographerCompat {
    private static final long ONE_FRAME_MILLIS = 17L;
    private static ChoreographerCompat sInstance;
    private Handler mHandler;
    private Choreographer mChoreographer = this.getChoreographer();

    public static ChoreographerCompat getInstance() {
        UiThreadUtil.assertOnUiThread();
        if (sInstance == null) {
            sInstance = new ChoreographerCompat();
        }
        return sInstance;
    }

    private ChoreographerCompat() {
    }

    public void postFrameCallback(FrameCallback callbackWrapper) {
        this.choreographerPostFrameCallback(callbackWrapper.getFrameCallback());
    }

    public void postFrameCallbackDelayed(FrameCallback callbackWrapper, long delayMillis) {
        this.choreographerPostFrameCallbackDelayed(callbackWrapper.getFrameCallback(), delayMillis);
    }

    public void removeFrameCallback(FrameCallback callbackWrapper) {
        this.choreographerRemoveFrameCallback(callbackWrapper.getFrameCallback());
    }

    private Choreographer getChoreographer() {
        return Choreographer.getInstance();
    }

    private void choreographerPostFrameCallback(Choreographer.FrameCallback frameCallback) {
        Log.e((String)"kris performance", (String)"test7");
        this.mChoreographer.postFrameCallback(frameCallback);
    }

    private void choreographerPostFrameCallbackDelayed(Choreographer.FrameCallback frameCallback, long delayMillis) {
        this.mChoreographer.postFrameCallbackDelayed(frameCallback, delayMillis);
    }

    private void choreographerRemoveFrameCallback(Choreographer.FrameCallback frameCallback) {
        this.mChoreographer.removeFrameCallback(frameCallback);
    }

    public static abstract class FrameCallback {
        private Runnable mRunnable;
        private Choreographer.FrameCallback mFrameCallback;

        Choreographer.FrameCallback getFrameCallback() {
            if (this.mFrameCallback == null) {
                this.mFrameCallback = new Choreographer.FrameCallback(){

                    public void doFrame(long frameTimeNanos) {
                        this.doFrame(frameTimeNanos);
                    }
                };
            }
            return this.mFrameCallback;
        }

        Runnable getRunnable() {
            if (this.mRunnable == null) {
                this.mRunnable = new Runnable(){

                    @Override
                    public void run() {
                        this.doFrame(System.nanoTime());
                    }
                };
            }
            return this.mRunnable;
        }

        public abstract void doFrame(long var1);
    }
}

