/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric;

import android.annotation.SuppressLint;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.GuardedRunnable;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.NativeMap;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableNativeMap;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.fabric.FabricEventEmitter;
import com.facebook.react.fabric.GuardedFrameCallback;
import com.facebook.react.fabric.jsi.Binding;
import com.facebook.react.fabric.jsi.EventBeatManager;
import com.facebook.react.fabric.jsi.EventEmitterWrapper;
import com.facebook.react.fabric.jsi.FabricSoLoader;
import com.facebook.react.fabric.mounting.LayoutMetricsConversions;
import com.facebook.react.fabric.mounting.MountingManager;
import com.facebook.react.fabric.mounting.mountitems.BatchMountItem;
import com.facebook.react.fabric.mounting.mountitems.CreateMountItem;
import com.facebook.react.fabric.mounting.mountitems.DeleteMountItem;
import com.facebook.react.fabric.mounting.mountitems.DispatchCommandMountItem;
import com.facebook.react.fabric.mounting.mountitems.InsertMountItem;
import com.facebook.react.fabric.mounting.mountitems.MountItem;
import com.facebook.react.fabric.mounting.mountitems.PreAllocateViewMountItem;
import com.facebook.react.fabric.mounting.mountitems.RemoveMountItem;
import com.facebook.react.fabric.mounting.mountitems.UpdateEventEmitterMountItem;
import com.facebook.react.fabric.mounting.mountitems.UpdateLayoutMountItem;
import com.facebook.react.fabric.mounting.mountitems.UpdateLocalDataMountItem;
import com.facebook.react.fabric.mounting.mountitems.UpdatePropsMountItem;
import com.facebook.react.modules.core.ReactChoreographer;
import com.facebook.react.uimanager.ReactRootViewTagGenerator;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewManagerPropertyUpdater;
import com.facebook.react.uimanager.ViewManagerRegistry;
import com.facebook.react.uimanager.common.MeasureSpecProvider;
import com.facebook.react.uimanager.common.SizeMonitoringFrameLayout;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.systrace.Systrace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@SuppressLint(value={"MissingNativeLoadLibrary"})
public class FabricUIManager
implements UIManager,
LifecycleEventListener {
    private static final String TAG = FabricUIManager.class.getSimpleName();
    private static final Map<String, String> sComponentNames = new HashMap<String, String>();
    private Binding mBinding;
    private final ReactApplicationContext mReactApplicationContext;
    private final MountingManager mMountingManager;
    private final EventDispatcher mEventDispatcher;
    private final ConcurrentHashMap<Integer, ThemedReactContext> mReactContextForRootTag = new ConcurrentHashMap();
    private final EventBeatManager mEventBeatManager;
    private final Object mMountItemsLock = new Object();
    private final Object mPreMountItemsLock = new Object();
    @GuardedBy(value="mMountItemsLock")
    private List<MountItem> mMountItems = new ArrayList<MountItem>();
    @GuardedBy(value="mPreMountItemsLock")
    private List<MountItem> mPreMountItems = new ArrayList<MountItem>();
    @ThreadConfined(value="UI")
    private final DispatchUIFrameCallback mDispatchUIFrameCallback;
    @ThreadConfined(value="UI")
    private boolean mIsMountingEnabled = true;
    private long mRunStartTime = 0L;
    private long mBatchedExecutionTime = 0L;
    private long mNonBatchedExecutionTime = 0L;
    private long mDispatchViewUpdatesTime = 0L;
    private long mCommitStartTime = 0L;
    private long mLayoutTime = 0L;
    private long mFinishTransactionTime = 0L;

    public FabricUIManager(ReactApplicationContext reactContext, ViewManagerRegistry viewManagerRegistry, EventDispatcher eventDispatcher, EventBeatManager eventBeatManager) {
        this.mDispatchUIFrameCallback = new DispatchUIFrameCallback(reactContext);
        this.mReactApplicationContext = reactContext;
        this.mMountingManager = new MountingManager(viewManagerRegistry);
        this.mEventDispatcher = eventDispatcher;
        this.mEventBeatManager = eventBeatManager;
        this.mReactApplicationContext.addLifecycleEventListener(this);
    }

    @Override
    public <T extends SizeMonitoringFrameLayout> int addRootView(T rootView, WritableMap initialProps, @Nullable String initialUITemplate) {
        int rootTag = ReactRootViewTagGenerator.getNextRootViewTag();
        ThemedReactContext reactContext = new ThemedReactContext(this.mReactApplicationContext, rootView.getContext());
        this.mMountingManager.addRootView(rootTag, rootView);
        this.mReactContextForRootTag.put(rootTag, reactContext);
        this.mBinding.startSurface(rootTag, (NativeMap)((Object)initialProps));
        this.updateRootLayoutSpecs(rootTag, ((MeasureSpecProvider)((Object)rootView)).getWidthMeasureSpec(), ((MeasureSpecProvider)((Object)rootView)).getHeightMeasureSpec());
        if (initialUITemplate != null) {
            this.mBinding.renderTemplateToSurface(rootTag, initialUITemplate);
        }
        return rootTag;
    }

    @DoNotStrip
    public void onRequestEventBeat() {
        this.mEventDispatcher.dispatchAllEvents();
    }

    @Override
    public void removeRootView(int reactRootTag) {
        this.mMountingManager.removeRootView(reactRootTag);
        this.mReactContextForRootTag.remove(reactRootTag);
    }

    @DoNotStrip
    private MountItem createMountItem(String componentName, int reactRootTag, int reactTag, boolean isVirtual) {
        String component = sComponentNames.get(componentName);
        if (component == null) {
            throw new IllegalArgumentException("Unable to find component with name " + componentName);
        }
        ThemedReactContext reactContext = this.mReactContextForRootTag.get(reactRootTag);
        if (reactContext == null) {
            throw new IllegalArgumentException("Unable to find ReactContext for root: " + reactRootTag);
        }
        return new CreateMountItem(reactContext, component, reactTag, isVirtual);
    }

    @Override
    public void initialize() {
        this.mEventDispatcher.registerEventEmitter(2, new FabricEventEmitter(this));
        this.mEventDispatcher.addBatchEventDispatchedListener(this.mEventBeatManager);
    }

    @Override
    public void onCatalystInstanceDestroy() {
        this.mEventDispatcher.removeBatchEventDispatchedListener(this.mEventBeatManager);
        this.mEventDispatcher.unregisterEventEmitter(2);
        this.mBinding.unregister();
        ViewManagerPropertyUpdater.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoNotStrip
    private void preallocateView(int rootTag, String componentName) {
        if (UiThreadUtil.isOnUiThread()) {
            return;
        }
        Object object = this.mPreMountItemsLock;
        synchronized (object) {
            ThemedReactContext context = (ThemedReactContext)((Object)Assertions.assertNotNull((Object)((Object)this.mReactContextForRootTag.get(rootTag))));
            String component = sComponentNames.get(componentName);
            Assertions.assertNotNull((Object)component);
            this.mPreMountItems.add(new PreAllocateViewMountItem(context, rootTag, component));
        }
    }

    @DoNotStrip
    private MountItem removeMountItem(int reactTag, int parentReactTag, int index) {
        return new RemoveMountItem(reactTag, parentReactTag, index);
    }

    @DoNotStrip
    private MountItem insertMountItem(int reactTag, int parentReactTag, int index) {
        return new InsertMountItem(reactTag, parentReactTag, index);
    }

    @DoNotStrip
    private MountItem deleteMountItem(int reactTag) {
        return new DeleteMountItem(reactTag);
    }

    @DoNotStrip
    private MountItem updateLayoutMountItem(int reactTag, int x, int y, int width, int height) {
        return new UpdateLayoutMountItem(reactTag, x, y, width, height);
    }

    @DoNotStrip
    private MountItem updatePropsMountItem(int reactTag, ReadableNativeMap map) {
        return new UpdatePropsMountItem(reactTag, map);
    }

    @DoNotStrip
    private MountItem updateLocalDataMountItem(int reactTag, ReadableNativeMap newLocalData) {
        return new UpdateLocalDataMountItem(reactTag, newLocalData);
    }

    @DoNotStrip
    private MountItem updateEventEmitterMountItem(int reactTag, Object eventEmitter) {
        return new UpdateEventEmitterMountItem(reactTag, (EventEmitterWrapper)eventEmitter);
    }

    @DoNotStrip
    private MountItem createBatchMountItem(MountItem[] items, int size) {
        return new BatchMountItem(items, size);
    }

    @DoNotStrip
    private long measure(String componentName, ReadableNativeMap localData, ReadableNativeMap props, int minWidth, int maxWidth, int minHeight, int maxHeight) {
        return this.mMountingManager.measure(this.mReactApplicationContext, componentName, localData, props, LayoutMetricsConversions.getYogaSize(minWidth, maxWidth), LayoutMetricsConversions.getYogaMeasureMode(minWidth, maxWidth), LayoutMetricsConversions.getYogaSize(minHeight, maxHeight), LayoutMetricsConversions.getYogaMeasureMode(minHeight, maxHeight));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoNotStrip
    private void scheduleMountItems(MountItem mountItems, long commitStartTime, long layoutTime, long finishTransactionStartTime) {
        this.mCommitStartTime = commitStartTime;
        this.mLayoutTime = layoutTime;
        this.mFinishTransactionTime = SystemClock.uptimeMillis() - finishTransactionStartTime;
        this.mDispatchViewUpdatesTime = SystemClock.uptimeMillis();
        Object object = this.mMountItemsLock;
        synchronized (object) {
            this.mMountItems.add(mountItems);
        }
        if (UiThreadUtil.isOnUiThread()) {
            this.flushMountItems();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    private void flushMountItems() {
        if (!this.mIsMountingEnabled) {
            FLog.w((String)"ReactNative", (String)"Not flushing pending UI operations because of previously thrown Exception");
            return;
        }
        try {
            List<MountItem> mountItemsToDispatch;
            List<MountItem> preMountItemsToDispatch;
            Object object = this.mPreMountItemsLock;
            synchronized (object) {
                preMountItemsToDispatch = this.mPreMountItems;
                this.mPreMountItems = new ArrayList<MountItem>();
            }
            this.mRunStartTime = SystemClock.uptimeMillis();
            Object object2 = this.mMountItemsLock;
            synchronized (object2) {
                mountItemsToDispatch = this.mMountItems;
                this.mMountItems = new ArrayList<MountItem>();
            }
            long nonBatchedExecutionStartTime = SystemClock.uptimeMillis();
            Systrace.beginSection(0L, "FabricUIManager::premountViews (" + preMountItemsToDispatch.size() + " batches)");
            for (MountItem mountItem : preMountItemsToDispatch) {
                mountItem.execute(this.mMountingManager);
            }
            this.mNonBatchedExecutionTime = SystemClock.uptimeMillis() - nonBatchedExecutionStartTime;
            Systrace.endSection(0L);
            Systrace.beginSection(0L, "FabricUIManager::mountViews (" + mountItemsToDispatch.size() + " batches)");
            long batchedExecutionStartTime = SystemClock.uptimeMillis();
            for (MountItem mountItem : mountItemsToDispatch) {
                mountItem.execute(this.mMountingManager);
            }
            this.mBatchedExecutionTime = SystemClock.uptimeMillis() - batchedExecutionStartTime;
            Systrace.endSection(0L);
        }
        catch (Exception ex) {
            FLog.e((String)"ReactNative", (String)"Exception thrown when executing UIFrameGuarded", (Throwable)ex);
            this.mIsMountingEnabled = false;
            throw ex;
        }
    }

    public void setBinding(Binding binding) {
        this.mBinding = binding;
    }

    @Override
    public void updateRootLayoutSpecs(final int rootTag, final int widthMeasureSpec, final int heightMeasureSpec) {
        this.mReactApplicationContext.runOnJSQueueThread(new GuardedRunnable(this.mReactApplicationContext){

            @Override
            public void runGuarded() {
                FabricUIManager.this.mBinding.setConstraints(rootTag, LayoutMetricsConversions.getMinSize(widthMeasureSpec), LayoutMetricsConversions.getMaxSize(widthMeasureSpec), LayoutMetricsConversions.getMinSize(heightMeasureSpec), LayoutMetricsConversions.getMaxSize(heightMeasureSpec));
            }
        });
    }

    public void receiveEvent(int reactTag, String eventName, @Nullable WritableMap params) {
        EventEmitterWrapper eventEmitter = this.mMountingManager.getEventEmitter(reactTag);
        if (eventEmitter == null) {
            FLog.d((String)TAG, (String)("Unable to invoke event: " + eventName + " for reactTag: " + reactTag));
            return;
        }
        eventEmitter.invoke(eventName, params);
    }

    @Override
    public void onHostResume() {
    }

    @Override
    public void onHostPause() {
    }

    @Override
    public void onHostDestroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchCommand(int reactTag, int commandId, ReadableArray commandArgs) {
        Object object = this.mMountItemsLock;
        synchronized (object) {
            this.mMountItems.add(new DispatchCommandMountItem(reactTag, commandId, commandArgs));
        }
    }

    @Override
    public void setJSResponder(int reactTag, boolean blockNativeResponder) {
    }

    @Override
    public void clearJSResponder() {
    }

    @Override
    public void profileNextBatch() {
    }

    @Override
    public Map<String, Long> getPerformanceCounters() {
        HashMap<String, Long> performanceCounters = new HashMap<String, Long>();
        performanceCounters.put("CommitStartTime", this.mCommitStartTime);
        performanceCounters.put("LayoutTime", this.mLayoutTime);
        performanceCounters.put("DispatchViewUpdatesTime", this.mDispatchViewUpdatesTime);
        performanceCounters.put("RunStartTime", this.mRunStartTime);
        performanceCounters.put("BatchedExecutionTime", this.mBatchedExecutionTime);
        performanceCounters.put("NonBatchedExecutionTime", this.mNonBatchedExecutionTime);
        performanceCounters.put("FinishFabricTransactionTime", this.mFinishTransactionTime);
        return performanceCounters;
    }

    static {
        FabricSoLoader.staticInit();
        sComponentNames.put("View", "RCTView");
        sComponentNames.put("Image", "RCTImageView");
        sComponentNames.put("ScrollView", "RCTScrollView");
        sComponentNames.put("ReactPerformanceLoggerFlag", "ReactPerformanceLoggerFlag");
        sComponentNames.put("Paragraph", "RCTText");
        sComponentNames.put("Text", "RCText");
        sComponentNames.put("RawText", "RCTRawText");
        sComponentNames.put("ActivityIndicatorView", "AndroidProgressBar");
        sComponentNames.put("ShimmeringView", "RKShimmeringView");
        sComponentNames.put("TemplateView", "RCTTemplateView");
    }

    private class DispatchUIFrameCallback
    extends GuardedFrameCallback {
        private DispatchUIFrameCallback(ReactContext reactContext) {
            super(reactContext);
        }

        @Override
        public void doFrameGuarded(long frameTimeNanos) {
            if (!FabricUIManager.this.mIsMountingEnabled) {
                FLog.w((String)"ReactNative", (String)"Not flushing pending UI operations because of previously thrown Exception");
                return;
            }
            Log.e((String)"kris added test", (String)"performance test99999");
            try {
                FabricUIManager.this.flushMountItems();
            }
            catch (Exception ex) {
                FLog.i((String)"ReactNative", (String)"Exception thrown when executing UIFrameGuarded", (Throwable)ex);
                FabricUIManager.this.mIsMountingEnabled = false;
                throw ex;
            }
            finally {
                Log.e((String)"kris performance", (String)"test6");
                ReactChoreographer.getInstance().postFrameCallback(ReactChoreographer.CallbackType.DISPATCH_UI, FabricUIManager.this.mDispatchUIFrameCallback);
            }
        }
    }
}

