/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.os.SystemClock;
import com.facebook.common.logging.FLog;
import com.facebook.react.animation.Animation;
import com.facebook.react.animation.AnimationRegistry;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.GuardedRunnable;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.SoftAssertions;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.modules.core.ReactChoreographer;
import com.facebook.react.uimanager.GuardedFrameCallback;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.NativeViewHierarchyManager;
import com.facebook.react.uimanager.NoSuchNativeViewException;
import com.facebook.react.uimanager.OnLayoutEvent;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIBlock;
import com.facebook.react.uimanager.UIImplementation;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.ViewAtIndex;
import com.facebook.react.uimanager.common.SizeMonitoringFrameLayout;
import com.facebook.react.uimanager.debug.NotThreadSafeViewHierarchyUpdateDebugListener;
import com.facebook.systrace.Systrace;
import com.facebook.systrace.SystraceMessage;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class UIViewOperationQueue {
    public static final int DEFAULT_MIN_TIME_LEFT_IN_FRAME_FOR_NONBATCHED_OPERATION_MS = 8;
    private final int[] mMeasureBuffer = new int[4];
    private final NativeViewHierarchyManager mNativeViewHierarchyManager;
    private final AnimationRegistry mAnimationRegistry;
    private final Object mDispatchRunnablesLock = new Object();
    private final Object mNonBatchedOperationsLock = new Object();
    private final DispatchUIFrameCallback mDispatchUIFrameCallback;
    private final ReactApplicationContext mReactApplicationContext;
    private ArrayList<UIOperation> mOperations = new ArrayList();
    @GuardedBy(value="mDispatchRunnablesLock")
    private ArrayList<Runnable> mDispatchUIRunnables = new ArrayList();
    @GuardedBy(value="mNonBatchedOperationsLock")
    private ArrayDeque<UIOperation> mNonBatchedOperations = new ArrayDeque();
    @Nullable
    private NotThreadSafeViewHierarchyUpdateDebugListener mViewHierarchyUpdateDebugListener;
    private boolean mIsDispatchUIFrameCallbackEnqueued = false;
    private boolean mIsInIllegalUIState = false;
    private boolean mIsProfilingNextBatch = false;
    private long mNonBatchedExecutionTotalTime;
    private long mProfiledBatchCommitStartTime;
    private long mProfiledBatchLayoutTime;
    private long mProfiledBatchDispatchViewUpdatesTime;
    private long mProfiledBatchRunStartTime;
    private long mProfiledBatchBatchedExecutionTime;
    private long mProfiledBatchNonBatchedExecutionTime;
    private long mThreadCpuTime;

    public UIViewOperationQueue(ReactApplicationContext reactContext, NativeViewHierarchyManager nativeViewHierarchyManager, int minTimeLeftInFrameForNonBatchedOperationMs) {
        this.mNativeViewHierarchyManager = nativeViewHierarchyManager;
        this.mAnimationRegistry = nativeViewHierarchyManager.getAnimationRegistry();
        this.mDispatchUIFrameCallback = new DispatchUIFrameCallback(reactContext, minTimeLeftInFrameForNonBatchedOperationMs == -1 ? 8 : minTimeLeftInFrameForNonBatchedOperationMs);
        this.mReactApplicationContext = reactContext;
    }

    NativeViewHierarchyManager getNativeViewHierarchyManager() {
        return this.mNativeViewHierarchyManager;
    }

    public void setViewHierarchyUpdateDebugListener(@Nullable NotThreadSafeViewHierarchyUpdateDebugListener listener) {
        this.mViewHierarchyUpdateDebugListener = listener;
    }

    public void profileNextBatch() {
        this.mIsProfilingNextBatch = true;
        this.mProfiledBatchCommitStartTime = 0L;
    }

    public Map<String, Long> getProfiledBatchPerfCounters() {
        HashMap<String, Long> perfMap = new HashMap<String, Long>();
        perfMap.put("CommitStartTime", this.mProfiledBatchCommitStartTime);
        perfMap.put("LayoutTime", this.mProfiledBatchLayoutTime);
        perfMap.put("DispatchViewUpdatesTime", this.mProfiledBatchDispatchViewUpdatesTime);
        perfMap.put("RunStartTime", this.mProfiledBatchRunStartTime);
        perfMap.put("BatchedExecutionTime", this.mProfiledBatchBatchedExecutionTime);
        perfMap.put("NonBatchedExecutionTime", this.mProfiledBatchNonBatchedExecutionTime);
        perfMap.put("NativeModulesThreadCpuTime", this.mThreadCpuTime);
        return perfMap;
    }

    public boolean isEmpty() {
        return this.mOperations.isEmpty();
    }

    public void addRootView(int tag, SizeMonitoringFrameLayout rootView, ThemedReactContext themedRootContext) {
        this.mNativeViewHierarchyManager.addRootView(tag, rootView, themedRootContext);
    }

    protected void enqueueUIOperation(UIOperation operation) {
        SoftAssertions.assertNotNull(operation);
        this.mOperations.add(operation);
    }

    public void enqueueRemoveRootView(int rootViewTag) {
        this.mOperations.add(new RemoveRootViewOperation(rootViewTag));
    }

    public void enqueueSetJSResponder(int tag, int initialTag, boolean blockNativeResponder) {
        this.mOperations.add(new ChangeJSResponderOperation(tag, initialTag, false, blockNativeResponder));
    }

    public void enqueueClearJSResponder() {
        this.mOperations.add(new ChangeJSResponderOperation(0, 0, true, false));
    }

    public void enqueueDispatchCommand(int reactTag, int commandId, @Nullable ReadableArray commandArgs) {
        this.mOperations.add(new DispatchCommandOperation(reactTag, commandId, commandArgs));
    }

    public void enqueueUpdateExtraData(int reactTag, Object extraData) {
        this.mOperations.add(new UpdateViewExtraData(reactTag, extraData));
    }

    public void enqueueShowPopupMenu(int reactTag, ReadableArray items, Callback error, Callback success) {
        this.mOperations.add(new ShowPopupMenuOperation(reactTag, items, error, success));
    }

    public void enqueueDismissPopupMenu() {
        this.mOperations.add(new DismissPopupMenuOperation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueCreateView(ThemedReactContext themedContext, int viewReactTag, String viewClassName, @Nullable ReactStylesDiffMap initialProps) {
        Object object = this.mNonBatchedOperationsLock;
        synchronized (object) {
            this.mNonBatchedOperations.addLast(new CreateViewOperation(themedContext, viewReactTag, viewClassName, initialProps));
        }
    }

    public void enqueueUpdateInstanceHandle(int reactTag, long instanceHandle) {
        this.mOperations.add(new UpdateInstanceHandleOperation(reactTag, instanceHandle));
    }

    public void enqueueUpdateProperties(int reactTag, String className, ReactStylesDiffMap props) {
        this.mOperations.add(new UpdatePropertiesOperation(reactTag, props));
    }

    public void enqueueOnLayoutEvent(int tag, int screenX, int screenY, int screenWidth, int screenHeight) {
        this.mOperations.add(new EmitOnLayoutEventOperation(tag, screenX, screenY, screenWidth, screenHeight));
    }

    public void enqueueUpdateLayout(int parentTag, int reactTag, int x, int y, int width, int height) {
        this.mOperations.add(new UpdateLayoutOperation(parentTag, reactTag, x, y, width, height));
    }

    public void enqueueManageChildren(int reactTag, @Nullable int[] indicesToRemove, @Nullable ViewAtIndex[] viewsToAdd, @Nullable int[] tagsToDelete) {
        this.mOperations.add(new ManageChildrenOperation(reactTag, indicesToRemove, viewsToAdd, tagsToDelete));
    }

    public void enqueueSetChildren(int reactTag, ReadableArray childrenTags) {
        this.mOperations.add(new SetChildrenOperation(reactTag, childrenTags));
    }

    public void enqueueRegisterAnimation(Animation animation) {
        this.mOperations.add(new RegisterAnimationOperation(animation));
    }

    public void enqueueAddAnimation(int reactTag, int animationID, Callback onSuccess) {
        this.mOperations.add(new AddAnimationOperation(reactTag, animationID, onSuccess));
    }

    public void enqueueRemoveAnimation(int animationID) {
        this.mOperations.add(new RemoveAnimationOperation(animationID));
    }

    public void enqueueSetLayoutAnimationEnabled(boolean enabled) {
        this.mOperations.add(new SetLayoutAnimationEnabledOperation(enabled));
    }

    public void enqueueConfigureLayoutAnimation(ReadableMap config, Callback onSuccess, Callback onError) {
        this.mOperations.add(new ConfigureLayoutAnimationOperation(config));
    }

    public void enqueueMeasure(int reactTag, Callback callback) {
        this.mOperations.add(new MeasureOperation(reactTag, callback));
    }

    public void enqueueMeasureInWindow(int reactTag, Callback callback) {
        this.mOperations.add(new MeasureInWindowOperation(reactTag, callback));
    }

    public void enqueueFindTargetForTouch(int reactTag, float targetX, float targetY, Callback callback) {
        this.mOperations.add(new FindTargetForTouchOperation(reactTag, targetX, targetY, callback));
    }

    public void enqueueSendAccessibilityEvent(int tag, int eventType) {
        this.mOperations.add(new SendAccessibilityEvent(tag, eventType));
    }

    public void enqueueLayoutUpdateFinished(ReactShadowNode node, UIImplementation.LayoutUpdateListener listener) {
        this.mOperations.add(new LayoutUpdateFinishedOperation(node, listener));
    }

    public void enqueueUIBlock(UIBlock block) {
        this.mOperations.add(new UIBlockOperation(block));
    }

    public void prependUIBlock(UIBlock block) {
        this.mOperations.add(0, new UIBlockOperation(block));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchViewUpdates(final int batchId, final long commitStartTime, final long layoutTime) {
        SystraceMessage.beginSection(0L, "UIViewOperationQueue.dispatchViewUpdates").arg("batchId", batchId).flush();
        try {
            ArrayDeque<UIOperation> nonBatchedOperations;
            ArrayList<UIOperation> batchedOperations;
            final long dispatchViewUpdatesTime = SystemClock.uptimeMillis();
            final long nativeModulesThreadCpuTime = SystemClock.currentThreadTimeMillis();
            if (!this.mOperations.isEmpty()) {
                batchedOperations = this.mOperations;
                this.mOperations = new ArrayList();
            } else {
                batchedOperations = null;
            }
            Object object = this.mNonBatchedOperationsLock;
            synchronized (object) {
                if (!this.mNonBatchedOperations.isEmpty()) {
                    nonBatchedOperations = this.mNonBatchedOperations;
                    this.mNonBatchedOperations = new ArrayDeque();
                } else {
                    nonBatchedOperations = null;
                }
            }
            if (this.mViewHierarchyUpdateDebugListener != null) {
                this.mViewHierarchyUpdateDebugListener.onViewHierarchyUpdateEnqueued();
            }
            Runnable runOperations = new Runnable(){

                @Override
                public void run() {
                    SystraceMessage.beginSection(0L, "DispatchUI").arg("BatchId", batchId).flush();
                    try {
                        long runStartTime = SystemClock.uptimeMillis();
                        if (nonBatchedOperations != null) {
                            for (UIOperation op : nonBatchedOperations) {
                                op.execute();
                            }
                        }
                        if (batchedOperations != null) {
                            for (UIOperation op : batchedOperations) {
                                op.execute();
                            }
                        }
                        if (UIViewOperationQueue.this.mIsProfilingNextBatch && UIViewOperationQueue.this.mProfiledBatchCommitStartTime == 0L) {
                            UIViewOperationQueue.this.mProfiledBatchCommitStartTime = commitStartTime;
                            UIViewOperationQueue.this.mProfiledBatchLayoutTime = layoutTime;
                            UIViewOperationQueue.this.mProfiledBatchDispatchViewUpdatesTime = dispatchViewUpdatesTime;
                            UIViewOperationQueue.this.mProfiledBatchRunStartTime = runStartTime;
                            UIViewOperationQueue.this.mThreadCpuTime = nativeModulesThreadCpuTime;
                            Systrace.beginAsyncSection(0L, "delayBeforeDispatchViewUpdates", 0, UIViewOperationQueue.this.mProfiledBatchCommitStartTime * 1000000L);
                            Systrace.endAsyncSection(0L, "delayBeforeDispatchViewUpdates", 0, UIViewOperationQueue.this.mProfiledBatchDispatchViewUpdatesTime * 1000000L);
                            Systrace.beginAsyncSection(0L, "delayBeforeBatchRunStart", 0, UIViewOperationQueue.this.mProfiledBatchDispatchViewUpdatesTime * 1000000L);
                            Systrace.endAsyncSection(0L, "delayBeforeBatchRunStart", 0, UIViewOperationQueue.this.mProfiledBatchRunStartTime * 1000000L);
                        }
                        UIViewOperationQueue.this.mNativeViewHierarchyManager.clearLayoutAnimation();
                        if (UIViewOperationQueue.this.mViewHierarchyUpdateDebugListener != null) {
                            UIViewOperationQueue.this.mViewHierarchyUpdateDebugListener.onViewHierarchyUpdateFinished();
                        }
                    }
                    catch (Exception e) {
                        UIViewOperationQueue.this.mIsInIllegalUIState = true;
                        throw e;
                    }
                    finally {
                        Systrace.endSection(0L);
                    }
                }
            };
            SystraceMessage.beginSection(0L, "acquiring mDispatchRunnablesLock").arg("batchId", batchId).flush();
            Object object2 = this.mDispatchRunnablesLock;
            synchronized (object2) {
                Systrace.endSection(0L);
                this.mDispatchUIRunnables.add(runOperations);
            }
            if (!this.mIsDispatchUIFrameCallbackEnqueued) {
                UiThreadUtil.runOnUiThread(new GuardedRunnable(this.mReactApplicationContext){

                    @Override
                    public void runGuarded() {
                        UIViewOperationQueue.this.flushPendingBatches();
                    }
                });
            }
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    void resumeFrameCallback() {
        this.mIsDispatchUIFrameCallbackEnqueued = true;
        ReactChoreographer.getInstance().postFrameCallback(ReactChoreographer.CallbackType.DISPATCH_UI, this.mDispatchUIFrameCallback);
    }

    void pauseFrameCallback() {
        this.mIsDispatchUIFrameCallbackEnqueued = false;
        ReactChoreographer.getInstance().removeFrameCallback(ReactChoreographer.CallbackType.DISPATCH_UI, this.mDispatchUIFrameCallback);
        this.flushPendingBatches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushPendingBatches() {
        ArrayList<Runnable> runnables;
        if (this.mIsInIllegalUIState) {
            FLog.w((String)"ReactNative", (String)"Not flushing pending UI operations because of previously thrown Exception");
            return;
        }
        Object object = this.mDispatchRunnablesLock;
        synchronized (object) {
            if (this.mDispatchUIRunnables.isEmpty()) {
                return;
            }
            runnables = this.mDispatchUIRunnables;
            this.mDispatchUIRunnables = new ArrayList();
        }
        long batchedExecutionStartTime = SystemClock.uptimeMillis();
        for (Runnable runnable : runnables) {
            runnable.run();
        }
        if (this.mIsProfilingNextBatch) {
            this.mProfiledBatchBatchedExecutionTime = SystemClock.uptimeMillis() - batchedExecutionStartTime;
            this.mProfiledBatchNonBatchedExecutionTime = this.mNonBatchedExecutionTotalTime;
            this.mIsProfilingNextBatch = false;
            Systrace.beginAsyncSection(0L, "batchedExecutionTime", 0, batchedExecutionStartTime * 1000000L);
            Systrace.endAsyncSection(0L, "batchedExecutionTime", 0);
        }
        this.mNonBatchedExecutionTotalTime = 0L;
    }

    private class DispatchUIFrameCallback
    extends GuardedFrameCallback {
        private static final int FRAME_TIME_MS = 16;
        private final int mMinTimeLeftInFrameForNonBatchedOperationMs;

        private DispatchUIFrameCallback(ReactContext reactContext, int minTimeLeftInFrameForNonBatchedOperationMs) {
            super(reactContext);
            this.mMinTimeLeftInFrameForNonBatchedOperationMs = minTimeLeftInFrameForNonBatchedOperationMs;
        }

        @Override
        public void doFrameGuarded(long frameTimeNanos) {
            if (UIViewOperationQueue.this.mIsInIllegalUIState) {
                FLog.w((String)"ReactNative", (String)"Not flushing pending UI operations because of previously thrown Exception");
                return;
            }
            Systrace.beginSection(0L, "dispatchNonBatchedUIOperations");
            try {
                this.dispatchPendingNonBatchedOperations(frameTimeNanos);
            }
            finally {
                Systrace.endSection(0L);
            }
            UIViewOperationQueue.this.flushPendingBatches();
            ReactChoreographer.getInstance().postFrameCallback(ReactChoreographer.CallbackType.DISPATCH_UI, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchPendingNonBatchedOperations(long frameTimeNanos) {
            long timeLeftInFrame;
            while ((timeLeftInFrame = 16L - (System.nanoTime() - frameTimeNanos) / 1000000L) >= (long)this.mMinTimeLeftInFrameForNonBatchedOperationMs) {
                UIOperation nextOperation;
                Object object = UIViewOperationQueue.this.mNonBatchedOperationsLock;
                synchronized (object) {
                    if (UIViewOperationQueue.this.mNonBatchedOperations.isEmpty()) {
                        break;
                    }
                    nextOperation = (UIOperation)UIViewOperationQueue.this.mNonBatchedOperations.pollFirst();
                }
                try {
                    long nonBatchedExecutionStartTime = SystemClock.uptimeMillis();
                    nextOperation.execute();
                    UIViewOperationQueue.this.mNonBatchedExecutionTotalTime = UIViewOperationQueue.this.mNonBatchedExecutionTotalTime + (SystemClock.uptimeMillis() - nonBatchedExecutionStartTime);
                }
                catch (Exception e) {
                    UIViewOperationQueue.this.mIsInIllegalUIState = true;
                    throw e;
                }
            }
        }
    }

    private final class SendAccessibilityEvent
    extends ViewOperation {
        private final int mEventType;

        private SendAccessibilityEvent(int tag, int eventType) {
            super(tag);
            this.mEventType = eventType;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.sendAccessibilityEvent(this.mTag, this.mEventType);
        }
    }

    private class UIBlockOperation
    implements UIOperation {
        private final UIBlock mBlock;

        public UIBlockOperation(UIBlock block) {
            this.mBlock = block;
        }

        @Override
        public void execute() {
            this.mBlock.execute(UIViewOperationQueue.this.mNativeViewHierarchyManager);
        }
    }

    private final class LayoutUpdateFinishedOperation
    implements UIOperation {
        private final ReactShadowNode mNode;
        private final UIImplementation.LayoutUpdateListener mListener;

        private LayoutUpdateFinishedOperation(ReactShadowNode node, UIImplementation.LayoutUpdateListener listener) {
            this.mNode = node;
            this.mListener = listener;
        }

        @Override
        public void execute() {
            this.mListener.onLayoutUpdated(this.mNode);
        }
    }

    private final class FindTargetForTouchOperation
    implements UIOperation {
        private final int mReactTag;
        private final float mTargetX;
        private final float mTargetY;
        private final Callback mCallback;

        private FindTargetForTouchOperation(int reactTag, float targetX, float targetY, Callback callback) {
            this.mReactTag = reactTag;
            this.mTargetX = targetX;
            this.mTargetY = targetY;
            this.mCallback = callback;
        }

        @Override
        public void execute() {
            try {
                UIViewOperationQueue.this.mNativeViewHierarchyManager.measure(this.mReactTag, UIViewOperationQueue.this.mMeasureBuffer);
            }
            catch (IllegalViewOperationException e) {
                this.mCallback.invoke(new Object[0]);
                return;
            }
            float containerX = UIViewOperationQueue.this.mMeasureBuffer[0];
            float containerY = UIViewOperationQueue.this.mMeasureBuffer[1];
            int touchTargetReactTag = UIViewOperationQueue.this.mNativeViewHierarchyManager.findTargetTagForTouch(this.mReactTag, this.mTargetX, this.mTargetY);
            try {
                UIViewOperationQueue.this.mNativeViewHierarchyManager.measure(touchTargetReactTag, UIViewOperationQueue.this.mMeasureBuffer);
            }
            catch (IllegalViewOperationException e) {
                this.mCallback.invoke(new Object[0]);
                return;
            }
            float x = PixelUtil.toDIPFromPixel((float)UIViewOperationQueue.this.mMeasureBuffer[0] - containerX);
            float y = PixelUtil.toDIPFromPixel((float)UIViewOperationQueue.this.mMeasureBuffer[1] - containerY);
            float width = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[2]);
            float height = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[3]);
            this.mCallback.invoke(touchTargetReactTag, Float.valueOf(x), Float.valueOf(y), Float.valueOf(width), Float.valueOf(height));
        }
    }

    private final class MeasureInWindowOperation
    implements UIOperation {
        private final int mReactTag;
        private final Callback mCallback;

        private MeasureInWindowOperation(int reactTag, Callback callback) {
            this.mReactTag = reactTag;
            this.mCallback = callback;
        }

        @Override
        public void execute() {
            try {
                UIViewOperationQueue.this.mNativeViewHierarchyManager.measureInWindow(this.mReactTag, UIViewOperationQueue.this.mMeasureBuffer);
            }
            catch (NoSuchNativeViewException e) {
                this.mCallback.invoke(new Object[0]);
                return;
            }
            float x = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[0]);
            float y = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[1]);
            float width = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[2]);
            float height = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[3]);
            this.mCallback.invoke(Float.valueOf(x), Float.valueOf(y), Float.valueOf(width), Float.valueOf(height));
        }
    }

    private final class MeasureOperation
    implements UIOperation {
        private final int mReactTag;
        private final Callback mCallback;

        private MeasureOperation(int reactTag, Callback callback) {
            this.mReactTag = reactTag;
            this.mCallback = callback;
        }

        @Override
        public void execute() {
            try {
                UIViewOperationQueue.this.mNativeViewHierarchyManager.measure(this.mReactTag, UIViewOperationQueue.this.mMeasureBuffer);
            }
            catch (NoSuchNativeViewException e) {
                this.mCallback.invoke(new Object[0]);
                return;
            }
            float x = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[0]);
            float y = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[1]);
            float width = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[2]);
            float height = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[3]);
            this.mCallback.invoke(0, 0, Float.valueOf(width), Float.valueOf(height), Float.valueOf(x), Float.valueOf(y));
        }
    }

    private class ConfigureLayoutAnimationOperation
    implements UIOperation {
        private final ReadableMap mConfig;

        private ConfigureLayoutAnimationOperation(ReadableMap config) {
            this.mConfig = config;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.configureLayoutAnimation(this.mConfig);
        }
    }

    private class SetLayoutAnimationEnabledOperation
    implements UIOperation {
        private final boolean mEnabled;

        private SetLayoutAnimationEnabledOperation(boolean enabled) {
            this.mEnabled = enabled;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.setLayoutAnimationEnabled(this.mEnabled);
        }
    }

    private final class RemoveAnimationOperation
    extends AnimationOperation {
        private RemoveAnimationOperation(int animationID) {
            super(animationID);
        }

        @Override
        public void execute() {
            Animation animation = UIViewOperationQueue.this.mAnimationRegistry.getAnimation(this.mAnimationID);
            if (animation != null) {
                animation.cancel();
            }
        }
    }

    private class AddAnimationOperation
    extends AnimationOperation {
        private final int mReactTag;
        private final Callback mSuccessCallback;

        private AddAnimationOperation(int reactTag, int animationID, Callback successCallback) {
            super(animationID);
            this.mReactTag = reactTag;
            this.mSuccessCallback = successCallback;
        }

        @Override
        public void execute() {
            Animation animation = UIViewOperationQueue.this.mAnimationRegistry.getAnimation(this.mAnimationID);
            if (animation == null) {
                throw new IllegalViewOperationException("Animation with id " + this.mAnimationID + " was not found");
            }
            UIViewOperationQueue.this.mNativeViewHierarchyManager.startAnimationForNativeView(this.mReactTag, animation, this.mSuccessCallback);
        }
    }

    private class RegisterAnimationOperation
    extends AnimationOperation {
        private final Animation mAnimation;

        private RegisterAnimationOperation(Animation animation) {
            super(animation.getAnimationID());
            this.mAnimation = animation;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mAnimationRegistry.registerAnimation(this.mAnimation);
        }
    }

    private static abstract class AnimationOperation
    implements UIOperation {
        protected final int mAnimationID;

        public AnimationOperation(int animationID) {
            this.mAnimationID = animationID;
        }
    }

    private final class DismissPopupMenuOperation
    implements UIOperation {
        private DismissPopupMenuOperation() {
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.dismissPopupMenu();
        }
    }

    private final class ShowPopupMenuOperation
    extends ViewOperation {
        private final ReadableArray mItems;
        private final Callback mError;
        private final Callback mSuccess;

        public ShowPopupMenuOperation(int tag, ReadableArray items, Callback error, Callback success) {
            super(tag);
            this.mItems = items;
            this.mError = error;
            this.mSuccess = success;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.showPopupMenu(this.mTag, this.mItems, this.mSuccess, this.mError);
        }
    }

    private final class DispatchCommandOperation
    extends ViewOperation {
        private final int mCommand;
        @Nullable
        private final ReadableArray mArgs;

        public DispatchCommandOperation(int tag, @Nullable int command, ReadableArray args) {
            super(tag);
            this.mCommand = command;
            this.mArgs = args;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.dispatchCommand(this.mTag, this.mCommand, this.mArgs);
        }
    }

    private final class ChangeJSResponderOperation
    extends ViewOperation {
        private final int mInitialTag;
        private final boolean mBlockNativeResponder;
        private final boolean mClearResponder;

        public ChangeJSResponderOperation(int tag, int initialTag, boolean clearResponder, boolean blockNativeResponder) {
            super(tag);
            this.mInitialTag = initialTag;
            this.mClearResponder = clearResponder;
            this.mBlockNativeResponder = blockNativeResponder;
        }

        @Override
        public void execute() {
            if (!this.mClearResponder) {
                UIViewOperationQueue.this.mNativeViewHierarchyManager.setJSResponder(this.mTag, this.mInitialTag, this.mBlockNativeResponder);
            } else {
                UIViewOperationQueue.this.mNativeViewHierarchyManager.clearJSResponder();
            }
        }
    }

    private final class UpdateViewExtraData
    extends ViewOperation {
        private final Object mExtraData;

        public UpdateViewExtraData(int tag, Object extraData) {
            super(tag);
            this.mExtraData = extraData;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.updateViewExtraData(this.mTag, this.mExtraData);
        }
    }

    private final class SetChildrenOperation
    extends ViewOperation {
        private final ReadableArray mChildrenTags;

        public SetChildrenOperation(int tag, ReadableArray childrenTags) {
            super(tag);
            this.mChildrenTags = childrenTags;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.setChildren(this.mTag, this.mChildrenTags);
        }
    }

    private final class ManageChildrenOperation
    extends ViewOperation {
        @Nullable
        private final int[] mIndicesToRemove;
        @Nullable
        private final ViewAtIndex[] mViewsToAdd;
        @Nullable
        private final int[] mTagsToDelete;

        public ManageChildrenOperation(@Nullable int tag, @Nullable int[] indicesToRemove, @Nullable ViewAtIndex[] viewsToAdd, int[] tagsToDelete) {
            super(tag);
            this.mIndicesToRemove = indicesToRemove;
            this.mViewsToAdd = viewsToAdd;
            this.mTagsToDelete = tagsToDelete;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.manageChildren(this.mTag, this.mIndicesToRemove, this.mViewsToAdd, this.mTagsToDelete);
        }
    }

    private final class CreateViewOperation
    extends ViewOperation {
        private final ThemedReactContext mThemedContext;
        private final String mClassName;
        @Nullable
        private final ReactStylesDiffMap mInitialProps;

        public CreateViewOperation(ThemedReactContext themedContext, int tag, @Nullable String className, ReactStylesDiffMap initialProps) {
            super(tag);
            this.mThemedContext = themedContext;
            this.mClassName = className;
            this.mInitialProps = initialProps;
            Systrace.startAsyncFlow(0L, "createView", this.mTag);
        }

        @Override
        public void execute() {
            Systrace.endAsyncFlow(0L, "createView", this.mTag);
            UIViewOperationQueue.this.mNativeViewHierarchyManager.createView(this.mThemedContext, this.mTag, this.mClassName, this.mInitialProps);
        }
    }

    private final class UpdateLayoutOperation
    extends ViewOperation {
        private final int mParentTag;
        private final int mX;
        private final int mY;
        private final int mWidth;
        private final int mHeight;

        public UpdateLayoutOperation(int parentTag, int tag, int x, int y, int width, int height) {
            super(tag);
            this.mParentTag = parentTag;
            this.mX = x;
            this.mY = y;
            this.mWidth = width;
            this.mHeight = height;
            Systrace.startAsyncFlow(0L, "updateLayout", this.mTag);
        }

        @Override
        public void execute() {
            Systrace.endAsyncFlow(0L, "updateLayout", this.mTag);
            UIViewOperationQueue.this.mNativeViewHierarchyManager.updateLayout(this.mParentTag, this.mTag, this.mX, this.mY, this.mWidth, this.mHeight);
        }
    }

    private final class UpdateInstanceHandleOperation
    extends ViewOperation {
        private final long mInstanceHandle;

        private UpdateInstanceHandleOperation(int tag, long instanceHandle) {
            super(tag);
            this.mInstanceHandle = instanceHandle;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.updateInstanceHandle(this.mTag, this.mInstanceHandle);
        }
    }

    private final class EmitOnLayoutEventOperation
    extends ViewOperation {
        private final int mScreenX;
        private final int mScreenY;
        private final int mScreenWidth;
        private final int mScreenHeight;

        public EmitOnLayoutEventOperation(int tag, int screenX, int screenY, int screenWidth, int screenHeight) {
            super(tag);
            this.mScreenX = screenX;
            this.mScreenY = screenY;
            this.mScreenWidth = screenWidth;
            this.mScreenHeight = screenHeight;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mReactApplicationContext.getNativeModule(UIManagerModule.class).getEventDispatcher().dispatchEvent(OnLayoutEvent.obtain(this.mTag, this.mScreenX, this.mScreenY, this.mScreenWidth, this.mScreenHeight));
        }
    }

    private final class UpdatePropertiesOperation
    extends ViewOperation {
        private final ReactStylesDiffMap mProps;

        private UpdatePropertiesOperation(int tag, ReactStylesDiffMap props) {
            super(tag);
            this.mProps = props;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.updateProperties(this.mTag, this.mProps);
        }
    }

    private final class RemoveRootViewOperation
    extends ViewOperation {
        public RemoveRootViewOperation(int tag) {
            super(tag);
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.removeRootView(this.mTag);
        }
    }

    private abstract class ViewOperation
    implements UIOperation {
        public int mTag;

        public ViewOperation(int tag) {
            this.mTag = tag;
        }
    }

    public static interface UIOperation {
        public void execute();
    }
}

