/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.content.Context;
import android.os.SystemClock;
import android.view.View;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.animation.Animation;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.modules.i18nmanager.I18nUtil;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.NativeViewHierarchyManager;
import com.facebook.react.uimanager.NativeViewHierarchyOptimizer;
import com.facebook.react.uimanager.OnLayoutEvent;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ReactShadowNodeImpl;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.ShadowNodeRegistry;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIBlock;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.UIViewOperationQueue;
import com.facebook.react.uimanager.ViewAtIndex;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.ViewManagerRegistry;
import com.facebook.react.uimanager.common.MeasureSpecProvider;
import com.facebook.react.uimanager.common.SizeMonitoringFrameLayout;
import com.facebook.react.uimanager.debug.NotThreadSafeViewHierarchyUpdateDebugListener;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.systrace.Systrace;
import com.facebook.systrace.SystraceMessage;
import com.facebook.yoga.YogaDirection;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class UIImplementation {
    protected Object uiImplementationThreadLock = new Object();
    protected final EventDispatcher mEventDispatcher;
    protected final ReactApplicationContext mReactContext;
    protected final ShadowNodeRegistry mShadowNodeRegistry = new ShadowNodeRegistry();
    private final Set<Integer> mMeasuredRootNodes = new HashSet<Integer>();
    private final ViewManagerRegistry mViewManagers;
    private final UIViewOperationQueue mOperationsQueue;
    private final NativeViewHierarchyOptimizer mNativeViewHierarchyOptimizer;
    private final int[] mMeasureBuffer = new int[4];
    private long mLastCalculateLayoutTime = 0L;
    @Nullable
    protected LayoutUpdateListener mLayoutUpdateListener;

    public UIImplementation(ReactApplicationContext reactContext, UIManagerModule.ViewManagerResolver viewManagerResolver, EventDispatcher eventDispatcher, int minTimeLeftInFrameForNonBatchedOperationMs) {
        this(reactContext, new ViewManagerRegistry(viewManagerResolver), eventDispatcher, minTimeLeftInFrameForNonBatchedOperationMs);
    }

    public UIImplementation(ReactApplicationContext reactContext, List<ViewManager> viewManagers, EventDispatcher eventDispatcher, int minTimeLeftInFrameForNonBatchedOperationMs) {
        this(reactContext, new ViewManagerRegistry(viewManagers), eventDispatcher, minTimeLeftInFrameForNonBatchedOperationMs);
    }

    UIImplementation(ReactApplicationContext reactContext, ViewManagerRegistry viewManagers, EventDispatcher eventDispatcher, int minTimeLeftInFrameForNonBatchedOperationMs) {
        this(reactContext, viewManagers, new UIViewOperationQueue(reactContext, new NativeViewHierarchyManager(viewManagers), minTimeLeftInFrameForNonBatchedOperationMs), eventDispatcher);
    }

    protected UIImplementation(ReactApplicationContext reactContext, ViewManagerRegistry viewManagers, UIViewOperationQueue operationsQueue, EventDispatcher eventDispatcher) {
        this.mReactContext = reactContext;
        this.mViewManagers = viewManagers;
        this.mOperationsQueue = operationsQueue;
        this.mNativeViewHierarchyOptimizer = new NativeViewHierarchyOptimizer(this.mOperationsQueue, this.mShadowNodeRegistry);
        this.mEventDispatcher = eventDispatcher;
    }

    protected ReactShadowNode createRootShadowNode() {
        ReactShadowNodeImpl rootCSSNode = new ReactShadowNodeImpl();
        I18nUtil sharedI18nUtilInstance = I18nUtil.getInstance();
        if (sharedI18nUtilInstance.isRTL((Context)this.mReactContext)) {
            rootCSSNode.setLayoutDirection(YogaDirection.RTL);
        }
        rootCSSNode.setViewClassName("Root");
        return rootCSSNode;
    }

    protected ReactShadowNode createShadowNode(String className) {
        ViewManager viewManager = this.mViewManagers.get(className);
        return viewManager.createShadowNodeInstance(this.mReactContext);
    }

    public final ReactShadowNode resolveShadowNode(int reactTag) {
        return this.mShadowNodeRegistry.getNode(reactTag);
    }

    protected final ViewManager resolveViewManager(String className) {
        return this.mViewManagers.get(className);
    }

    UIViewOperationQueue getUIViewOperationQueue() {
        return this.mOperationsQueue;
    }

    public void updateRootView(int tag, int widthMeasureSpec, int heightMeasureSpec) {
        ReactShadowNode rootCSSNode = this.mShadowNodeRegistry.getNode(tag);
        if (rootCSSNode == null) {
            FLog.w((String)"ReactNative", (String)("Tried to update non-existent root tag: " + tag));
            return;
        }
        this.updateRootView(rootCSSNode, widthMeasureSpec, heightMeasureSpec);
    }

    public void updateRootView(ReactShadowNode rootCSSNode, int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        switch (widthMode) {
            case 0x40000000: {
                rootCSSNode.setStyleWidth(widthSize);
                break;
            }
            case -2147483648: {
                rootCSSNode.setStyleMaxWidth(widthSize);
                break;
            }
            case 0: {
                rootCSSNode.setStyleWidthAuto();
            }
        }
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        switch (heightMode) {
            case 0x40000000: {
                rootCSSNode.setStyleHeight(heightSize);
                break;
            }
            case -2147483648: {
                rootCSSNode.setStyleMaxHeight(heightSize);
                break;
            }
            case 0: {
                rootCSSNode.setStyleHeightAuto();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends SizeMonitoringFrameLayout> void registerRootView(T rootView, int tag, ThemedReactContext context) {
        Object object = this.uiImplementationThreadLock;
        synchronized (object) {
            final ReactShadowNode rootCSSNode = this.createRootShadowNode();
            rootCSSNode.setReactTag(tag);
            rootCSSNode.setThemedContext(context);
            int widthMeasureSpec = ((MeasureSpecProvider)((Object)rootView)).getWidthMeasureSpec();
            int heightMeasureSpec = ((MeasureSpecProvider)((Object)rootView)).getHeightMeasureSpec();
            this.updateRootView(rootCSSNode, widthMeasureSpec, heightMeasureSpec);
            context.runOnNativeModulesQueueThread(new Runnable(){

                @Override
                public void run() {
                    UIImplementation.this.mShadowNodeRegistry.addRootNode(rootCSSNode);
                }
            });
            this.mOperationsQueue.addRootView(tag, rootView, context);
        }
    }

    public void removeRootView(int rootViewTag) {
        this.removeRootShadowNode(rootViewTag);
        this.mOperationsQueue.enqueueRemoveRootView(rootViewTag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRootShadowNode(int rootViewTag) {
        Object object = this.uiImplementationThreadLock;
        synchronized (object) {
            this.mShadowNodeRegistry.removeRootNode(rootViewTag);
        }
    }

    public void updateNodeSize(int nodeViewTag, int newWidth, int newHeight) {
        ReactShadowNode cssNode = this.mShadowNodeRegistry.getNode(nodeViewTag);
        if (cssNode == null) {
            FLog.w((String)"ReactNative", (String)("Tried to update size of non-existent tag: " + nodeViewTag));
            return;
        }
        cssNode.setStyleWidth(newWidth);
        cssNode.setStyleHeight(newHeight);
        this.dispatchViewUpdatesIfNeeded();
    }

    public void setViewLocalData(int tag, Object data) {
        ReactShadowNode shadowNode = this.mShadowNodeRegistry.getNode(tag);
        if (shadowNode == null) {
            FLog.w((String)"ReactNative", (String)("Attempt to set local data for view with unknown tag: " + tag));
            return;
        }
        shadowNode.setLocalData(data);
        this.dispatchViewUpdatesIfNeeded();
    }

    public void profileNextBatch() {
        this.mOperationsQueue.profileNextBatch();
    }

    public Map<String, Long> getProfiledBatchPerfCounters() {
        return this.mOperationsQueue.getProfiledBatchPerfCounters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createView(int tag, String className, int rootViewTag, ReadableMap props) {
        Object object = this.uiImplementationThreadLock;
        synchronized (object) {
            ReactShadowNode cssNode = this.createShadowNode(className);
            ReactShadowNode rootNode = this.mShadowNodeRegistry.getNode(rootViewTag);
            Assertions.assertNotNull((Object)rootNode, (String)("Root node with tag " + rootViewTag + " doesn't exist"));
            cssNode.setReactTag(tag);
            cssNode.setViewClassName(className);
            cssNode.setRootTag(rootNode.getReactTag());
            cssNode.setThemedContext(rootNode.getThemedContext());
            this.mShadowNodeRegistry.addNode(cssNode);
            ReactStylesDiffMap styles = null;
            if (props != null) {
                styles = new ReactStylesDiffMap(props);
                cssNode.updateProperties(styles);
            }
            this.handleCreateView(cssNode, rootViewTag, styles);
        }
    }

    protected void handleCreateView(ReactShadowNode cssNode, int rootViewTag, @Nullable ReactStylesDiffMap styles) {
        if (!cssNode.isVirtual()) {
            this.mNativeViewHierarchyOptimizer.handleCreateView(cssNode, cssNode.getThemedContext(), styles);
        }
    }

    public void updateView(int tag, String className, ReadableMap props) {
        ViewManager viewManager = this.mViewManagers.get(className);
        if (viewManager == null) {
            throw new IllegalViewOperationException("Got unknown view type: " + className);
        }
        ReactShadowNode cssNode = this.mShadowNodeRegistry.getNode(tag);
        if (cssNode == null) {
            throw new IllegalViewOperationException("Trying to update non-existent view with tag " + tag);
        }
        if (props != null) {
            ReactStylesDiffMap styles = new ReactStylesDiffMap(props);
            cssNode.updateProperties(styles);
            this.handleUpdateView(cssNode, className, styles);
        }
    }

    public void synchronouslyUpdateViewOnUIThread(int tag, ReactStylesDiffMap props) {
        UiThreadUtil.assertOnUiThread();
        this.mOperationsQueue.getNativeViewHierarchyManager().updateProperties(tag, props);
    }

    protected void handleUpdateView(ReactShadowNode cssNode, String className, ReactStylesDiffMap styles) {
        if (!cssNode.isVirtual()) {
            this.mNativeViewHierarchyOptimizer.handleUpdateView(cssNode, className, styles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void manageChildren(int viewTag, @Nullable ReadableArray moveFrom, @Nullable ReadableArray moveTo, @Nullable ReadableArray addChildTags, @Nullable ReadableArray addAtIndices, @Nullable ReadableArray removeFrom) {
        Object object = this.uiImplementationThreadLock;
        synchronized (object) {
            int i;
            int i2;
            int numToRemove;
            ReactShadowNode cssNodeToManage = this.mShadowNodeRegistry.getNode(viewTag);
            int numToMove = moveFrom == null ? 0 : moveFrom.size();
            int numToAdd = addChildTags == null ? 0 : addChildTags.size();
            int n = numToRemove = removeFrom == null ? 0 : removeFrom.size();
            if (numToMove != 0 && (moveTo == null || numToMove != moveTo.size())) {
                throw new IllegalViewOperationException("Size of moveFrom != size of moveTo!");
            }
            if (numToAdd != 0 && (addAtIndices == null || numToAdd != addAtIndices.size())) {
                throw new IllegalViewOperationException("Size of addChildTags != size of addAtIndices!");
            }
            ViewAtIndex[] viewsToAdd = new ViewAtIndex[numToMove + numToAdd];
            int[] indicesToRemove = new int[numToMove + numToRemove];
            int[] tagsToRemove = new int[indicesToRemove.length];
            int[] tagsToDelete = new int[numToRemove];
            if (numToMove > 0) {
                Assertions.assertNotNull((Object)moveFrom);
                Assertions.assertNotNull((Object)moveTo);
                for (i2 = 0; i2 < numToMove; ++i2) {
                    int moveFromIndex = moveFrom.getInt(i2);
                    int tagToMove = cssNodeToManage.getChildAt(moveFromIndex).getReactTag();
                    viewsToAdd[i2] = new ViewAtIndex(tagToMove, moveTo.getInt(i2));
                    indicesToRemove[i2] = moveFromIndex;
                    tagsToRemove[i2] = tagToMove;
                }
            }
            if (numToAdd > 0) {
                Assertions.assertNotNull((Object)addChildTags);
                Assertions.assertNotNull((Object)addAtIndices);
                for (i2 = 0; i2 < numToAdd; ++i2) {
                    int viewTagToAdd = addChildTags.getInt(i2);
                    int indexToAddAt = addAtIndices.getInt(i2);
                    viewsToAdd[numToMove + i2] = new ViewAtIndex(viewTagToAdd, indexToAddAt);
                }
            }
            if (numToRemove > 0) {
                Assertions.assertNotNull((Object)removeFrom);
                for (i2 = 0; i2 < numToRemove; ++i2) {
                    int indexToRemove = removeFrom.getInt(i2);
                    int tagToRemove = cssNodeToManage.getChildAt(indexToRemove).getReactTag();
                    indicesToRemove[numToMove + i2] = indexToRemove;
                    tagsToRemove[numToMove + i2] = tagToRemove;
                    tagsToDelete[i2] = tagToRemove;
                }
            }
            Arrays.sort(viewsToAdd, ViewAtIndex.COMPARATOR);
            Arrays.sort(indicesToRemove);
            int lastIndexRemoved = -1;
            for (i = indicesToRemove.length - 1; i >= 0; --i) {
                int indexToRemove = indicesToRemove[i];
                if (indexToRemove == lastIndexRemoved) {
                    throw new IllegalViewOperationException("Repeated indices in Removal list for view tag: " + viewTag);
                }
                cssNodeToManage.removeChildAt(indicesToRemove[i]);
                lastIndexRemoved = indicesToRemove[i];
            }
            for (i = 0; i < viewsToAdd.length; ++i) {
                ViewAtIndex viewAtIndex = viewsToAdd[i];
                ReactShadowNode cssNodeToAdd = this.mShadowNodeRegistry.getNode(viewAtIndex.mTag);
                if (cssNodeToAdd == null) {
                    throw new IllegalViewOperationException("Trying to add unknown view tag: " + viewAtIndex.mTag);
                }
                cssNodeToManage.addChildAt(cssNodeToAdd, viewAtIndex.mIndex);
            }
            if (!cssNodeToManage.isVirtual() && !cssNodeToManage.isVirtualAnchor()) {
                this.mNativeViewHierarchyOptimizer.handleManageChildren(cssNodeToManage, indicesToRemove, tagsToRemove, viewsToAdd, tagsToDelete);
            }
            for (i = 0; i < tagsToDelete.length; ++i) {
                this.removeShadowNode(this.mShadowNodeRegistry.getNode(tagsToDelete[i]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChildren(int viewTag, ReadableArray childrenTags) {
        Object object = this.uiImplementationThreadLock;
        synchronized (object) {
            ReactShadowNode cssNodeToManage = this.mShadowNodeRegistry.getNode(viewTag);
            for (int i = 0; i < childrenTags.size(); ++i) {
                ReactShadowNode cssNodeToAdd = this.mShadowNodeRegistry.getNode(childrenTags.getInt(i));
                if (cssNodeToAdd == null) {
                    throw new IllegalViewOperationException("Trying to add unknown view tag: " + childrenTags.getInt(i));
                }
                cssNodeToManage.addChildAt(cssNodeToAdd, i);
            }
            if (!cssNodeToManage.isVirtual() && !cssNodeToManage.isVirtualAnchor()) {
                this.mNativeViewHierarchyOptimizer.handleSetChildren(cssNodeToManage, childrenTags);
            }
        }
    }

    public void replaceExistingNonRootView(int oldTag, int newTag) {
        if (this.mShadowNodeRegistry.isRootNode(oldTag) || this.mShadowNodeRegistry.isRootNode(newTag)) {
            throw new IllegalViewOperationException("Trying to add or replace a root tag!");
        }
        ReactShadowNode oldNode = this.mShadowNodeRegistry.getNode(oldTag);
        if (oldNode == null) {
            throw new IllegalViewOperationException("Trying to replace unknown view tag: " + oldTag);
        }
        ReactShadowNode parent = oldNode.getParent();
        if (parent == null) {
            throw new IllegalViewOperationException("Node is not attached to a parent: " + oldTag);
        }
        int oldIndex = parent.indexOf((ReactShadowNode)oldNode);
        if (oldIndex < 0) {
            throw new IllegalStateException("Didn't find child tag in parent");
        }
        WritableArray tagsToAdd = Arguments.createArray();
        tagsToAdd.pushInt(newTag);
        WritableArray addAtIndices = Arguments.createArray();
        addAtIndices.pushInt(oldIndex);
        WritableArray indicesToRemove = Arguments.createArray();
        indicesToRemove.pushInt(oldIndex);
        this.manageChildren(parent.getReactTag(), null, null, tagsToAdd, addAtIndices, indicesToRemove);
    }

    public void removeSubviewsFromContainerWithID(int containerTag) {
        ReactShadowNode containerNode = this.mShadowNodeRegistry.getNode(containerTag);
        if (containerNode == null) {
            throw new IllegalViewOperationException("Trying to remove subviews of an unknown view tag: " + containerTag);
        }
        WritableArray indicesToRemove = Arguments.createArray();
        for (int childIndex = 0; childIndex < containerNode.getChildCount(); ++childIndex) {
            indicesToRemove.pushInt(childIndex);
        }
        this.manageChildren(containerTag, null, null, null, null, indicesToRemove);
    }

    public void findSubviewIn(int reactTag, float targetX, float targetY, Callback callback) {
        this.mOperationsQueue.enqueueFindTargetForTouch(reactTag, targetX, targetY, callback);
    }

    public void viewIsDescendantOf(int reactTag, int ancestorReactTag, Callback callback) {
        ReactShadowNode node = this.mShadowNodeRegistry.getNode(reactTag);
        ReactShadowNode ancestorNode = this.mShadowNodeRegistry.getNode(ancestorReactTag);
        if (node == null || ancestorNode == null) {
            callback.invoke(false);
            return;
        }
        callback.invoke(node.isDescendantOf(ancestorNode));
    }

    public void measure(int reactTag, Callback callback) {
        this.mOperationsQueue.enqueueMeasure(reactTag, callback);
    }

    public void measureInWindow(int reactTag, Callback callback) {
        this.mOperationsQueue.enqueueMeasureInWindow(reactTag, callback);
    }

    public void measureLayout(int tag, int ancestorTag, Callback errorCallback, Callback successCallback) {
        try {
            this.measureLayout(tag, ancestorTag, this.mMeasureBuffer);
            float relativeX = PixelUtil.toDIPFromPixel(this.mMeasureBuffer[0]);
            float relativeY = PixelUtil.toDIPFromPixel(this.mMeasureBuffer[1]);
            float width = PixelUtil.toDIPFromPixel(this.mMeasureBuffer[2]);
            float height = PixelUtil.toDIPFromPixel(this.mMeasureBuffer[3]);
            successCallback.invoke(Float.valueOf(relativeX), Float.valueOf(relativeY), Float.valueOf(width), Float.valueOf(height));
        }
        catch (IllegalViewOperationException e) {
            errorCallback.invoke(e.getMessage());
        }
    }

    public void measureLayoutRelativeToParent(int tag, Callback errorCallback, Callback successCallback) {
        try {
            this.measureLayoutRelativeToParent(tag, this.mMeasureBuffer);
            float relativeX = PixelUtil.toDIPFromPixel(this.mMeasureBuffer[0]);
            float relativeY = PixelUtil.toDIPFromPixel(this.mMeasureBuffer[1]);
            float width = PixelUtil.toDIPFromPixel(this.mMeasureBuffer[2]);
            float height = PixelUtil.toDIPFromPixel(this.mMeasureBuffer[3]);
            successCallback.invoke(Float.valueOf(relativeX), Float.valueOf(relativeY), Float.valueOf(width), Float.valueOf(height));
        }
        catch (IllegalViewOperationException e) {
            errorCallback.invoke(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchViewUpdates(int batchId) {
        SystraceMessage.beginSection(0L, "UIImplementation.dispatchViewUpdates").arg("batchId", batchId).flush();
        long commitStartTime = SystemClock.uptimeMillis();
        try {
            this.updateViewHierarchy();
            this.mNativeViewHierarchyOptimizer.onBatchComplete();
            this.mOperationsQueue.dispatchViewUpdates(batchId, commitStartTime, this.mLastCalculateLayoutTime);
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    private void dispatchViewUpdatesIfNeeded() {
        if (this.mOperationsQueue.isEmpty()) {
            this.dispatchViewUpdates(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateViewHierarchy() {
        Systrace.beginSection(0L, "UIImplementation.updateViewHierarchy");
        try {
            for (int i = 0; i < this.mShadowNodeRegistry.getRootNodeCount(); ++i) {
                int tag = this.mShadowNodeRegistry.getRootTag(i);
                ReactShadowNode cssRoot = this.mShadowNodeRegistry.getNode(tag);
                if (!this.mMeasuredRootNodes.contains(tag)) continue;
                SystraceMessage.beginSection(0L, "UIImplementation.notifyOnBeforeLayoutRecursive").arg("rootTag", cssRoot.getReactTag()).flush();
                try {
                    this.notifyOnBeforeLayoutRecursive(cssRoot);
                }
                finally {
                    Systrace.endSection(0L);
                }
                this.calculateRootLayout(cssRoot);
                SystraceMessage.beginSection(0L, "UIImplementation.applyUpdatesRecursive").arg("rootTag", cssRoot.getReactTag()).flush();
                try {
                    this.applyUpdatesRecursive(cssRoot, 0.0f, 0.0f);
                }
                finally {
                    Systrace.endSection(0L);
                }
                if (this.mLayoutUpdateListener == null) continue;
                this.mOperationsQueue.enqueueLayoutUpdateFinished(cssRoot, this.mLayoutUpdateListener);
            }
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    public void registerAnimation(Animation animation) {
        this.mOperationsQueue.enqueueRegisterAnimation(animation);
    }

    public void addAnimation(int reactTag, int animationID, Callback onSuccess) {
        this.assertViewExists(reactTag, "addAnimation");
        this.mOperationsQueue.enqueueAddAnimation(reactTag, animationID, onSuccess);
    }

    public void removeAnimation(int reactTag, int animationID) {
        this.assertViewExists(reactTag, "removeAnimation");
        this.mOperationsQueue.enqueueRemoveAnimation(animationID);
    }

    public void setLayoutAnimationEnabledExperimental(boolean enabled) {
        this.mOperationsQueue.enqueueSetLayoutAnimationEnabled(enabled);
    }

    public void configureNextLayoutAnimation(ReadableMap config, Callback success, Callback error) {
        this.mOperationsQueue.enqueueConfigureLayoutAnimation(config, success, error);
    }

    public void setJSResponder(int reactTag, boolean blockNativeResponder) {
        ReactShadowNode node = this.mShadowNodeRegistry.getNode(reactTag);
        if (node == null) {
            return;
        }
        while (node.isVirtual() || node.isLayoutOnly()) {
            node = node.getParent();
        }
        this.mOperationsQueue.enqueueSetJSResponder(node.getReactTag(), reactTag, blockNativeResponder);
    }

    public void clearJSResponder() {
        this.mOperationsQueue.enqueueClearJSResponder();
    }

    public void dispatchViewManagerCommand(int reactTag, int commandId, @Nullable ReadableArray commandArgs) {
        this.assertViewExists(reactTag, "dispatchViewManagerCommand");
        this.mOperationsQueue.enqueueDispatchCommand(reactTag, commandId, commandArgs);
    }

    public void showPopupMenu(int reactTag, ReadableArray items, Callback error, Callback success) {
        this.assertViewExists(reactTag, "showPopupMenu");
        this.mOperationsQueue.enqueueShowPopupMenu(reactTag, items, error, success);
    }

    public void dismissPopupMenu() {
        this.mOperationsQueue.enqueueDismissPopupMenu();
    }

    public void sendAccessibilityEvent(int tag, int eventType) {
        this.mOperationsQueue.enqueueSendAccessibilityEvent(tag, eventType);
    }

    public void onHostResume() {
        this.mOperationsQueue.resumeFrameCallback();
    }

    public void onHostPause() {
        this.mOperationsQueue.pauseFrameCallback();
    }

    public void onHostDestroy() {
    }

    public void setViewHierarchyUpdateDebugListener(@Nullable NotThreadSafeViewHierarchyUpdateDebugListener listener) {
        this.mOperationsQueue.setViewHierarchyUpdateDebugListener(listener);
    }

    protected final void removeShadowNode(ReactShadowNode nodeToRemove) {
        this.removeShadowNodeRecursive(nodeToRemove);
        nodeToRemove.dispose();
    }

    private void removeShadowNodeRecursive(ReactShadowNode nodeToRemove) {
        NativeViewHierarchyOptimizer.handleRemoveNode(nodeToRemove);
        this.mShadowNodeRegistry.removeNode(nodeToRemove.getReactTag());
        this.mMeasuredRootNodes.remove(nodeToRemove.getReactTag());
        for (int i = nodeToRemove.getChildCount() - 1; i >= 0; --i) {
            this.removeShadowNodeRecursive((ReactShadowNode)nodeToRemove.getChildAt(i));
        }
        nodeToRemove.removeAndDisposeAllChildren();
    }

    private void measureLayout(int tag, int ancestorTag, int[] outputBuffer) {
        ReactShadowNode node = this.mShadowNodeRegistry.getNode(tag);
        ReactShadowNode ancestor = this.mShadowNodeRegistry.getNode(ancestorTag);
        if (node == null || ancestor == null) {
            throw new IllegalViewOperationException("Tag " + (node == null ? tag : ancestorTag) + " does not exist");
        }
        if (node != ancestor) {
            for (Object currentParent = node.getParent(); currentParent != ancestor; currentParent = currentParent.getParent()) {
                if (currentParent != null) continue;
                throw new IllegalViewOperationException("Tag " + ancestorTag + " is not an ancestor of tag " + tag);
            }
        }
        this.measureLayoutRelativeToVerifiedAncestor(node, ancestor, outputBuffer);
    }

    private void measureLayoutRelativeToParent(int tag, int[] outputBuffer) {
        ReactShadowNode node = this.mShadowNodeRegistry.getNode(tag);
        if (node == null) {
            throw new IllegalViewOperationException("No native view for tag " + tag + " exists!");
        }
        Object parent = node.getParent();
        if (parent == null) {
            throw new IllegalViewOperationException("View with tag " + tag + " doesn't have a parent!");
        }
        this.measureLayoutRelativeToVerifiedAncestor(node, (ReactShadowNode)parent, outputBuffer);
    }

    private void measureLayoutRelativeToVerifiedAncestor(ReactShadowNode node, ReactShadowNode ancestor, int[] outputBuffer) {
        int offsetX = 0;
        int offsetY = 0;
        if (node != ancestor) {
            offsetX = Math.round(node.getLayoutX());
            offsetY = Math.round(node.getLayoutY());
            for (Object current = node.getParent(); current != ancestor; current = current.getParent()) {
                Assertions.assertNotNull(current);
                this.assertNodeDoesNotNeedCustomLayoutForChildren((ReactShadowNode)current);
                offsetX += Math.round(current.getLayoutX());
                offsetY += Math.round(current.getLayoutY());
            }
            this.assertNodeDoesNotNeedCustomLayoutForChildren(ancestor);
        }
        outputBuffer[0] = offsetX;
        outputBuffer[1] = offsetY;
        outputBuffer[2] = node.getScreenWidth();
        outputBuffer[3] = node.getScreenHeight();
    }

    private void assertViewExists(int reactTag, String operationNameForExceptionMessage) {
        if (this.mShadowNodeRegistry.getNode(reactTag) == null) {
            throw new IllegalViewOperationException("Unable to execute operation " + operationNameForExceptionMessage + " on view with tag: " + reactTag + ", since the view does not exists");
        }
    }

    private void assertNodeDoesNotNeedCustomLayoutForChildren(ReactShadowNode node) {
        ViewManager viewManager = (ViewManager)Assertions.assertNotNull((Object)this.mViewManagers.get(node.getViewClass()));
        if (!(viewManager instanceof ViewGroupManager)) {
            throw new IllegalViewOperationException("Trying to use view " + node.getViewClass() + " as a parent, but its Manager doesn't extends ViewGroupManager");
        }
        ViewGroupManager viewGroupManager = (ViewGroupManager)viewManager;
        if (viewGroupManager != null && viewGroupManager.needsCustomLayoutForChildren()) {
            throw new IllegalViewOperationException("Trying to measure a view using measureLayout/measureLayoutRelativeToParent relative to an ancestor that requires custom layout for it's children (" + node.getViewClass() + "). Use measure instead.");
        }
    }

    private void notifyOnBeforeLayoutRecursive(ReactShadowNode cssNode) {
        if (!cssNode.hasUpdates()) {
            return;
        }
        for (int i = 0; i < cssNode.getChildCount(); ++i) {
            this.notifyOnBeforeLayoutRecursive((ReactShadowNode)cssNode.getChildAt(i));
        }
        cssNode.onBeforeLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculateRootLayout(ReactShadowNode cssRoot) {
        SystraceMessage.beginSection(0L, "cssRoot.calculateLayout").arg("rootTag", cssRoot.getReactTag()).flush();
        long startTime = SystemClock.uptimeMillis();
        try {
            cssRoot.calculateLayout();
        }
        finally {
            Systrace.endSection(0L);
            this.mLastCalculateLayoutTime = SystemClock.uptimeMillis() - startTime;
        }
    }

    protected void applyUpdatesRecursive(ReactShadowNode cssNode, float absoluteX, float absoluteY) {
        boolean frameDidChange;
        int tag;
        if (!cssNode.hasUpdates()) {
            return;
        }
        if (!cssNode.isVirtualAnchor()) {
            for (int i = 0; i < cssNode.getChildCount(); ++i) {
                this.applyUpdatesRecursive((ReactShadowNode)cssNode.getChildAt(i), absoluteX + cssNode.getLayoutX(), absoluteY + cssNode.getLayoutY());
            }
        }
        if (!this.mShadowNodeRegistry.isRootNode(tag = cssNode.getReactTag()) && (frameDidChange = cssNode.dispatchUpdates(absoluteX, absoluteY, this.mOperationsQueue, this.mNativeViewHierarchyOptimizer)) && cssNode.shouldNotifyOnLayout()) {
            this.mEventDispatcher.dispatchEvent(OnLayoutEvent.obtain(tag, cssNode.getScreenX(), cssNode.getScreenY(), cssNode.getScreenWidth(), cssNode.getScreenHeight()));
        }
        cssNode.markUpdateSeen();
    }

    public void addUIBlock(UIBlock block) {
        this.mOperationsQueue.enqueueUIBlock(block);
    }

    public void prependUIBlock(UIBlock block) {
        this.mOperationsQueue.prependUIBlock(block);
    }

    public int resolveRootTagFromReactTag(int reactTag) {
        if (this.mShadowNodeRegistry.isRootNode(reactTag)) {
            return reactTag;
        }
        ReactShadowNode node = this.resolveShadowNode(reactTag);
        int rootTag = 0;
        if (node != null) {
            rootTag = node.getRootTag();
        } else {
            FLog.w((String)"ReactNative", (String)("Warning : attempted to resolve a non-existent react shadow node. reactTag=" + reactTag));
        }
        return rootTag;
    }

    public void enableLayoutCalculationForRootNode(int rootViewTag) {
        this.mMeasuredRootNodes.add(rootViewTag);
    }

    public void setLayoutUpdateListener(LayoutUpdateListener listener) {
        this.mLayoutUpdateListener = listener;
    }

    public void removeLayoutUpdateListener() {
        this.mLayoutUpdateListener = null;
    }

    public static interface LayoutUpdateListener {
        public void onLayoutUpdated(ReactShadowNode var1);
    }
}

